/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.EqualNull$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.InheritAnalysisRules;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr1, expr2) - Returns same result as the EQUAL(=) operator for non-null operands,\n      but returns true if both are null, false if one of the them is null.\n  ", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(3, 3);\n       true\n      > SELECT _FUNC_(1, '11');\n       false\n      > SELECT _FUNC_(true, NULL);\n       false\n      > SELECT _FUNC_(NULL, 'abc');\n       false\n      > SELECT _FUNC_(NULL, NULL);\n       true\n  ", since="3.4.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005g\u0001\u0002\u0010 \u00012B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005[!AA\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005N\u0001\tE\t\u0015!\u0003.\u0011!q\u0005A!f\u0001\n\u0003Q\u0005\u0002C(\u0001\u0005#\u0005\u000b\u0011B\u0017\t\u000bA\u0003A\u0011A)\t\u000bA\u0003A\u0011\u0001,\t\u000be\u0003A\u0011\t.\t\u000b\r\u0004A\u0011\t3\t\u000b!\u0004A\u0011K5\t\u000f1\u0004\u0011\u0011!C\u0001[\"9\u0011\u000fAI\u0001\n\u0003\u0011\bbB?\u0001#\u0003%\tA\u001d\u0005\b}\u0002\t\n\u0011\"\u0001s\u0011!y\b!!A\u0005B\u0005\u0005\u0001\"CA\t\u0001\u0005\u0005I\u0011AA\n\u0011%\tY\u0002AA\u0001\n\u0003\ti\u0002C\u0005\u0002*\u0001\t\t\u0011\"\u0011\u0002,!I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u000b\u0002\u0011\u0011!C!\u0003\u000fB\u0011\"a\u0013\u0001\u0003\u0003%\t%!\u0014\b\u0013\u0005]t$!A\t\u0002\u0005ed\u0001\u0003\u0010 \u0003\u0003E\t!a\u001f\t\rACB\u0011AAJ\u0011%\t)\nGA\u0001\n\u000b\n9\nC\u0005\u0002\u001ab\t\t\u0011\"!\u0002\u001c\"I\u00111\u0015\r\u0002\u0002\u0013\u0005\u0015Q\u0015\u0005\n\u0003oC\u0012\u0011!C\u0005\u0003s\u0013\u0011\"R9vC2tU\u000f\u001c7\u000b\u0005\u0001\n\u0013aC3yaJ,7o]5p]NT!AI\u0012\u0002\u0011\r\fG/\u00197zgRT!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u00172i]j\u0004C\u0001\u00180\u001b\u0005y\u0012B\u0001\u0019 \u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003]IJ!aM\u0010\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003]UJ!AN\u0010\u0003)%s\u0007.\u001a:ji\u0006s\u0017\r\\=tSN\u0014V\u000f\\3t!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010$\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\",\u0003\u0019a$o\\8u}%\t!(\u0003\u0002Fs\u00059\u0001/Y2lC\u001e,\u0017BA$I\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t)\u0015(\u0001\u0003mK\u001a$X#A\u0017\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003-\u0011X\r\u001d7bG\u0016lWM\u001c;\u0002\u0019I,\u0007\u000f\\1dK6,g\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\u0011\u00116\u000bV+\u0011\u00059\u0002\u0001\"B%\b\u0001\u0004i\u0003\"\u0002'\b\u0001\u0004i\u0003\"\u0002(\b\u0001\u0004iCc\u0001*X1\")\u0011\n\u0003a\u0001[!)A\n\u0003a\u0001[\u0005Q\u0001O]3uift\u0015-\\3\u0016\u0003m\u0003\"\u0001\u00181\u000f\u0005us\u0006C\u0001!:\u0013\ty\u0016(\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\n\u0014aa\u0015;sS:<'BA0:\u0003)\u0001\u0018M]1nKR,'o]\u000b\u0002KB\u0019aHZ\u0017\n\u0005\u001dD%aA*fc\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$\"A\u00156\t\u000b-\\\u0001\u0019A\u0017\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR!!K\\8q\u0011\u001dIE\u0002%AA\u00025Bq\u0001\u0014\u0007\u0011\u0002\u0003\u0007Q\u0006C\u0004O\u0019A\u0005\t\u0019A\u0017\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t1O\u000b\u0002.i.\nQ\u000f\u0005\u0002ww6\tqO\u0003\u0002ys\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003uf\n!\"\u00198o_R\fG/[8o\u0013\taxOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\tAA[1wC&\u0019\u0011-a\u0002\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005U\u0001c\u0001\u001d\u0002\u0018%\u0019\u0011\u0011D\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0011Q\u0005\t\u0004q\u0005\u0005\u0012bAA\u0012s\t\u0019\u0011I\\=\t\u0013\u0005\u001d\"#!AA\u0002\u0005U\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002.A1\u0011qFA\u001b\u0003?i!!!\r\u000b\u0007\u0005M\u0012(\u0001\u0006d_2dWm\u0019;j_:LA!a\u000e\u00022\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti$a\u0011\u0011\u0007a\ny$C\u0002\u0002Be\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002(Q\t\t\u00111\u0001\u0002 \u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019!!\u0013\t\u0013\u0005\u001dR#!AA\u0002\u0005U\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002>\u0005=\u0003\"CA\u0014-\u0005\u0005\t\u0019AA\u0010Q]\u0001\u00111KA-\u00037\ny&!\u0019\u0002f\u0005\u001d\u00141NA7\u0003c\n\u0019\bE\u0002/\u0003+J1!a\u0016 \u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u0018\u0002\u00037R\u0001\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(/\r\u0017!Kb\u0004(OM\u0015![\u0001\u0012V\r^;s]N\u00043/Y7fAI,7/\u001e7uA\u0005\u001c\b\u0005\u001e5fA\u0015\u000bV+\u0011'){%\u0002s\u000e]3sCR|'\u000f\t4pe\u0002rwN\\\u0017ok2d\u0007e\u001c9fe\u0006tGm\u001d\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011ckR\u0004#/\u001a;ve:\u001c\b\u0005\u001e:vK\u0002Jg\r\t2pi\"\u0004\u0013M]3!]VdG\u000e\f\u0011gC2\u001cX\rI5gA=tW\rI8gAQDW\r\t;iK6\u0004\u0013n\u001d\u0011ok2dgF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002d\u0005\u0011iF\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Kb\u0004(/\r\u0017!Kb\u0004(O\r\u0011.AQDW\r\t;x_\u0002*\u0007\u0010\u001d:fgNLwN\\:![V\u001cH\u000f\t2fAM\fW.\u001a\u0011usB,\u0007e\u001c:!G\u0006t\u0007EY3!G\u0006\u001cH/\u001a3!i>\u0004\u0013\rI2p[6|g\u000e\t;za\u0016d#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!C:$\u0007%\\;ti\u0002\u0012W\rI1!if\u0004X\r\t;iCR\u00043-\u00198!E\u0016\u0004So]3eA%t\u0007%Z9vC2LG/\u001f\u0011d_6\u0004\u0018M]5t_:t\u0003%T1qAQL\b/\u001a\u0011jg\u0002rw\u000e\u001e\u0011tkB\u0004xN\u001d;fI:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011G_J\u00043m\\7qY\u0016D\b\u0005^=qKN\u00043/^2iA\u0005\u0014(/Y=0gR\u0014Xo\u0019;-AQDW\r\t3bi\u0006\u0004C/\u001f9fg\u0002zg\r\t4jK2$7\u000fI7vgR\u0004#-\u001a\u0011pe\u0012,'/\u00192mK:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011N\u0001\u0002p*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3\u0007\f\u00114SmR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\nD\u0006I\u00142c\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t4bYN,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b;sk\u0016d\u0003ET+M\u0019&Z$\u0002\t\u0011!A\u0001\u0002\u0003EZ1mg\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006FT+M\u00192\u0002s%\u00192dO%Z$\u0002\t\u0011!A\u0001\u0002\u0003EZ1mg\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006FT+M\u00192\u0002c*\u0016'MSmR\u0001\u0005\t\u0011!A\u0001\u0002CO];f\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA8\u0003\u0015\u0019d\u0006\u000e\u00181\u0003\u00159'o\\;qC\t\t)(A\bqe\u0016$\u0017nY1uK~3WO\\2t\u0003%)\u0015/^1m\u001dVdG\u000e\u0005\u0002/1M)\u0001$! \u0002\nBA\u0011qPAC[5j#+\u0004\u0002\u0002\u0002*\u0019\u00111Q\u001d\u0002\u000fI,h\u000e^5nK&!\u0011qQAA\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0003\u0017\u000b\t*\u0004\u0002\u0002\u000e*!\u0011qRA\u0006\u0003\tIw.C\u0002H\u0003\u001b#\"!!\u001f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0001\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fI\u000bi*a(\u0002\"\")\u0011j\u0007a\u0001[!)Aj\u0007a\u0001[!)aj\u0007a\u0001[\u00059QO\\1qa2LH\u0003BAT\u0003g\u0003R\u0001OAU\u0003[K1!a+:\u0005\u0019y\u0005\u000f^5p]B1\u0001(a,.[5J1!!-:\u0005\u0019!V\u000f\u001d7fg!A\u0011Q\u0017\u000f\u0002\u0002\u0003\u0007!+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a/\u0011\t\u0005\u0015\u0011QX\u0005\u0005\u0003\u007f\u000b9A\u0001\u0004PE*,7\r\u001e")
public class EqualNull
extends Expression
implements RuntimeReplaceable,
InheritAnalysisRules,
Serializable {
    private final Expression left;
    private final Expression right;
    private final Expression replacement;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(EqualNull x$0) {
        return EqualNull$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, EqualNull> tupled() {
        return EqualNull$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, EqualNull>>> curried() {
        return EqualNull$.MODULE$.curried();
    }

    @Override
    public Expression child() {
        return InheritAnalysisRules.child$(this);
    }

    @Override
    public Iterator<Object> flatArguments() {
        return InheritAnalysisRules.flatArguments$(this);
    }

    @Override
    public String makeSQLString(Seq<String> childrenSQL) {
        return InheritAnalysisRules.makeSQLString$(this, childrenSQL);
    }

    @Override
    public final String sql() {
        return InheritAnalysisRules.sql$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        EqualNull equalNull = this;
        synchronized (equalNull) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        EqualNull equalNull = this;
        synchronized (equalNull) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if (!this.bitmap$0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    @Override
    public Expression replacement() {
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "equal_null";
    }

    @Override
    public Seq<Expression> parameters() {
        return new .colon.colon((Object)this.left(), (List)new .colon.colon((Object)this.right(), (List)Nil$.MODULE$));
    }

    @Override
    public EqualNull withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    public EqualNull copy(Expression left, Expression right, Expression replacement) {
        return new EqualNull(left, right, replacement);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Expression copy$default$3() {
        return this.replacement();
    }

    @Override
    public String productPrefix() {
        return "EqualNull";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.replacement();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualNull;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "replacement";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualNull)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualNull equalNull = (EqualNull)x$1;
        Expression expression = this.left();
        Expression expression2 = equalNull.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalNull.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replacement();
        Expression expression6 = equalNull.replacement();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!equalNull.canEqual(this)) return false;
        return true;
    }

    public EqualNull(Expression left, Expression right, Expression replacement) {
        this.left = left;
        this.right = right;
        this.replacement = replacement;
        RuntimeReplaceable.$init$(this);
        UnaryLike.$init$(this);
        InheritAnalysisRules.$init$(this);
        Statics.releaseFence();
    }

    public EqualNull(Expression left, Expression right) {
        this(left, right, new EqualNullSafe(left, right));
    }
}

