/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.UnifiedMemoryManager;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;

public final class UnifiedMemoryManager$ {
    public static final UnifiedMemoryManager$ MODULE$ = new UnifiedMemoryManager$();
    private static final int RESERVED_SYSTEM_MEMORY_BYTES = 314572800;

    private int RESERVED_SYSTEM_MEMORY_BYTES() {
        return RESERVED_SYSTEM_MEMORY_BYTES;
    }

    public UnifiedMemoryManager apply(SparkConf conf, int numCores) {
        long maxMemory = this.getMaxMemory(conf);
        return new UnifiedMemoryManager(conf, maxMemory, (long)((double)maxMemory * BoxesRunTime.unboxToDouble((Object)conf.get(package$.MODULE$.MEMORY_STORAGE_FRACTION()))), numCores);
    }

    private long getMaxMemory(SparkConf conf) {
        long executorMemory;
        long reservedMemory;
        long minSystemMemory;
        long systemMemory = BoxesRunTime.unboxToLong((Object)conf.get(Tests$.MODULE$.TEST_MEMORY()));
        if (systemMemory < (minSystemMemory = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)(reservedMemory = conf.getLong(Tests$.MODULE$.TEST_RESERVED_MEMORY().key(), conf.contains((ConfigEntry<?>)Tests$.MODULE$.IS_TESTING()) ? 0L : (long)this.RESERVED_SYSTEM_MEMORY_BYTES())) * 1.5)))) {
            throw new SparkIllegalArgumentException("INVALID_DRIVER_MEMORY", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"systemMemory"), (Object)Long.toString(systemMemory)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minSystemMemory"), (Object)Long.toString(minSystemMemory)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)package$.MODULE$.DRIVER_MEMORY().key())})));
        }
        if (conf.contains(package$.MODULE$.EXECUTOR_MEMORY()) && (executorMemory = conf.getSizeAsBytes(package$.MODULE$.EXECUTOR_MEMORY().key())) < minSystemMemory) {
            throw new SparkIllegalArgumentException("INVALID_EXECUTOR_MEMORY", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"executorMemory"), (Object)Long.toString(executorMemory)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minSystemMemory"), (Object)Long.toString(minSystemMemory)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)package$.MODULE$.EXECUTOR_MEMORY().key())})));
        }
        long usableMemory = systemMemory - reservedMemory;
        double memoryFraction = BoxesRunTime.unboxToDouble((Object)conf.get(package$.MODULE$.MEMORY_FRACTION()));
        return (long)((double)usableMemory * memoryFraction);
    }

    private UnifiedMemoryManager$() {
    }
}

