/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.spark.SparkContext;
import org.apache.spark.SpillListener;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.util.SparkTestUtils;
import org.apache.spark.util.Utils$;
import org.json4s.JValue;
import org.json4s.jackson.JsonMethods$;
import org.sparkproject.guava.io.ByteStreams;
import org.sparkproject.guava.io.FileWriteMode;
import org.sparkproject.jetty.server.Handler;
import org.sparkproject.jetty.server.Server;
import org.sparkproject.jetty.server.handler.DefaultHandler;
import org.sparkproject.jetty.server.handler.HandlerList;
import org.sparkproject.jetty.server.handler.ResourceHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.process.Process$;
import scala.util.Try$;

public final class TestUtils$
implements SparkTestUtils {
    public static final TestUtils$ MODULE$ = new TestUtils$();
    private static final String minimumPythonSupportedVersion;
    private static JavaFileObject.Kind org$apache$spark$util$SparkTestUtils$$SOURCE;

    static {
        SparkTestUtils.$init$((SparkTestUtils)MODULE$);
        minimumPythonSupportedVersion = "3.7.0";
    }

    public File createCompiledClass(String className, File destDir, SparkTestUtils.JavaSourceFromString sourceFile, scala.collection.immutable.Seq<URL> classpathUrls) {
        return SparkTestUtils.createCompiledClass$((SparkTestUtils)this, (String)className, (File)destDir, (SparkTestUtils.JavaSourceFromString)sourceFile, classpathUrls);
    }

    public File createCompiledClass(String className, File destDir, String toStringValue, String baseClass, scala.collection.immutable.Seq<URL> classpathUrls, scala.collection.immutable.Seq<String> implementsClasses, String extraCodeBody, Option<String> packageName) {
        return SparkTestUtils.createCompiledClass$((SparkTestUtils)this, (String)className, (File)destDir, (String)toStringValue, (String)baseClass, classpathUrls, implementsClasses, (String)extraCodeBody, packageName);
    }

    public String createCompiledClass$default$3() {
        return SparkTestUtils.createCompiledClass$default$3$((SparkTestUtils)this);
    }

    public String createCompiledClass$default$4() {
        return SparkTestUtils.createCompiledClass$default$4$((SparkTestUtils)this);
    }

    public scala.collection.immutable.Seq<URL> createCompiledClass$default$5() {
        return SparkTestUtils.createCompiledClass$default$5$((SparkTestUtils)this);
    }

    public scala.collection.immutable.Seq<String> createCompiledClass$default$6() {
        return SparkTestUtils.createCompiledClass$default$6$((SparkTestUtils)this);
    }

    public String createCompiledClass$default$7() {
        return SparkTestUtils.createCompiledClass$default$7$((SparkTestUtils)this);
    }

    public Option<String> createCompiledClass$default$8() {
        return SparkTestUtils.createCompiledClass$default$8$((SparkTestUtils)this);
    }

    public JavaFileObject.Kind org$apache$spark$util$SparkTestUtils$$SOURCE() {
        return org$apache$spark$util$SparkTestUtils$$SOURCE;
    }

    public final void org$apache$spark$util$SparkTestUtils$_setter_$org$apache$spark$util$SparkTestUtils$$SOURCE_$eq(JavaFileObject.Kind x$1) {
        org$apache$spark$util$SparkTestUtils$$SOURCE = x$1;
    }

    public URL createJarWithClasses(scala.collection.immutable.Seq<String> classNames, String toStringValue, scala.collection.immutable.Seq<Tuple2<String, String>> classNamesWithBase, scala.collection.immutable.Seq<URL> classpathUrls) {
        File tempDir = Utils$.MODULE$.createTempDir();
        scala.collection.immutable.Seq files1 = (scala.collection.immutable.Seq)classNames.map((Function1 & Serializable)name -> {
            String x$1 = name;
            File x$2 = tempDir;
            String x$3 = toStringValue;
            scala.collection.immutable.Seq x$4 = classpathUrls;
            String x$5 = MODULE$.createCompiledClass$default$4();
            scala.collection.immutable.Seq<String> x$6 = MODULE$.createCompiledClass$default$6();
            String x$7 = MODULE$.createCompiledClass$default$7();
            Option<String> x$8 = MODULE$.createCompiledClass$default$8();
            return MODULE$.createCompiledClass(x$1, x$2, x$3, x$5, (scala.collection.immutable.Seq<URL>)x$4, x$6, x$7, x$8);
        });
        scala.collection.immutable.Seq files2 = (scala.collection.immutable.Seq)classNamesWithBase.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$createJarWithClasses$2(check$ifrefutable$1))).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String childName = (String)tuple2._1();
                String baseName = (String)tuple2._2();
                return MODULE$.createCompiledClass(childName, tempDir, toStringValue, baseName, classpathUrls, MODULE$.createCompiledClass$default$6(), MODULE$.createCompiledClass$default$7(), MODULE$.createCompiledClass$default$8());
            }
            throw new MatchError((Object)tuple2);
        });
        File jarFile = new File(tempDir, StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("testJar-%s.jar"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)System.currentTimeMillis())})));
        return this.createJar((scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)files1.$plus$plus((IterableOnce)files2)), jarFile, this.createJar$default$3(), this.createJar$default$4());
    }

    public URL createJarWithFiles(Map<String, String> files, File dir) {
        File tempDir = (File)Option$.MODULE$.apply((Object)dir).getOrElse((Function0 & Serializable)() -> Utils$.MODULE$.createTempDir());
        File jarFile = File.createTempFile("testJar", ".jar", tempDir);
        JarOutputStream jarStream = new JarOutputStream(new FileOutputStream(jarFile));
        files.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToLong((long)TestUtils$.$anonfun$createJarWithFiles$2(jarStream, x0$1)));
        jarStream.close();
        return jarFile.toURI().toURL();
    }

    public URL createJar(scala.collection.immutable.Seq<File> files, File jarFile, Option<String> directoryPrefix, Option<String> mainClass) {
        Manifest manifest;
        Option<String> option = mainClass;
        if (option instanceof Some) {
            Some some = (Some)option;
            String mc = (String)some.value();
            Manifest m = new Manifest();
            m.getMainAttributes().putValue("Manifest-Version", "1.0");
            m.getMainAttributes().putValue("Main-Class", mc);
            manifest = m;
        } else if (None$.MODULE$.equals(option)) {
            manifest = new Manifest();
        } else {
            throw new MatchError(option);
        }
        Manifest manifest2 = manifest;
        FileOutputStream jarFileStream = new FileOutputStream(jarFile);
        JarOutputStream jarStream = new JarOutputStream((OutputStream)jarFileStream, manifest2);
        files.foreach((Function1 & Serializable)file -> {
            TestUtils$.$anonfun$createJar$1(directoryPrefix, jarStream, file);
            return BoxedUnit.UNIT;
        });
        jarStream.close();
        jarFileStream.close();
        return jarFile.toURI().toURL();
    }

    public String createJarWithClasses$default$2() {
        return "";
    }

    public scala.collection.immutable.Seq<Tuple2<String, String>> createJarWithClasses$default$3() {
        return (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty();
    }

    public scala.collection.immutable.Seq<URL> createJarWithClasses$default$4() {
        return (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty();
    }

    public File createJarWithFiles$default$2() {
        return null;
    }

    public Option<String> createJar$default$3() {
        return None$.MODULE$;
    }

    public Option<String> createJar$default$4() {
        return None$.MODULE$;
    }

    public void assertSpilled(SparkContext sc, String identifier, Function0<BoxedUnit> body2) {
        SpillListener listener = new SpillListener();
        this.withListener(sc, listener, (Function1 & Serializable)x$2 -> {
            body2.apply$mcV$sp();
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(listener.numSpilledStages() > 0, (Function0 & Serializable)() -> "expected " + identifier + " to spill, but did not");
    }

    public void assertNotSpilled(SparkContext sc, String identifier, Function0<BoxedUnit> body2) {
        SpillListener listener = new SpillListener();
        this.withListener(sc, listener, (Function1 & Serializable)x$3 -> {
            body2.apply$mcV$sp();
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.assert(listener.numSpilledStages() == 0, (Function0 & Serializable)() -> "expected " + identifier + " to not spill, but did");
    }

    public <E extends Throwable> void assertExceptionMsg(Throwable exception, String msg, boolean ignoreCase, ClassTag<E> evidence$1) {
        Tuple2 tuple2;
        ClassTag classTag = package$.MODULE$.classTag(evidence$1);
        ClassTag classTag2 = package$.MODULE$.classTag(ClassTag$.MODULE$.Nothing());
        if (!(classTag != null ? !classTag.equals(classTag2) : classTag2 != null)) {
            v1 = new Tuple2((Object)"", (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$assertExceptionMsg$1(x$4)));
        } else {
            Class clazz = package$.MODULE$.classTag(evidence$1).runtimeClass();
            v1 = tuple2 = new Tuple2((Object)("of type " + clazz.getName() + " "), (Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)clazz.isAssignableFrom(e.getClass())));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String typeMsg = (String)tuple2._1();
        Function1 typeCheck = (Function1)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)typeMsg, (Object)typeCheck);
        String typeMsg2 = (String)tuple22._1();
        Function1 typeCheck2 = (Function1)tuple22._2();
        ObjectRef e2 = ObjectRef.create((Object)exception);
        boolean contains = TestUtils$.contain$1((Throwable)e2.elem, msg, ignoreCase, typeCheck2);
        while (((Throwable)e2.elem).getCause() != null && !contains) {
            e2.elem = ((Throwable)e2.elem).getCause();
            contains = TestUtils$.contain$1((Throwable)e2.elem, msg, ignoreCase, typeCheck2);
        }
        Predef$.MODULE$.assert(contains, (Function0 & Serializable)() -> "Exception tree doesn't contain the expected exception " + typeMsg2 + "with message: " + msg + "\n" + Utils$.MODULE$.exceptionString((Throwable)e$1.elem));
    }

    public <E extends Throwable> boolean assertExceptionMsg$default$3() {
        return false;
    }

    public boolean testCommandAvailable(String command) {
        return Utils$.MODULE$.checkCommandAvailable(command);
    }

    public String minimumPythonSupportedVersion() {
        return minimumPythonSupportedVersion;
    }

    public boolean isPythonVersionAvailable() {
        int[] version = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.minimumPythonSupportedVersion()), '.')), (Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$6))), (ClassTag)ClassTag$.MODULE$.Int());
        Predef$.MODULE$.assert(version.length == 3);
        return this.isPythonVersionAtLeast(version[0], version[1], version[2]);
    }

    private boolean isPythonVersionAtLeast(int major, int minor, int reversion) {
        .colon.colon cmdSeq = Utils$.MODULE$.isWindows() ? new .colon.colon((Object)"cmd.exe", (List)new .colon.colon((Object)"/C", (List)Nil$.MODULE$)) : new .colon.colon((Object)"sh", (List)new .colon.colon((Object)"-c", (List)Nil$.MODULE$));
        String pythonSnippet = "import sys; sys.exit(sys.version_info < (" + major + ", " + minor + ", " + reversion + "))";
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)((JFunction0.mcZ.sp & Serializable)() -> TestUtils$.$anonfun$isPythonVersionAtLeast$1((scala.collection.immutable.Seq)cmdSeq, pythonSnippet))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    public Option<String> getAbsolutePathFromExecutable(String executable) {
        Object command;
        Object object = command = Utils$.MODULE$.isWindows() ? executable + ".exe" : executable;
        if (((String)command).split(File.separator, 2).length == 1 && Files.isRegularFile(Paths.get((String)command, new String[0]), new LinkOption[0]) && Files.isExecutable(Paths.get((String)command, new String[0]))) {
            return new Some((Object)((Object)Paths.get((String)command, new String[0]).toAbsolutePath()).toString());
        }
        return ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)scala.sys.package$.MODULE$.env().apply((Object)"PATH")).split(Pattern.quote(File.pathSeparator))), arg_0 -> TestUtils$.$anonfun$getAbsolutePathFromExecutable$1((String)command, arg_0), ClassTag$.MODULE$.apply(Path.class))), (Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestUtils$.$anonfun$getAbsolutePathFromExecutable$2(p))).map((Function1 & Serializable)x$7 -> ((Object)x$7).toString());
    }

    public int httpResponseCode(URL url, String method, scala.collection.immutable.Seq<Tuple2<String, String>> headers) {
        return BoxesRunTime.unboxToInt(this.withHttpConnection(url, method, headers, (Function1 & Serializable)connection -> BoxesRunTime.boxToInteger((int)connection.getResponseCode())));
    }

    public String httpResponseCode$default$2() {
        return "GET";
    }

    public scala.collection.immutable.Seq<Tuple2<String, String>> httpResponseCode$default$3() {
        return Nil$.MODULE$;
    }

    public String redirectUrl(URL url, String method, scala.collection.immutable.Seq<Tuple2<String, String>> headers) {
        return (String)this.withHttpConnection(url, method, headers, (Function1 & Serializable)connection -> connection.getHeaderField("Location"));
    }

    public String redirectUrl$default$2() {
        return "GET";
    }

    public scala.collection.immutable.Seq<Tuple2<String, String>> redirectUrl$default$3() {
        return Nil$.MODULE$;
    }

    public String httpResponseMessage(URL url, String method, scala.collection.immutable.Seq<Tuple2<String, String>> headers) {
        return (String)this.withHttpConnection(url, method, headers, (Function1 & Serializable)connection -> Source$.MODULE$.fromInputStream(connection.getInputStream(), "utf-8").getLines().mkString("\n"));
    }

    public String httpResponseMessage$default$2() {
        return "GET";
    }

    public scala.collection.immutable.Seq<Tuple2<String, String>> httpResponseMessage$default$3() {
        return Nil$.MODULE$;
    }

    public <T> T withHttpConnection(URL url, String method, scala.collection.immutable.Seq<Tuple2<String, String>> headers, Function1<HttpURLConnection, T> fn) {
        Object object;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        headers.foreach((Function1 & Serializable)x0$1 -> {
            TestUtils$.$anonfun$withHttpConnection$1(connection, x0$1);
            return BoxedUnit.UNIT;
        });
        HttpURLConnection httpURLConnection = connection;
        if (httpURLConnection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            SSLContext sslCtx = SSLContext.getInstance("SSL");
            X509TrustManager trustManager = new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                }

                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                }
            };
            HostnameVerifier verifier = new HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            sslCtx.init(null, (TrustManager[])((Object[])new TrustManager[]{trustManager}), new SecureRandom());
            httpsURLConnection.setSSLSocketFactory(sslCtx.getSocketFactory());
            httpsURLConnection.setHostnameVerifier(verifier);
        }
        try {
            connection.connect();
            object = fn.apply((Object)connection);
        }
        finally {
            connection.disconnect();
        }
        return (T)object;
    }

    public <T> String withHttpConnection$default$2() {
        return "GET";
    }

    public <T> scala.collection.immutable.Seq<Tuple2<String, String>> withHttpConnection$default$3() {
        return Nil$.MODULE$;
    }

    public <L extends SparkListener> void withListener(SparkContext sc, L listener, Function1<L, BoxedUnit> body2) {
        sc.addSparkListener(listener);
        try {
            body2.apply(listener);
        }
        finally {
            sc.listenerBus().waitUntilEmpty();
            sc.listenerBus().removeListener(listener);
        }
    }

    public void withHttpServer(String resBaseDir, Function1<URL, BoxedUnit> body2) {
        Server server = new Server(new InetSocketAddress(Utils$.MODULE$.localCanonicalHostName(), 0));
        ResourceHandler resHandler = new ResourceHandler();
        resHandler.setResourceBase(resBaseDir);
        HandlerList handlers = new HandlerList();
        handlers.setHandlers((Handler[])((Object[])new Handler[]{resHandler, new DefaultHandler()}));
        server.setHandler(handlers);
        server.start();
        try {
            body2.apply((Object)server.getURI().toURL());
        }
        finally {
            server.stop();
        }
    }

    public String withHttpServer$default$1() {
        return ".";
    }

    public void waitUntilExecutorsUp(SparkContext sc, int numExecutors, long timeout) {
        long finishTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
        while (System.nanoTime() < finishTime) {
            if (sc.statusTracker().getExecutorInfos().length > numExecutors) {
                return;
            }
            Thread.sleep(10L);
        }
        throw new TimeoutException("Can't find " + numExecutors + " executors before " + timeout + " milliseconds elapsed");
    }

    public void configTestLog4j2(String level) {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("console", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_ERR);
        appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d{yy/MM/dd HH:mm:ss} %p %c{1}: %m%n%ex"));
        builder.add(appenderBuilder);
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(level).add(builder.newAppenderRef("console")));
        BuiltConfiguration configuration = (BuiltConfiguration)builder.build();
        ((LoggerContext)LogManager.getContext((boolean)false)).reconfigure((Configuration)configuration);
    }

    public File[] recursiveList(File f2) {
        Predef$.MODULE$.require(f2.isDirectory());
        File[] current = f2.listFiles();
        return (File[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])current), ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])current), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isDirectory()))), (Function1 & Serializable)f -> MODULE$.recursiveList((File)f), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(File.class)), ClassTag$.MODULE$.apply(File.class));
    }

    public String[] listDirectory(File path) {
        ArrayBuffer result = ArrayBuffer$.MODULE$.empty();
        if (path.isDirectory()) {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])path.listFiles()), (Function1 & Serializable)f -> (ArrayBuffer)result.appendAll((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])MODULE$.listDirectory((File)f))));
            v0 = BoxedUnit.UNIT;
        } else {
            char c = path.getName().charAt(0);
            v0 = c != '.' && c != '_' ? result.append((Object)path.getAbsolutePath()) : BoxedUnit.UNIT;
        }
        return (String[])result.toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public String createTempJsonFile(File dir, String prefix, JValue jsonValue) {
        File file = File.createTempFile(prefix, ".json", dir);
        Files.write(file.toPath(), JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(jsonValue, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())).getBytes(), new OpenOption[0]);
        return file.getPath();
    }

    public String createTempScriptWithExpectedOutput(File dir, String prefix, String output) {
        File file = File.createTempFile(prefix, ".sh", dir);
        String script = "cat <<EOF\n" + output + "\nEOF\n";
        org.sparkproject.guava.io.Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)script);
        Files.setPosixFilePermissions(file.toPath(), EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE));
        return file.getPath();
    }

    public static final /* synthetic */ boolean $anonfun$createJarWithClasses$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ long $anonfun$createJarWithFiles$2(JarOutputStream jarStream$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            JarEntry entry = new JarEntry(k);
            jarStream$1.putNextEntry(entry);
            return ByteStreams.copy((InputStream)new ByteArrayInputStream(v.getBytes(StandardCharsets.UTF_8)), (OutputStream)jarStream$1);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$createJar$1(Option directoryPrefix$1, JarOutputStream jarStream$2, File file) {
        String prefix = (String)directoryPrefix$1.map((Function1 & Serializable)d -> d + "/").getOrElse((Function0 & Serializable)() -> "");
        JarEntry jarEntry = new JarEntry(prefix + file.getName());
        jarStream$2.putNextEntry(jarEntry);
        FileInputStream in = new FileInputStream(file);
        ByteStreams.copy((InputStream)in, (OutputStream)jarStream$2);
        in.close();
    }

    public static final /* synthetic */ boolean $anonfun$assertExceptionMsg$1(Throwable x$4) {
        return true;
    }

    private static final boolean contain$1(Throwable e, String msg, boolean ignoreCase$1, Function1 typeCheck$1) {
        if (ignoreCase$1) {
            return e.getMessage().toLowerCase(Locale.ROOT).contains(msg.toLowerCase(Locale.ROOT));
        }
        return e.getMessage().contains(msg) && BoxesRunTime.unboxToBoolean((Object)typeCheck$1.apply((Object)e));
    }

    public static final /* synthetic */ boolean $anonfun$isPythonVersionAtLeast$1(scala.collection.immutable.Seq cmdSeq$1, String pythonSnippet$1) {
        return Process$.MODULE$.apply((Seq)cmdSeq$1.$colon$plus((Object)("python3 -c '" + pythonSnippet$1 + "'"))).$bang() == 0;
    }

    public static final /* synthetic */ Path $anonfun$getAbsolutePathFromExecutable$1(String command$1, String path) {
        return Paths.get(StringUtils.strip((String)path, (String)"\"") + File.separator + command$1, new String[0]);
    }

    public static final /* synthetic */ boolean $anonfun$getAbsolutePathFromExecutable$2(Path p) {
        return Files.isRegularFile(p, new LinkOption[0]) && Files.isExecutable(p);
    }

    public static final /* synthetic */ void $anonfun$withHttpConnection$1(HttpURLConnection connection$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            connection$1.setRequestProperty(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private TestUtils$() {
    }
}

