/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.util.ReflectionUtils;

public class FooterBuffer {
    private ArrayList<ObjectPair> buffer;
    private int cur;

    public void setCursor(int cur) {
        this.cur = cur;
    }

    public boolean initializeBuffer(JobConf job, RecordReader recordreader, int footerCount, WritableComparable key, Writable value) throws IOException {
        this.buffer = new ArrayList();
        while (this.buffer.size() < footerCount) {
            boolean notEOF = recordreader.next((Object)key, (Object)value);
            if (!notEOF) {
                return false;
            }
            ObjectPair tem = new ObjectPair();
            tem.setFirst(ReflectionUtils.copy((Configuration)job, (Object)key, (Object)tem.getFirst()));
            tem.setSecond(ReflectionUtils.copy((Configuration)job, (Object)value, (Object)tem.getSecond()));
            this.buffer.add(tem);
        }
        this.cur = 0;
        return true;
    }

    public boolean updateBuffer(JobConf job, RecordReader recordreader, WritableComparable key, Writable value) throws IOException {
        key = (WritableComparable)ReflectionUtils.copy((Configuration)job, (Object)((WritableComparable)this.buffer.get(this.cur).getFirst()), (Object)key);
        value = (Writable)ReflectionUtils.copy((Configuration)job, (Object)((Writable)this.buffer.get(this.cur).getSecond()), (Object)value);
        boolean notEOF = recordreader.next(this.buffer.get(this.cur).getFirst(), this.buffer.get(this.cur).getSecond());
        if (notEOF) {
            ++this.cur;
            this.cur %= this.buffer.size();
        }
        return notEOF;
    }
}

