/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.classification.NaiveBayes$;
import org.apache.spark.ml.classification.NaiveBayesModel$;
import org.apache.spark.ml.classification.NaiveBayesModel$NaiveBayesModelWriter$;
import org.apache.spark.ml.classification.NaiveBayesModel$NaiveBayesModelWriter$Data$;
import org.apache.spark.ml.classification.NaiveBayesParams;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.util.VersionUtils$;
import org.json4s.DefaultFormats$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\u0005c\u0001\u0002&L\u0001YC\u0001b\u001b\u0001\u0003\u0006\u0004%\t\u0005\u001c\u0005\n\u0003\u000f\u0001!\u0011!Q\u0001\n5D!\"a\u0003\u0001\u0005\u000b\u0007I\u0011AA\u0007\u0011%\t)\u0002\u0001B\u0001B\u0003%1\f\u0003\u0006\u0002\u001a\u0001\u0011)\u0019!C\u0001\u00037A!\"!\n\u0001\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\tI\u0003\u0001BC\u0002\u0013\u0005\u00111\u0004\u0005\u000b\u0003c\u0001!\u0011!Q\u0001\n\u0005u\u0001\u0002CA\u001b\u0001\u0011\u0005Q*a\u000e\t\u0011\u0005U\u0002\u0001\"\u0001N\u0003\u0013B!\"a\u0013\u0001\u0001\u0004%\taTA'\u0011)\ti\u0006\u0001a\u0001\n\u0003y\u0015q\f\u0005\t\u0003W\u0002\u0001\u0015)\u0003\u0002P!A\u0011Q\u000e\u0001\u0005\u0002=\u000by\u0007\u0003\u0006\u0002x\u0001A)\u0019!C\u0005\u00037A!\"!!\u0001\u0011\u000b\u0007I\u0011BAB\u0011)\ti\t\u0001EC\u0002\u0013%\u0011Q\n\u0005\n\u0003#\u0003!\u0019!C!\u0003'C\u0001\"!)\u0001A\u0003%\u0011Q\u0013\u0005\n\u0003K\u0003!\u0019!C!\u0003'C\u0001\"!+\u0001A\u0003%\u0011Q\u0013\u0005\b\u0003[\u0003A\u0011BAX\u0011\u001d\t)\f\u0001C\u0005\u0003oCq!a/\u0001\t\u0013\ti\fC\u0004\u0002B\u0002!I!a1\t\u0015\u0005\u001d\u0007\u0001#b\u0001\n\u0013\tI\rC\u0004\u0002T\u0002!\t%!6\t\u000f\u0005m\u0007\u0001\"\u0015\u0002^\"9\u00111\u001d\u0001\u0005B\u0005\u0015\bbBA}\u0001\u0011\u0005\u00131 \u0005\b\u0003\u007f\u0004A\u0011\tB\u0001\u000f\u001d\u0011ia\u0013E\u0001\u0005\u001f1aAS&\t\u0002\tE\u0001bBA\u001bC\u0011\u0005!q\u0006\u0005\b\u0005c\tC\u0011\tB\u001a\u0011\u001d\u0011i$\tC!\u0005\u007f1qAa\u0012\"\u0001\u0005\u0012I\u0005C\u0005\u0003L\u0015\u0012\t\u0011)A\u0005C\"9\u0011QG\u0013\u0005\u0002\t5cA\u0002B+K\u0011\u00139\u0006\u0003\u0006\u0002\f!\u0012)\u001a!C\u0001\u0003\u001bA\u0011\"!\u0006)\u0005#\u0005\u000b\u0011B.\t\u0015\u0005e\u0001F!f\u0001\n\u0003\tY\u0002\u0003\u0006\u0002&!\u0012\t\u0012)A\u0005\u0003;A!\"!\u000b)\u0005+\u0007I\u0011AA\u000e\u0011)\t\t\u0004\u000bB\tB\u0003%\u0011Q\u0004\u0005\b\u0003kAC\u0011\u0001B8\u0011%\t\u0019\u000fKA\u0001\n\u0003\u0011Y\bC\u0005\u0003\u0004\"\n\n\u0011\"\u0001\u0003\u0006\"I!\u0011\u0014\u0015\u0012\u0002\u0013\u0005!1\u0014\u0005\n\u0005?C\u0013\u0013!C\u0001\u00057C\u0011B!))\u0003\u0003%\tEa)\t\u0013\t=\u0006&!A\u0005\u0002\u0005M\u0005\"\u0003BYQ\u0005\u0005I\u0011\u0001BZ\u0011%\u0011i\fKA\u0001\n\u0003\u0012y\fC\u0005\u0003N\"\n\t\u0011\"\u0001\u0003P\"I!\u0011\u001c\u0015\u0002\u0002\u0013\u0005#1\u001c\u0005\n\u0005?D\u0013\u0011!C!\u0005CD\u0011\"!?)\u0003\u0003%\tEa9\t\u0013\t\u0015\b&!A\u0005B\t\u001dx!\u0003BvK\u0005\u0005\t\u0012\u0002Bw\r%\u0011)&JA\u0001\u0012\u0013\u0011y\u000fC\u0004\u00026y\"\tA!@\t\u0013\u0005eh(!A\u0005F\t\r\b\"\u0003B\u0000}\u0005\u0005I\u0011QB\u0001\u0011%\u0019IAPA\u0001\n\u0003\u001bY\u0001C\u0004\u0004\u001e\u0015\"\tfa\b\u0007\r\r\r\u0012\u0005BB\u0013\u0011\u001d\t)\u0004\u0012C\u0001\u0007OA\u0011ba\u000bE\u0005\u0004%IAa)\t\u0011\r5B\t)A\u0005\u0005KCqA!\u0010E\t\u0003\u001ay\u0003C\u0005\u00044\u0005\n\t\u0011\"\u0003\u00046\tya*Y5wK\n\u000b\u00170Z:N_\u0012,GN\u0003\u0002M\u001b\u0006q1\r\\1tg&4\u0017nY1uS>t'B\u0001(P\u0003\tiGN\u0003\u0002Q#\u0006)1\u000f]1sW*\u0011!kU\u0001\u0007CB\f7\r[3\u000b\u0003Q\u000b1a\u001c:h\u0007\u0001\u0019B\u0001A,cKB!\u0001,W.b\u001b\u0005Y\u0015B\u0001.L\u0005\u0001\u0002&o\u001c2bE&d\u0017n\u001d;jG\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005q{V\"A/\u000b\u0005yk\u0015A\u00027j]\u0006dw-\u0003\u0002a;\n1a+Z2u_J\u0004\"\u0001\u0017\u0001\u0011\u0005a\u001b\u0017B\u00013L\u0005Aq\u0015-\u001b<f\u0005\u0006LXm\u001d)be\u0006l7\u000f\u0005\u0002gS6\tqM\u0003\u0002i\u001b\u0006!Q\u000f^5m\u0013\tQwM\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016\f1!^5e+\u0005i\u0007C\u00018x\u001d\tyW\u000f\u0005\u0002qg6\t\u0011O\u0003\u0002s+\u00061AH]8pizR\u0011\u0001^\u0001\u0006g\u000e\fG.Y\u0005\u0003mN\fa\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\u0019\u0019FO]5oO*\u0011ao\u001d\u0015\u0005\u0003m\f\u0019\u0001\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f\u001f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\u0005QPA\u0003TS:\u001cW-\t\u0002\u0002\u0006\u0005)\u0011GL\u001b/a\u0005!Q/\u001b3!Q\u0011\u001110a\u0001\u0002\u0005ALW#A.)\t\rY\u0018\u0011C\u0011\u0003\u0003'\tQA\r\u00181]A\n1\u0001]5!Q\u0011!10!\u0005\u0002\u000bQDW\r^1\u0016\u0005\u0005u\u0001c\u0001/\u0002 %\u0019\u0011\u0011E/\u0003\r5\u000bGO]5yQ\u0011)10!\u0005\u0002\rQDW\r^1!Q\u0011110!\u0005\u0002\u000bMLw-\\1)\t\u001dY\u0018QF\u0011\u0003\u0003_\tQa\r\u00181]A\naa]5h[\u0006\u0004\u0003\u0006\u0002\u0005|\u0003[\ta\u0001P5oSRtD#C1\u0002:\u0005u\u0012\u0011IA#\u0011\u0015Y\u0017\u00021\u0001nQ\u0015\tId_A\u0002\u0011\u0019\tY!\u0003a\u00017\"*\u0011QH>\u0002\u0012!9\u0011\u0011D\u0005A\u0002\u0005u\u0001&BA!w\u0006E\u0001bBA\u0015\u0013\u0001\u0007\u0011Q\u0004\u0015\u0006\u0003\u000bZ\u0018Q\u0006\u000b\u0002C\u0006Iq\u000e\u001c3MC\n,Gn]\u000b\u0003\u0003\u001f\u0002b!!\u0015\u0002T\u0005]S\"A:\n\u0007\u0005U3OA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002R\u0005e\u0013bAA.g\n1Ai\\;cY\u0016\fQb\u001c7e\u0019\u0006\u0014W\r\\:`I\u0015\fH\u0003BA1\u0003O\u0002B!!\u0015\u0002d%\u0019\u0011QM:\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003Sb\u0011\u0011!a\u0001\u0003\u001f\n1\u0001\u001f\u00132\u0003)yG\u000e\u001a'bE\u0016d7\u000fI\u0001\rg\u0016$x\n\u001c3MC\n,Gn\u001d\u000b\u0005\u0003c\n\u0019(D\u0001\u0001\u0011\u001d\t)H\u0004a\u0001\u0003\u001f\na\u0001\\1cK2\u001c\u0018A\u0005;iKR\fW*\u001b8vg:+w\r\u00165fi\u0006D3aDA>!\u0011\t\t&! \n\u0007\u0005}4OA\u0005ue\u0006t7/[3oi\u0006y\u0001/['j]V\u001cH\u000b[3uCN+X.\u0006\u0002\u0002\u0006B\u0019A,a\"\n\u0007\u0005%ULA\u0006EK:\u001cXMV3di>\u0014\bf\u0001\t\u0002|\u0005IAn\\4WCJ\u001cV/\u001c\u0015\u0004#\u0005m\u0014a\u00038v[\u001a+\u0017\r^;sKN,\"!!&\u0011\t\u0005E\u0013qS\u0005\u0004\u00033\u001b(aA%oi\"\"!c_AOC\t\ty*A\u00032]Yr\u0003'\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005\u000b\u0003\u0014w\u0006u\u0015A\u00038v[\u000ec\u0017m]:fg\"\"Ac_A\u0002\u0003-qW/\\\"mCN\u001cXm\u001d\u0011)\tUY\u00181A\u0001\u0017[VdG/\u001b8p[&\fGnQ1mGVd\u0017\r^5p]R!\u0011QQAY\u0011\u0019\t\u0019L\u0006a\u00017\u0006Aa-Z1ukJ,7/A\u000bd_6\u0004H.Z7f]R\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\u0007m\u000bI\f\u0003\u0004\u00024^\u0001\raW\u0001\u0015E\u0016\u0014hn\\;mY&\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\t\u0005\u0015\u0015q\u0018\u0005\u0007\u0003gC\u0002\u0019A.\u0002'\u001d\fWo]:jC:\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\u0007m\u000b)\r\u0003\u0004\u00024f\u0001\raW\u0001\u000faJ,G-[2u%\u0006<h)\u001e8d+\t\tY\r\u0005\u0004\u0002R\u000557lW\u0005\u0004\u0003\u001f\u001c(!\u0003$v]\u000e$\u0018n\u001c82Q\rQ\u00121P\u0001\u000baJ,G-[2u%\u0006<HcA.\u0002X\"1\u00111W\u000eA\u0002mCCaG>\u0002.\u00051\"/Y<3aJ|'-\u00192jY&$\u00180\u00138QY\u0006\u001cW\rF\u0002\\\u0003?Da!!9\u001d\u0001\u0004Y\u0016!\u0004:boB\u0013X\rZ5di&|g.\u0001\u0003d_BLHcA1\u0002h\"9\u0011\u0011^\u000fA\u0002\u0005-\u0018!B3yiJ\f\u0007\u0003BAw\u0003gl!!a<\u000b\u0007\u0005EX*A\u0003qCJ\fW.\u0003\u0003\u0002v\u0006=(\u0001\u0003)be\u0006lW*\u00199)\tuY\u00181A\u0001\ti>\u001cFO]5oOR\tQ\u000e\u000b\u0003\u001fw\u0006\r\u0011!B<sSR,WC\u0001B\u0002!\r1'QA\u0005\u0004\u0005\u000f9'\u0001C'M/JLG/\u001a:)\t}Y\u0018Q\u0014\u0015\u0005\u0001m\f\u0019!A\bOC&4XMQ1zKNlu\u000eZ3m!\tA\u0016eE\u0004\"\u0005'\u0011IBa\b\u0011\t\u0005E#QC\u0005\u0004\u0005/\u0019(AB!osJ+g\r\u0005\u0003g\u00057\t\u0017b\u0001B\u000fO\nQQ\n\u0014*fC\u0012\f'\r\\3\u0011\t\t\u0005\"1F\u0007\u0003\u0005GQAA!\n\u0003(\u0005\u0011\u0011n\u001c\u0006\u0003\u0005S\tAA[1wC&!!Q\u0006B\u0012\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011y!\u0001\u0003sK\u0006$WC\u0001B\u001b!\u00111'qG1\n\u0007\terM\u0001\u0005N\u0019J+\u0017\rZ3sQ\u0011\u001930!(\u0002\t1|\u0017\r\u001a\u000b\u0004C\n\u0005\u0003B\u0002B\"I\u0001\u0007Q.\u0001\u0003qCRD\u0007\u0006\u0002\u0013|\u0003;\u0013QCT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\\,sSR,'oE\u0002&\u0005\u0007\t\u0001\"\u001b8ti\u0006t7-\u001a\u000b\u0005\u0005\u001f\u0012\u0019\u0006E\u0002\u0003R\u0015j\u0011!\t\u0005\u0007\u0005\u0017:\u0003\u0019A1\u0003\t\u0011\u000bG/Y\n\bQ\tM!\u0011\fB0!\u0011\t\tFa\u0017\n\u0007\tu3OA\u0004Qe>$Wo\u0019;\u0011\t\t\u0005$1\u000e\b\u0005\u0005G\u00129GD\u0002q\u0005KJ\u0011\u0001^\u0005\u0004\u0005S\u001a\u0018a\u00029bG.\fw-Z\u0005\u0005\u0005[\u0011iGC\u0002\u0003jM$\u0002B!\u001d\u0003v\t]$\u0011\u0010\t\u0004\u0005gBS\"A\u0013\t\r\u0005-q\u00061\u0001\\\u0011\u001d\tIb\fa\u0001\u0003;Aq!!\u000b0\u0001\u0004\ti\u0002\u0006\u0005\u0003r\tu$q\u0010BA\u0011!\tY\u0001\rI\u0001\u0002\u0004Y\u0006\"CA\raA\u0005\t\u0019AA\u000f\u0011%\tI\u0003\rI\u0001\u0002\u0004\ti\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u001d%fA.\u0003\n.\u0012!1\u0012\t\u0005\u0005\u001b\u0013)*\u0004\u0002\u0003\u0010*!!\u0011\u0013BJ\u0003%)hn\u00195fG.,GM\u0003\u0002\u007fg&!!q\u0013BH\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iJ\u000b\u0003\u0002\u001e\t%\u0015AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t\u0015\u0006\u0003\u0002BT\u0005[k!A!+\u000b\t\t-&qE\u0001\u0005Y\u0006tw-C\u0002y\u0005S\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00036\nm\u0006\u0003BA)\u0005oK1A!/t\u0005\r\te.\u001f\u0005\n\u0003S2\u0014\u0011!a\u0001\u0003+\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u0003\u0004bAa1\u0003J\nUVB\u0001Bc\u0015\r\u00119m]\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002Bf\u0005\u000b\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!\u0011\u001bBl!\u0011\t\tFa5\n\u0007\tU7OA\u0004C_>dW-\u00198\t\u0013\u0005%\u0004(!AA\u0002\tU\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!*\u0003^\"I\u0011\u0011N\u001d\u0002\u0002\u0003\u0007\u0011QS\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011Q\u0013\u000b\u0003\u0005K\u000ba!Z9vC2\u001cH\u0003\u0002Bi\u0005SD\u0011\"!\u001b=\u0003\u0003\u0005\rA!.\u0002\t\u0011\u000bG/\u0019\t\u0004\u0005gr4#\u0002 \u0003r\n}\u0001c\u0003Bz\u0005s\\\u0016QDA\u000f\u0005cj!A!>\u000b\u0007\t]8/A\u0004sk:$\u0018.\\3\n\t\tm(Q\u001f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDC\u0001Bw\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011\tha\u0001\u0004\u0006\r\u001d\u0001BBA\u0006\u0003\u0002\u00071\fC\u0004\u0002\u001a\u0005\u0003\r!!\b\t\u000f\u0005%\u0012\t1\u0001\u0002\u001e\u00059QO\\1qa2LH\u0003BB\u0007\u00073\u0001b!!\u0015\u0004\u0010\rM\u0011bAB\tg\n1q\n\u001d;j_:\u0004\u0012\"!\u0015\u0004\u0016m\u000bi\"!\b\n\u0007\r]1O\u0001\u0004UkBdWm\r\u0005\n\u00077\u0011\u0015\u0011!a\u0001\u0005c\n1\u0001\u001f\u00131\u0003!\u0019\u0018M^3J[BdG\u0003BA1\u0007CAaAa\u0011D\u0001\u0004i'!\u0006(bSZ,')Y=fg6{G-\u001a7SK\u0006$WM]\n\u0004\t\nUBCAB\u0015!\r\u0011\t\u0006R\u0001\nG2\f7o\u001d(b[\u0016\f!b\u00197bgNt\u0015-\\3!)\r\t7\u0011\u0007\u0005\u0007\u0005\u0007B\u0005\u0019A7\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r]\u0002\u0003\u0002BT\u0007sIAaa\u000f\u0003*\n1qJ\u00196fGRDC!I>\u0002\u001e\"\"\u0001e_AO\u0001")
public class NaiveBayesModel
extends ProbabilisticClassificationModel<Vector, NaiveBayesModel>
implements NaiveBayesParams,
MLWritable {
    private transient Matrix thetaMinusNegTheta;
    private transient DenseVector piMinusThetaSum;
    private transient double[] logVarSum;
    private transient Function1<Vector, Vector> predictRawFunc;
    private final String uid;
    private final Vector pi;
    private final Matrix theta;
    private final Matrix sigma;
    private double[] oldLabels;
    private final int numFeatures;
    private final int numClasses;
    private DoubleParam smoothing;
    private Param<String> modelType;
    private Param<String> weightCol;
    private volatile transient byte bitmap$trans$0;

    public static NaiveBayesModel load(String path) {
        return NaiveBayesModel$.MODULE$.load(path);
    }

    public static MLReader<NaiveBayesModel> read() {
        return NaiveBayesModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getSmoothing() {
        return NaiveBayesParams.getSmoothing$(this);
    }

    @Override
    public final String getModelType() {
        return NaiveBayesParams.getModelType$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final DoubleParam smoothing() {
        return this.smoothing;
    }

    @Override
    public final Param<String> modelType() {
        return this.modelType;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$smoothing_$eq(DoubleParam x$1) {
        this.smoothing = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$modelType_$eq(Param<String> x$1) {
        this.modelType = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector pi() {
        return this.pi;
    }

    public Matrix theta() {
        return this.theta;
    }

    public Matrix sigma() {
        return this.sigma;
    }

    public double[] oldLabels() {
        return this.oldLabels;
    }

    public void oldLabels_$eq(double[] x$1) {
        this.oldLabels = x$1;
    }

    public NaiveBayesModel setOldLabels(double[] labels) {
        this.oldLabels_$eq(labels);
        return this;
    }

    private Matrix thetaMinusNegTheta$lzycompute() {
        block5: {
            NaiveBayesModel naiveBayesModel = this;
            synchronized (naiveBayesModel) {
                block7: {
                    block8: {
                        String string;
                        String string2;
                        block6: {
                            if ((byte)(this.bitmap$trans$0 & 1) != 0) break block5;
                            String string3 = this.$(this.modelType());
                            string2 = NaiveBayes$.MODULE$.Bernoulli();
                            string = string3;
                            if (string2 != null) break block6;
                            if (string == null) break block7;
                            break block8;
                        }
                        if (string2.equals(string)) break block7;
                    }
                    throw new IllegalArgumentException("Invalid modelType: " + this.$(this.modelType()) + ". Variables thetaMinusNegTheta should only be precomputed in Bernoulli NB.");
                }
                this.thetaMinusNegTheta = this.theta().map((Function1)(JFunction1.mcDD.sp & Serializable)value -> value - scala.math.package$.MODULE$.log1p(-scala.math.package$.MODULE$.exp(value)));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.thetaMinusNegTheta;
    }

    private Matrix thetaMinusNegTheta() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.thetaMinusNegTheta$lzycompute();
        }
        return this.thetaMinusNegTheta;
    }

    private DenseVector piMinusThetaSum$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Bernoulli();
                String string3 = string;
                if (string2 != null ? !string2.equals(string3) : string3 != null) {
                    throw new IllegalArgumentException("Invalid modelType: " + this.$(this.modelType()) + ". Variables piMinusThetaSum should only be precomputed in Bernoulli NB.");
                }
                Matrix negTheta = this.theta().map((Function1)(JFunction1.mcDD.sp & Serializable)value -> scala.math.package$.MODULE$.log1p(-scala.math.package$.MODULE$.exp(value)));
                DenseVector ones = new DenseVector((double[])Array$.MODULE$.fill(this.theta().numCols(), (Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0, (ClassTag)ClassTag$.MODULE$.Double()));
                DenseVector piMinusThetaSum = this.pi().toDense().copy();
                BLAS$.MODULE$.gemv(1.0, negTheta, (Vector)ones, 1.0, piMinusThetaSum);
                this.piMinusThetaSum = piMinusThetaSum;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.piMinusThetaSum;
    }

    private DenseVector piMinusThetaSum() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.piMinusThetaSum$lzycompute();
        }
        return this.piMinusThetaSum;
    }

    private double[] logVarSum$lzycompute() {
        block5: {
            NaiveBayesModel naiveBayesModel = this;
            synchronized (naiveBayesModel) {
                block7: {
                    block8: {
                        String string;
                        String string2;
                        block6: {
                            if ((byte)(this.bitmap$trans$0 & 4) != 0) break block5;
                            String string3 = this.$(this.modelType());
                            string2 = NaiveBayes$.MODULE$.Gaussian();
                            string = string3;
                            if (string2 != null) break block6;
                            if (string == null) break block7;
                            break block8;
                        }
                        if (string2.equals(string)) break block7;
                    }
                    throw new IllegalArgumentException("Invalid modelType: " + this.$(this.modelType()) + ". Variables logVarSum should only be precomputed in Gaussian NB.");
                }
                this.logVarSum = (double[])Array$.MODULE$.tabulate(this.numClasses(), (Function1)(JFunction1.mcDI.sp & Serializable)i -> BoxesRunTime.unboxToDouble((Object)package$.MODULE$.Iterator().range(0, this.numFeatures()).map((Function1)(JFunction1.mcDI.sp & Serializable)j -> scala.math.package$.MODULE$.log(this.sigma().apply(i, j))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), (ClassTag)ClassTag$.MODULE$.Double());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.logVarSum;
    }

    private double[] logVarSum() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.logVarSum$lzycompute();
        }
        return this.logVarSum;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    private DenseVector multinomialCalculation(Vector features) {
        NaiveBayes$.MODULE$.requireNonnegativeValues(features);
        DenseVector prob = this.pi().toDense().copy();
        BLAS$.MODULE$.gemv(1.0, this.theta(), features, 1.0, prob);
        return prob;
    }

    private Vector complementCalculation(Vector features) {
        int j;
        NaiveBayes$.MODULE$.requireNonnegativeValues(features);
        double[] probArray = this.theta().multiply(features).toArray();
        double max = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(probArray).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        double sumExp = 0.0;
        for (j = 0; j < probArray.length; ++j) {
            sumExp += scala.math.package$.MODULE$.exp(probArray[j] - max);
        }
        double logSumExp = scala.math.package$.MODULE$.log(sumExp) + max;
        j = 0;
        while (j < probArray.length) {
            int n = j++;
            probArray[n] = probArray[n] - logSumExp;
        }
        return Vectors$.MODULE$.dense(probArray);
    }

    private DenseVector bernoulliCalculation(Vector features) {
        NaiveBayes$.MODULE$.requireZeroOneBernoulliValues(features);
        DenseVector prob = this.piMinusThetaSum().copy();
        BLAS$.MODULE$.gemv(1.0, this.thetaMinusNegTheta(), features, 1.0, prob);
        return prob;
    }

    private Vector gaussianCalculation(Vector features) {
        double[] prob = (double[])Array$.MODULE$.ofDim(this.numClasses(), (ClassTag)ClassTag$.MODULE$.Double());
        for (int i = 0; i < this.numClasses(); ++i) {
            double s = 0.0;
            for (int j = 0; j < this.numFeatures(); ++j) {
                double d = features.apply(j) - this.theta().apply(i, j);
                s += d * d / this.sigma().apply(i, j);
            }
            prob[i] = this.pi().apply(i) - (s + this.logVarSum()[i]) / (double)2;
        }
        return Vectors$.MODULE$.dense(prob);
    }

    private Function1<Vector, Vector> predictRawFunc$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                Function1 & Serializable intersect;
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Multinomial();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    intersect = (Function1 & Serializable)features -> this.multinomialCalculation((Vector)features);
                } else {
                    String string4 = NaiveBayes$.MODULE$.Complement();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        intersect = (Function1 & Serializable)features -> this.complementCalculation((Vector)features);
                    } else {
                        String string6 = NaiveBayes$.MODULE$.Bernoulli();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            intersect = (Function1 & Serializable)features -> this.bernoulliCalculation((Vector)features);
                        } else {
                            String string8 = NaiveBayes$.MODULE$.Gaussian();
                            String string9 = string;
                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                intersect = (Function1 & Serializable)features -> this.gaussianCalculation((Vector)features);
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
                this.predictRawFunc = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.predictRawFunc;
    }

    private Function1<Vector, Vector> predictRawFunc() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.predictRawFunc$lzycompute();
        }
        return this.predictRawFunc;
    }

    @Override
    public Vector predictRaw(Vector features) {
        return (Vector)this.predictRawFunc().apply((Object)features);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            Utils$.MODULE$.softmax(denseVector.values());
            return denseVector;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in NaiveBayesModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public NaiveBayesModel copy(ParamMap extra) {
        return (NaiveBayesModel)this.copyValues(new NaiveBayesModel(this.uid(), this.pi(), this.theta(), this.sigma()).setParent(this.parent()), extra);
    }

    @Override
    public String toString() {
        return "NaiveBayesModel: uid=" + this.uid() + ", modelType=" + this.$(this.modelType()) + ", numClasses=" + this.numClasses() + ", numFeatures=" + this.numFeatures();
    }

    @Override
    public MLWriter write() {
        return new NaiveBayesModelWriter(this);
    }

    public NaiveBayesModel(String uid, Vector pi, Matrix theta, Matrix sigma) {
        this.uid = uid;
        this.pi = pi;
        this.theta = theta;
        this.sigma = sigma;
        HasWeightCol.$init$(this);
        NaiveBayesParams.$init$(this);
        MLWritable.$init$(this);
        this.oldLabels = null;
        this.numFeatures = theta.numCols();
        this.numClasses = pi.size();
        Statics.releaseFence();
    }

    public NaiveBayesModel() {
        this("", (Vector)Vectors$.MODULE$.empty(), (Matrix)Matrices$.MODULE$.empty(), (Matrix)Matrices$.MODULE$.empty());
    }

    private static class NaiveBayesModelReader
    extends MLReader<NaiveBayesModel> {
        private final String className = NaiveBayesModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public NaiveBayesModel load(String path) {
            NaiveBayesModel naiveBayesModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Matrix matrix;
                Vector vector;
                Object sigma;
                block12: {
                    Row row;
                    block11: {
                        Some some;
                        Dataset<Row> vecConverted;
                        block7: {
                            Vector vector2;
                            Object theta;
                            block9: {
                                Row row2;
                                block8: {
                                    Some some2;
                                    DefaultFormats$ format = DefaultFormats$.MODULE$;
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int major = tuple2._1$mcI$sp();
                                    int minor = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
                                    int major2 = sp2._1$mcI$sp();
                                    int minor2 = sp2._2$mcI$sp();
                                    String dataPath = new Path(path, "data").toString();
                                    Dataset data = this.sparkSession().read().parquet(dataPath);
                                    vecConverted = MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"pi"}));
                                    if (major2 >= 3) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertMatrixColumnsToML(vecConverted, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"theta"})).select("pi", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"theta"})).head();
                                    if (row2 == null || (some2 = Row$.MODULE$.unapplySeq(row2)).isEmpty() || some2.get() == null || ((SeqOps)some2.get()).lengthCompare(2) != 0) break block8;
                                    Object pi = ((SeqOps)some2.get()).apply(0);
                                    theta = ((SeqOps)some2.get()).apply(1);
                                    if (!(pi instanceof Vector)) break block8;
                                    vector2 = (Vector)pi;
                                    if (theta instanceof Matrix) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Matrix matrix2 = (Matrix)theta;
                            Tuple2 tuple2 = new Tuple2((Object)vector2, (Object)matrix2);
                            Vector pi = (Vector)tuple2._1();
                            Matrix theta2 = (Matrix)tuple2._2();
                            naiveBayesModel = new NaiveBayesModel(metadata.uid(), pi, theta2, Matrices$.MODULE$.zeros(0, 0));
                            break block10;
                        }
                        row = (Row)MLUtils$.MODULE$.convertMatrixColumnsToML(vecConverted, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"theta", "sigma"})).select("pi", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"theta", "sigma"})).head();
                        if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(3) != 0) break block11;
                        Object pi = ((SeqOps)some.get()).apply(0);
                        Object theta = ((SeqOps)some.get()).apply(1);
                        sigma = ((SeqOps)some.get()).apply(2);
                        if (!(pi instanceof Vector)) break block11;
                        vector = (Vector)pi;
                        if (!(theta instanceof Matrix)) break block11;
                        matrix = (Matrix)theta;
                        if (sigma instanceof Matrix) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                Matrix matrix3 = (Matrix)sigma;
                Tuple3 tuple3 = new Tuple3((Object)vector, (Object)matrix, (Object)matrix3);
                Vector pi = (Vector)tuple3._1();
                Matrix theta = (Matrix)tuple3._2();
                Matrix sigma2 = (Matrix)tuple3._3();
                naiveBayesModel = new NaiveBayesModel(metadata.uid(), pi, theta, sigma2);
            }
            NaiveBayesModel model = naiveBayesModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class NaiveBayesModelWriter
    extends MLWriter {
        private volatile NaiveBayesModel$NaiveBayesModelWriter$Data$ Data$module;
        private final NaiveBayesModel instance;

        private NaiveBayesModel$NaiveBayesModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            boolean bl;
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            String dataPath = new Path(path, "data").toString();
            String string = this.instance.getModelType();
            String string2 = NaiveBayes$.MODULE$.Multinomial();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                bl = true;
            } else {
                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    bl = true;
                } else {
                    String string6 = NaiveBayes$.MODULE$.Complement();
                    String string7 = string;
                    bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
                }
            }
            if (bl) {
                Predef$.MODULE$.require(this.instance.sigma().numRows() == 0 && this.instance.sigma().numCols() == 0);
            } else {
                String string8 = NaiveBayes$.MODULE$.Gaussian();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    Predef$.MODULE$.require(this.instance.sigma().numRows() != 0 && this.instance.sigma().numCols() != 0);
                } else {
                    throw new MatchError((Object)string);
                }
            }
            Data data = new Data(this, this.instance.pi(), this.instance.theta(), this.instance.sigma());
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(NaiveBayesModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.NaiveBayesModel.NaiveBayesModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.NaiveBayesModel.NaiveBayesModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$1(NaiveBayesModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_NaiveBayesModel$NaiveBayesModelWriter$$typecreator1$1(null))).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            NaiveBayesModelWriter naiveBayesModelWriter = this;
            synchronized (naiveBayesModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new NaiveBayesModel$NaiveBayesModelWriter$Data$(this);
                }
            }
        }

        public NaiveBayesModelWriter(NaiveBayesModel instance) {
            this.instance = instance;
        }

        private class Data
        implements Product,
        Serializable {
            private final Vector pi;
            private final Matrix theta;
            private final Matrix sigma;
            public final /* synthetic */ NaiveBayesModelWriter $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public Vector pi() {
                return this.pi;
            }

            public Matrix theta() {
                return this.theta;
            }

            public Matrix sigma() {
                return this.sigma;
            }

            public Data copy(Vector pi, Matrix theta, Matrix sigma) {
                return new Data(this.org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer(), pi, theta, sigma);
            }

            public Vector copy$default$1() {
                return this.pi();
            }

            public Matrix copy$default$2() {
                return this.theta();
            }

            public Matrix copy$default$3() {
                return this.sigma();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        return this.pi();
                    }
                    case 1: {
                        return this.theta();
                    }
                    case 2: {
                        return this.sigma();
                    }
                }
                return Statics.ioobe((int)x$1);
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public String productElementName(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        return "pi";
                    }
                    case 1: {
                        return "theta";
                    }
                    case 2: {
                        return "sigma";
                    }
                }
                return (String)Statics.ioobe((int)x$1);
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer() != this.org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                Vector vector = this.pi();
                Vector vector2 = data.pi();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.theta();
                Matrix matrix2 = data.theta();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                Matrix matrix3 = this.sigma();
                Matrix matrix4 = data.sigma();
                if (matrix3 == null) {
                    if (matrix4 != null) {
                        return false;
                    }
                } else if (!matrix3.equals(matrix4)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ NaiveBayesModelWriter org$apache$spark$ml$classification$NaiveBayesModel$NaiveBayesModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(NaiveBayesModelWriter $outer, Vector pi, Matrix theta, Matrix sigma) {
                this.pi = pi;
                this.theta = theta;
                this.sigma = sigma;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

