/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaValidationException;
import org.apache.avro.SchemaValidator;
import org.apache.avro.SchemaValidatorBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.SchemaHelper;
import org.apache.spark.sql.execution.streaming.state.SchemaHelper$SchemaWriter$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadataValue;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\rc\u0001\u0002\u0013&\u0001QB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003d\u0011\u00151\u0007\u0001\"\u0001h\u0011\u001di\u0007A1A\u0005\n9Daa\u001c\u0001!\u0002\u0013a\u0006b\u00029\u0001\u0005\u0004%I!\u001d\u0005\u0007m\u0002\u0001\u000b\u0011\u0002:\t\u000f)\u0003!\u0019!C\u0005o\"1Q\u0010\u0001Q\u0001\naDQA \u0001\u0005\u0002}Dq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002$\u0001!I!!\n\t\u0011\u0005\r\u0002\u0001\"\u0001,\u0003wAa!!\u001c\u0001\t\u0013y\bbBA8\u0001\u0011%\u0011\u0011\u000f\u0005\b\u0003\u001b\u0003A\u0011BAH\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!!.\u0001\t\u0013\t9lB\u0004\u0002>\u0016B\t!a0\u0007\r\u0011*\u0003\u0012AAa\u0011\u00191g\u0003\"\u0001\u0002D\"I\u0011Q\u0019\fC\u0002\u0013\u0005\u0011q\u0019\u0005\t\u0003\u00134\u0002\u0015!\u0003\u00026!9\u00111\u001a\f\u0005\n\u00055\u0007B\u0002@\u0017\t\u0003\t\t\u000eC\u0004\u0002(Z!\t!!8\t\u0013\t=a#%A\u0005\u0002\tE\u0001\"\u0003B\u0014-E\u0005I\u0011\u0001B\u0015\u0011%\u0011iCFI\u0001\n\u0003\u0011y\u0003C\u0005\u00034Y\t\n\u0011\"\u0001\u00036!I!\u0011\b\f\u0012\u0002\u0013\u0005!1\b\u0005\n\u0005\u007f1\u0012\u0013!C\u0001\u0005_A\u0011B!\u0011\u0017#\u0003%\tA!\u000e\u0003?M#\u0018\r^3TG\",W.Y\"p[B\fG/\u001b2jY&$\u0018p\u00115fG.,'O\u0003\u0002'O\u0005)1\u000f^1uK*\u0011\u0001&K\u0001\ngR\u0014X-Y7j]\u001eT!AK\u0016\u0002\u0013\u0015DXmY;uS>t'B\u0001\u0017.\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003]=\nQa\u001d9be.T!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sO\u000e\u00011c\u0001\u00016wA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t1\u0011I\\=SK\u001a\u0004\"\u0001P \u000e\u0003uR!AP\u0017\u0002\u0011%tG/\u001a:oC2L!\u0001Q\u001f\u0003\u000f1{wmZ5oO\u0006Q\u0001O]8wS\u0012,'/\u00133\u0011\u0005\r#U\"A\u0013\n\u0005\u0015+#\u0001F*uCR,7\u000b^8sKB\u0013xN^5eKJLE-\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"\u0001S'\u000e\u0003%S!AS&\u0002\t\r|gN\u001a\u0006\u0003\u0019>\na\u0001[1e_>\u0004\u0018B\u0001(J\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006\u0011r\u000e\u001c3TG\",W.\u0019$jY\u0016\u0004\u0016\r\u001e5t!\r\t\u0016\f\u0018\b\u0003%^s!a\u0015,\u000e\u0003QS!!V\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0014B\u0001-8\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\t1K7\u000f\u001e\u0006\u00031^\u0002\"!\u00181\u000e\u0003yS!aX&\u0002\u0005\u0019\u001c\u0018BA1_\u0005\u0011\u0001\u0016\r\u001e5\u0002#9,woU2iK6\fg)\u001b7f!\u0006$\b\u000eE\u00027IrK!!Z\u001c\u0003\r=\u0003H/[8o\u0003\u0019a\u0014N\\5u}Q)\u0001.\u001b6lYB\u00111\t\u0001\u0005\u0006\u0003\u0016\u0001\rA\u0011\u0005\u0006\r\u0016\u0001\ra\u0012\u0005\b\u001f\u0016\u0001\n\u00111\u0001Q\u0011\u001d\u0011W\u0001%AA\u0002\r\f!c]2iK6\fg)\u001b7f\u0019>\u001c\u0017\r^5p]V\tA,A\ntG\",W.\u0019$jY\u0016dunY1uS>t\u0007%\u0001\u0002g[V\t!\u000f\u0005\u0002ti6\tq%\u0003\u0002vO\t)2\t[3dWB|\u0017N\u001c;GS2,W*\u00198bO\u0016\u0014\u0018a\u00014nAU\t\u0001\u0010\u0005\u0002zw6\t!P\u0003\u0002?W%\u0011AP\u001f\u0002\b'Fc5i\u001c8g\u0003\u0015\u0019wN\u001c4!\u00039\u0011X-\u00193TG\",W.\u0019$jY\u0016$\"!!\u0001\u0011\tEK\u00161\u0001\t\u0004\u0007\u0006\u0015\u0011bAA\u0004K\tI2\u000b^1uKN#xN]3D_24\u0015-\\5msN\u001b\u0007.Z7b\u0003=\u0011X-\u00193TG\",W.\u0019$jY\u0016\u001cHCAA\u0007!!\ty!a\u0006\u0002\u001e\u0005\u0005a\u0002BA\t\u0003'\u0001\"aU\u001c\n\u0007\u0005Uq'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\tYBA\u0002NCBT1!!\u00068!\u0011\ty!a\b\n\t\u0005\u0005\u00121\u0004\u0002\u0007'R\u0014\u0018N\\4\u0002!\r\u0014X-\u0019;f'\u000eDW-\\1GS2,GCBA\u0014\u0003[\t\t\u0004E\u00027\u0003SI1!a\u000b8\u0005\u0011)f.\u001b;\t\u000f\u0005=b\u00021\u0001\u0002\u0002\u0005I2\u000f^1uKN#xN]3D_24\u0015-\\5msN\u001b\u0007.Z7b\u0011\u001d\t\u0019D\u0004a\u0001\u0003k\t!c\u001d;bi\u0016\u001c6\r[3nCZ+'o]5p]B\u0019a'a\u000e\n\u0007\u0005erGA\u0002J]R$b!a\n\u0002>\u0005}\u0002bBA\u0018\u001f\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u0003z\u0001\u0019AA\"\u00031\u00198\r[3nC^\u0013\u0018\u000e^3s!\u0011\t)%a\u001a\u000f\t\u0005\u001d\u00131\r\b\u0005\u0003\u0013\n\tG\u0004\u0003\u0002L\u0005}c\u0002BA'\u0003;rA!a\u0014\u0002\\9!\u0011\u0011KA-\u001d\u0011\t\u0019&a\u0016\u000f\u0007M\u000b)&C\u00013\u0013\t\u0001\u0014'\u0003\u0002/_%\u0011A&L\u0005\u0003U-J!\u0001K\u0015\n\u0005\u0019:\u0013bAA3K\u0005a1k\u00195f[\u0006DU\r\u001c9fe&!\u0011\u0011NA6\u00051\u00196\r[3nC^\u0013\u0018\u000e^3s\u0015\r\t)'J\u0001\u001dO\u0016$X\t_5ti&twmS3z\u0003:$g+\u00197vKN\u001b\u0007.Z7b\u0003E\u00198\r[3nCN\u001cu.\u001c9bi&\u0014G.\u001a\u000b\u0007\u0003g\nI(!#\u0011\u0007Y\n)(C\u0002\u0002x]\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002|E\u0001\r!! \u0002\u0019M$xN]3e'\u000eDW-\\1\u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a!,\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t9)!!\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002\fF\u0001\r!! \u0002\rM\u001c\u0007.Z7b\u0003\u0015\u0019\u0007.Z2l))\t\t*a&\u0002\u001c\u0006}\u00151\u0015\t\bm\u0005M\u00151AA:\u0013\r\t)j\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005e%\u00031\u0001\u0002\u0002\u0005Qq\u000e\u001c3TG\",W.Y:\t\u000f\u0005u%\u00031\u0001\u0002\u0004\u0005Ia.Z<TG\",W.\u0019\u0005\b\u0003C\u0013\u0002\u0019AA:\u0003EIwM\\8sKZ\u000bG.^3TG\",W.\u0019\u0005\b\u0003K\u0013\u0002\u0019AA:\u0003Y\u00198\r[3nC\u00163x\u000e\\;uS>tWI\\1cY\u0016$\u0017!\t<bY&$\u0017\r^3B]\u0012l\u0015-\u001f2f\u000bZ|GN^3Ti\u0006$XmU2iK6\fGCCA:\u0003W\u000by+!-\u00024\"9\u0011QV\nA\u0002\u0005\u0005\u0011A\u00048foN#\u0018\r^3TG\",W.\u0019\u0005\b\u0003C\u001b\u0002\u0019AA:\u0011\u001d\t\u0019d\u0005a\u0001\u0003kAq!!*\u0014\u0001\u0004\t\u0019(\u0001\u0006tG\",W.\u0019$jY\u0016$2\u0001XA]\u0011\u0019\tY\f\u0006a\u00019\u0006y1\u000f^8sK\u000e\u0003Hj\\2bi&|g.A\u0010Ti\u0006$XmU2iK6\f7i\\7qCRL'-\u001b7jif\u001c\u0005.Z2lKJ\u0004\"a\u0011\f\u0014\u0007Y)4\b\u0006\u0002\u0002@\u0006\u00012k\u0011%F\u001b\u0006{fi\u0014*N\u0003R{fkM\u000b\u0003\u0003k\t\u0011cU\"I\u000b6\u000buLR(S\u001b\u0006#vLV\u001a!\u0003y!\u0017n]1mY><()\u001b8befLe.Z9vC2LG/_\"pYVlg\u000e\u0006\u0003\u0002(\u0005=\u0007bBAF5\u0001\u0007\u0011Q\u0010\u000b\u0005\u0003\u0003\t\u0019\u000eC\u0004\u0002Vn\u0001\r!a6\u0002\u0011%t7\u000b\u001e:fC6\u00042!XAm\u0013\r\tYN\u0018\u0002\u0012\rN#\u0015\r^1J]B,Ho\u0015;sK\u0006lGCFAp\u0003K\fy/!=\u0002t\u0006u\u0018q B\u0003\u0005\u0013\u0011YA!\u0004\u0011\u0007\r\u000b\t/C\u0002\u0002d\u0016\u00121d\u0015;bi\u0016\u001c6\r[3nCZ\u000bG.\u001b3bi&|gNU3tk2$\bbBAt9\u0001\u0007\u0011\u0011^\u0001\ngR\fG/Z%oM>\u00042a]Av\u0013\r\tio\n\u0002\u001a'R\fG/\u001a4vY>\u0003XM]1u_J\u001cF/\u0019;f\u0013:4w\u000eC\u0003G9\u0001\u0007q\tC\u0004\u0002.r\u0001\r!!\u0001\t\u000f\u0005UH\u00041\u0001\u0002x\u0006a1/Z:tS>t7\u000b^1uKB\u0019\u00110!?\n\u0007\u0005m(P\u0001\u0007TKN\u001c\u0018n\u001c8Ti\u0006$X\rC\u0004\u00024q\u0001\r!!\u000e\t\u0013\t\u0005A\u0004%AA\u0002\t\r\u0011\u0001D3yiJ\fw\n\u001d;j_:\u001c\b\u0003CA\b\u0003/\ti\"!\b\t\u0013\t\u001dA\u0004%AA\u0002\u0005u\u0011!C:u_J,g*Y7f\u0011\u001dyE\u0004%AA\u0002ACqA\u0019\u000f\u0011\u0002\u0003\u00071\rC\u0005\u0002&r\u0001\n\u00111\u0001\u0002t\u0005Yc/\u00197jI\u0006$X-\u00118e\u001b\u0006L(-Z#w_24Xm\u0015;bi\u0016\u001c6\r[3nC\u0012\"WMZ1vYR$c'\u0006\u0002\u0003\u0014)\"!1\u0001B\u000bW\t\u00119\u0002\u0005\u0003\u0003\u001a\t\rRB\u0001B\u000e\u0015\u0011\u0011iBa\b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0011o\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015\"1\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u000b<bY&$\u0017\r^3B]\u0012l\u0015-\u001f2f\u000bZ|GN^3Ti\u0006$XmU2iK6\fG\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t-\"\u0006BA\u000f\u0005+\t1F^1mS\u0012\fG/Z!oI6\u000b\u0017PY3Fm>dg/Z*uCR,7k\u00195f[\u0006$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005cQ3\u0001\u0015B\u000b\u0003-2\u0018\r\\5eCR,\u0017I\u001c3NCf\u0014W-\u0012<pYZ,7\u000b^1uKN\u001b\u0007.Z7bI\u0011,g-Y;mi\u0012JTC\u0001B\u001cU\r\u0019'QC\u0001-m\u0006d\u0017\u000eZ1uK\u0006sG-T1zE\u0016,eo\u001c7wKN#\u0018\r^3TG\",W.\u0019\u0013eK\u001a\fW\u000f\u001c;%cA*\"A!\u0010+\t\u0005M$QC\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0001")
public class StateSchemaCompatibilityChecker
implements Logging {
    private final List<Path> oldSchemaFilePaths;
    private final Option<Path> newSchemaFilePath;
    private final Path org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation;
    private final CheckpointFileManager fm;
    private final SQLConf conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Path> $lessinit$greater$default$4() {
        return StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4();
    }

    public static List<Path> $lessinit$greater$default$3() {
        return StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean validateAndMaybeEvolveStateSchema$default$10() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$10();
    }

    public static Option<Path> validateAndMaybeEvolveStateSchema$default$9() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$9();
    }

    public static List<Path> validateAndMaybeEvolveStateSchema$default$8() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$8();
    }

    public static String validateAndMaybeEvolveStateSchema$default$7() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$7();
    }

    public static scala.collection.immutable.Map<String, String> validateAndMaybeEvolveStateSchema$default$6() {
        return StateSchemaCompatibilityChecker$.MODULE$.validateAndMaybeEvolveStateSchema$default$6();
    }

    public static int SCHEMA_FORMAT_V3() {
        return StateSchemaCompatibilityChecker$.MODULE$.SCHEMA_FORMAT_V3();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Path org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation() {
        return this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation;
    }

    private CheckpointFileManager fm() {
        return this.fm;
    }

    private SQLConf conf() {
        return this.conf;
    }

    public List<StateStoreColFamilySchema> readSchemaFile() {
        FSDataInputStream inStream = this.fm().open(this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation());
        return StateSchemaCompatibilityChecker$.MODULE$.readSchemaFile(inStream);
    }

    public scala.collection.immutable.Map<String, List<StateStoreColFamilySchema>> readSchemaFiles() {
        List stateSchemaFilePaths = (List)((SeqOps)this.oldSchemaFilePaths.$plus$plus((IterableOnce)new .colon.colon((Object)this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation(), (List)Nil$.MODULE$))).distinct();
        return stateSchemaFilePaths.flatMap((Function1 & Serializable)schemaFile -> {
            if (this.fm().exists((Path)schemaFile)) {
                FSDataInputStream inStream = this.fm().open((Path)schemaFile);
                return StateSchemaCompatibilityChecker$.MODULE$.readSchemaFile(inStream);
            }
            return package$.MODULE$.List().empty();
        }).groupBy((Function1 & Serializable)x$1 -> x$1.colFamilyName());
    }

    private void createSchemaFile(List<StateStoreColFamilySchema> stateStoreColFamilySchema, int stateSchemaVersion) {
        if (stateSchemaVersion == StateSchemaCompatibilityChecker$.MODULE$.SCHEMA_FORMAT_V3() && this.newSchemaFilePath.isEmpty()) {
            throw new IllegalStateException("Schema file path is required for schema version 3");
        }
        SchemaHelper.SchemaWriter schemaWriter = SchemaHelper$SchemaWriter$.MODULE$.createSchemaWriter(stateSchemaVersion);
        this.createSchemaFile(stateStoreColFamilySchema, schemaWriter);
    }

    public void createSchemaFile(List<StateStoreColFamilySchema> stateStoreColFamilySchema, SchemaHelper.SchemaWriter schemaWriter) {
        Path path;
        Option<Path> option = this.newSchemaFilePath;
        if (option instanceof Some) {
            Some some = (Some)option;
            Path path2 = (Path)some.value();
            this.fm().mkdirs(path2.getParent());
            path = path2;
        } else if (None$.MODULE$.equals(option)) {
            path = this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation();
        } else {
            throw new MatchError(option);
        }
        Path schemaFilePath = path;
        CheckpointFileManager.CancellableFSDataOutputStream outStream = this.fm().createAtomic(schemaFilePath, false);
        try {
            schemaWriter.write(stateStoreColFamilySchema, outStream);
            outStream.close();
        }
        catch (Throwable e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to write schema file to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)schemaFilePath)}))), e);
            outStream.cancel();
            throw e;
        }
    }

    private List<StateStoreColFamilySchema> getExistingKeyAndValueSchema() {
        if (this.fm().exists(this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation())) {
            return this.readSchemaFile();
        }
        return package$.MODULE$.List().empty();
    }

    private boolean schemasCompatible(StructType storedSchema, StructType schema) {
        return DataType$.MODULE$.equalsIgnoreNameAndCompatibleNullability((DataType)schema, (DataType)storedSchema);
    }

    private Tuple2<StateStoreColFamilySchema, Object> check(List<StateStoreColFamilySchema> oldSchemas, StateStoreColFamilySchema newSchema, boolean ignoreValueSchema, boolean schemaEvolutionEnabled) {
        StateStoreColFamilySchema mostRecentSchema = (StateStoreColFamilySchema)oldSchemas.last();
        short x$1 = mostRecentSchema.keySchemaId();
        short x$2 = mostRecentSchema.valueSchemaId();
        String x$3 = newSchema.copy$default$1();
        StructType x$42 = newSchema.copy$default$3();
        StructType x$5 = newSchema.copy$default$5();
        Option<KeyStateEncoderSpec> x$6 = newSchema.copy$default$6();
        Option<StructType> x$7 = newSchema.copy$default$7();
        StateStoreColFamilySchema resultSchema = newSchema.copy(x$3, x$1, x$42, x$2, x$5, x$6, x$7);
        Tuple2 tuple2 = new Tuple2((Object)mostRecentSchema.keySchema(), (Object)mostRecentSchema.valueSchema());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructType storedKeySchema = (StructType)tuple2._1();
        StructType storedValueSchema = (StructType)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)storedKeySchema, (Object)storedValueSchema);
        StructType storedKeySchema2 = (StructType)tuple22._1();
        StructType storedValueSchema2 = (StructType)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)newSchema.keySchema(), (Object)newSchema.valueSchema());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        StructType keySchema = (StructType)tuple23._1();
        StructType valueSchema = (StructType)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)keySchema, (Object)valueSchema);
        StructType keySchema2 = (StructType)tuple24._1();
        StructType valueSchema2 = (StructType)tuple24._2();
        if (storedKeySchema2.equals((Object)keySchema2) && (ignoreValueSchema || storedValueSchema2.equals((Object)valueSchema2))) {
            return new Tuple2((Object)mostRecentSchema, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (!this.schemasCompatible(storedKeySchema2, keySchema2)) {
            throw StateStoreErrors$.MODULE$.stateStoreKeySchemaNotCompatible(storedKeySchema2.toString(), keySchema2.toString());
        }
        if (!ignoreValueSchema && schemaEvolutionEnabled) {
            java.lang.Iterable oldStateSchemas = CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)((List)oldSchemas.sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToShort((short)x$4.valueSchemaId()), (Ordering)Ordering.Short$.MODULE$)).reverse().map((Function1 & Serializable)oldSchema -> new StateSchemaMetadataValue(oldSchema.valueSchema(), SchemaConverters$.MODULE$.toAvroTypeWithDefaults(oldSchema.valueSchema())))).asJava();
            Schema newAvroSchema = SchemaConverters$.MODULE$.toAvroTypeWithDefaults(valueSchema2);
            SchemaValidator validator = new SchemaValidatorBuilder().canReadStrategy().validateAll();
            oldStateSchemas.forEach(oldStateSchema -> {
                try {
                    validator.validate(newAvroSchema, CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)oldStateSchema.avroSchema(), (List)Nil$.MODULE$)).asJava());
                }
                catch (SchemaValidationException schemaValidationException) {
                    throw StateStoreErrors$.MODULE$.stateStoreInvalidValueSchemaEvolution(oldStateSchema.sqlSchema().toString(), valueSchema2.toString());
                }
                catch (Throwable e) {
                    throw e;
                }
            });
            if (resultSchema.valueSchemaId() + 1 >= this.conf().streamingValueStateSchemaEvolutionThreshold()) {
                throw StateStoreErrors$.MODULE$.stateStoreValueSchemaEvolutionThresholdExceeded(resultSchema.valueSchemaId() + 1, this.conf().streamingValueStateSchemaEvolutionThreshold(), newSchema.colFamilyName());
            }
            short x$8 = StateSchemaCompatibilityChecker.incrementSchemaId$1(mostRecentSchema.valueSchemaId());
            String x$9 = resultSchema.copy$default$1();
            short x$10 = resultSchema.copy$default$2();
            StructType x$11 = resultSchema.copy$default$3();
            StructType x$12 = resultSchema.copy$default$5();
            Option<KeyStateEncoderSpec> x$13 = resultSchema.copy$default$6();
            Option<StructType> x$14 = resultSchema.copy$default$7();
            return new Tuple2((Object)resultSchema.copy(x$9, x$10, x$11, x$8, x$12, x$13, x$14), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        if (!ignoreValueSchema && !this.schemasCompatible(storedValueSchema2, valueSchema2)) {
            throw StateStoreErrors$.MODULE$.stateStoreValueSchemaNotCompatible(storedValueSchema2.toString(), valueSchema2.toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Detected schema change which is compatible. Allowing to put rows.");
        return new Tuple2((Object)mostRecentSchema, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public boolean validateAndMaybeEvolveStateSchema(List<StateStoreColFamilySchema> newStateSchema, boolean ignoreValueSchema, int stateSchemaVersion, boolean schemaEvolutionEnabled) {
        boolean newSchemaFileWritten;
        block3: {
            scala.collection.immutable.Map<String, List<StateStoreColFamilySchema>> existingStateSchemaMap = this.readSchemaFiles();
            List mostRecentColFamilies = this.getExistingKeyAndValueSchema().map((Function1 & Serializable)x$5 -> x$5.colFamilyName());
            if (mostRecentColFamilies.isEmpty()) {
                List initializedSchemas = newStateSchema.map((Function1 & Serializable)schema -> {
                    boolean x$1 = false;
                    boolean x$2 = false;
                    String x$3 = schema.copy$default$1();
                    StructType x$4 = schema.copy$default$3();
                    StructType x$5 = schema.copy$default$5();
                    Option<KeyStateEncoderSpec> x$6 = schema.copy$default$6();
                    Option<StructType> x$7 = schema.copy$default$7();
                    return schema.copy(x$3, (short)0, x$4, (short)0, x$5, x$6, x$7);
                });
                this.createSchemaFile((List<StateStoreColFamilySchema>)((List)initializedSchemas.sortBy((Function1 & Serializable)x$6 -> x$6.colFamilyName(), (Ordering)Ordering.String$.MODULE$)), stateSchemaVersion);
                return true;
            }
            Tuple2 tuple2 = (Tuple2)newStateSchema.foldLeft((Object)new Tuple2((Object)package$.MODULE$.List().empty(), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    StateStoreColFamilySchema newSchema = (StateStoreColFamilySchema)tuple2._2();
                    if (tuple22 != null) {
                        List schemas = (List)tuple22._1();
                        boolean evolved = tuple22._2$mcZ$sp();
                        Option option = existingStateSchemaMap.get((Object)newSchema.colFamilyName());
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            List existingSchemas = (List)some.value();
                            Tuple2<StateStoreColFamilySchema, Object> tuple23 = this.check((List<StateStoreColFamilySchema>)existingSchemas, newSchema, ignoreValueSchema, schemaEvolutionEnabled);
                            if (tuple23 == null) {
                                throw new MatchError(tuple23);
                            }
                            StateStoreColFamilySchema updatedSchema = (StateStoreColFamilySchema)tuple23._1();
                            boolean hasEvolved = tuple23._2$mcZ$sp();
                            Tuple2 tuple24 = new Tuple2((Object)updatedSchema, (Object)BoxesRunTime.boxToBoolean((boolean)hasEvolved));
                            StateStoreColFamilySchema updatedSchema2 = (StateStoreColFamilySchema)tuple24._1();
                            boolean hasEvolved2 = tuple24._2$mcZ$sp();
                            StateStoreColFamilySchema stateStoreColFamilySchema = updatedSchema2;
                            return new Tuple2((Object)schemas.$colon$colon((Object)stateStoreColFamilySchema), (Object)BoxesRunTime.boxToBoolean((evolved || hasEvolved2 ? 1 : 0) != 0));
                        }
                        if (None$.MODULE$.equals(option)) {
                            StateStoreColFamilySchema newSchemaWithIds;
                            boolean x$8 = false;
                            boolean x$9 = false;
                            String x$10 = newSchema.copy$default$1();
                            StructType x$11 = newSchema.copy$default$3();
                            StructType x$12 = newSchema.copy$default$5();
                            Option<KeyStateEncoderSpec> x$13 = newSchema.copy$default$6();
                            Option<StructType> x$14 = newSchema.copy$default$7();
                            StateStoreColFamilySchema stateStoreColFamilySchema = newSchemaWithIds = newSchema.copy(x$10, (short)0, x$11, (short)0, x$12, x$13, x$14);
                            return new Tuple2((Object)schemas.$colon$colon((Object)stateStoreColFamilySchema), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        }
                        throw new MatchError((Object)option);
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List evolvedSchemas = (List)tuple2._1();
            boolean hasEvolutions = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)evolvedSchemas, (Object)BoxesRunTime.boxToBoolean((boolean)hasEvolutions));
            List evolvedSchemas2 = (List)tuple22._1();
            boolean hasEvolutions2 = tuple22._2$mcZ$sp();
            scala.collection.immutable.Set newColFamilies = newStateSchema.map((Function1 & Serializable)x$9 -> x$9.colFamilyName()).toSet();
            scala.collection.immutable.Set oldColFamilies = mostRecentColFamilies.toSet();
            scala.collection.immutable.Set set = newColFamilies;
            scala.collection.immutable.Set set2 = oldColFamilies;
            boolean colFamiliesAddedOrRemoved = set == null ? set2 != null : !set.equals(set2);
            boolean bl = newSchemaFileWritten = hasEvolutions2 || colFamiliesAddedOrRemoved;
            if (this.oldSchemaFilePaths.size() == this.conf().streamingStateSchemaFilesThreshold() && colFamiliesAddedOrRemoved) {
                throw StateStoreErrors$.MODULE$.streamingStateSchemaFilesThresholdExceeded(this.oldSchemaFilePaths.size() + 1, this.conf().streamingStateSchemaFilesThreshold(), (List<String>)newColFamilies.diff((Set)oldColFamilies).toList(), (List<String>)oldColFamilies.diff((Set)newColFamilies).toList());
            }
            if (stateSchemaVersion != StateSchemaCompatibilityChecker$.MODULE$.SCHEMA_FORMAT_V3() || !newSchemaFileWritten) break block3;
            this.createSchemaFile((List<StateStoreColFamilySchema>)((List)evolvedSchemas2.sortBy((Function1 & Serializable)x$10 -> x$10.colFamilyName(), (Ordering)Ordering.String$.MODULE$)), stateSchemaVersion);
        }
        return newSchemaFileWritten;
    }

    private Path schemaFile(Path storeCpLocation) {
        return new Path(new Path(storeCpLocation, "_metadata"), "schema");
    }

    private static final short incrementSchemaId$1(short id) {
        return (short)(id + 1);
    }

    public StateSchemaCompatibilityChecker(StateStoreProviderId providerId, Configuration hadoopConf, List<Path> oldSchemaFilePaths, Option<Path> newSchemaFilePath) {
        Path path;
        this.oldSchemaFilePaths = oldSchemaFilePaths;
        this.newSchemaFilePath = newSchemaFilePath;
        Logging.$init$((Logging)this);
        if (oldSchemaFilePaths.isEmpty()) {
            Path storeCpLocation = providerId.storeId().storeCheckpointLocation();
            path = this.schemaFile(storeCpLocation);
        } else {
            path = (Path)oldSchemaFilePaths.last();
        }
        this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation = path;
        this.fm = CheckpointFileManager$.MODULE$.create(this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation(), hadoopConf);
        this.fm().mkdirs(this.org$apache$spark$sql$execution$streaming$state$StateSchemaCompatibilityChecker$$schemaFileLocation().getParent());
        this.conf = ((SparkSession)SparkSession$.MODULE$.getActiveSession().get()).sessionState().conf();
    }
}

