/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SessionWindow$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateMode;
import org.apache.spark.sql.catalyst.expressions.aggregate.Complete$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Final$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Partial$;
import org.apache.spark.sql.catalyst.expressions.aggregate.PartialMerge$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.aggregate.HashAggregateExec;
import org.apache.spark.sql.execution.aggregate.MergingSessionsExec;
import org.apache.spark.sql.execution.aggregate.ObjectHashAggregateExec;
import org.apache.spark.sql.execution.aggregate.SortAggregateExec;
import org.apache.spark.sql.execution.aggregate.UpdatingSessionsExec;
import org.apache.spark.sql.execution.streaming.SessionWindowStateStoreRestoreExec;
import org.apache.spark.sql.execution.streaming.SessionWindowStateStoreSaveExec;
import org.apache.spark.sql.execution.streaming.StateStoreRestoreExec;
import org.apache.spark.sql.execution.streaming.StateStoreSaveExec;
import org.apache.spark.sql.execution.streaming.StatefulOperatorStateInfo;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.util.collection.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class AggUtils$ {
    public static final AggUtils$ MODULE$ = new AggUtils$();

    private scala.collection.immutable.Seq<AggregateExpression> mayRemoveAggFilters(scala.collection.immutable.Seq<AggregateExpression> exprs) {
        return (scala.collection.immutable.Seq)exprs.map((Function1 & Serializable)ae -> {
            if (ae.filter().isDefined()) {
                AggregateMode aggregateMode = ae.mode();
                if (Partial$.MODULE$.equals(aggregateMode) ? true : Complete$.MODULE$.equals(aggregateMode)) {
                    return ae;
                }
                None$ x$1 = None$.MODULE$;
                AggregateFunction x$2 = ae.copy$default$1();
                AggregateMode x$3 = ae.copy$default$2();
                boolean x$4 = ae.copy$default$3();
                ExprId x$5 = ae.copy$default$5();
                return ae.copy(x$2, x$3, x$4, (Option)x$1, x$5);
            }
            return ae;
        });
    }

    private SparkPlan createStreamingAggregate(Option<scala.collection.immutable.Seq<Expression>> requiredChildDistributionExpressions, scala.collection.immutable.Seq<NamedExpression> groupingExpressions, scala.collection.immutable.Seq<AggregateExpression> aggregateExpressions, scala.collection.immutable.Seq<Attribute> aggregateAttributes, int initialInputBufferOffset, scala.collection.immutable.Seq<NamedExpression> resultExpressions, SparkPlan child) {
        return this.createAggregate(requiredChildDistributionExpressions, true, groupingExpressions, aggregateExpressions, aggregateAttributes, initialInputBufferOffset, resultExpressions, child);
    }

    private Option<scala.collection.immutable.Seq<Expression>> createStreamingAggregate$default$1() {
        return None$.MODULE$;
    }

    private scala.collection.immutable.Seq<NamedExpression> createStreamingAggregate$default$2() {
        return Nil$.MODULE$;
    }

    private scala.collection.immutable.Seq<AggregateExpression> createStreamingAggregate$default$3() {
        return Nil$.MODULE$;
    }

    private scala.collection.immutable.Seq<Attribute> createStreamingAggregate$default$4() {
        return Nil$.MODULE$;
    }

    private int createStreamingAggregate$default$5() {
        return 0;
    }

    private scala.collection.immutable.Seq<NamedExpression> createStreamingAggregate$default$6() {
        return Nil$.MODULE$;
    }

    private SparkPlan createAggregate(Option<scala.collection.immutable.Seq<Expression>> requiredChildDistributionExpressions, boolean isStreaming, scala.collection.immutable.Seq<NamedExpression> groupingExpressions, scala.collection.immutable.Seq<AggregateExpression> aggregateExpressions, scala.collection.immutable.Seq<Attribute> aggregateAttributes, int initialInputBufferOffset, scala.collection.immutable.Seq<NamedExpression> resultExpressions, SparkPlan child) {
        boolean useHash = Aggregate$.MODULE$.supportsHashAggregate((scala.collection.immutable.Seq)aggregateExpressions.flatMap((Function1 & Serializable)x$1 -> x$1.aggregateFunction().aggBufferAttributes()), groupingExpressions);
        boolean forceObjHashAggregate = this.forceApplyObjectHashAggregate(child.conf());
        boolean forceSortAggregate = this.forceApplySortAggregate(child.conf());
        if (useHash && !forceSortAggregate && !forceObjHashAggregate) {
            return new HashAggregateExec(requiredChildDistributionExpressions, isStreaming, (Option<Object>)None$.MODULE$, groupingExpressions, this.mayRemoveAggFilters(aggregateExpressions), aggregateAttributes, initialInputBufferOffset, resultExpressions, child);
        }
        boolean objectHashEnabled = child.conf().useObjectHashAggregation();
        boolean useObjectHash = Aggregate$.MODULE$.supportsObjectHashAggregate(aggregateExpressions, groupingExpressions);
        if (forceObjHashAggregate || objectHashEnabled && useObjectHash && !forceSortAggregate) {
            return new ObjectHashAggregateExec(requiredChildDistributionExpressions, isStreaming, (Option<Object>)None$.MODULE$, groupingExpressions, this.mayRemoveAggFilters(aggregateExpressions), aggregateAttributes, initialInputBufferOffset, resultExpressions, child);
        }
        return new SortAggregateExec(requiredChildDistributionExpressions, isStreaming, (Option<Object>)None$.MODULE$, groupingExpressions, this.mayRemoveAggFilters(aggregateExpressions), aggregateAttributes, initialInputBufferOffset, resultExpressions, child);
    }

    private Option<scala.collection.immutable.Seq<Expression>> createAggregate$default$1() {
        return None$.MODULE$;
    }

    private boolean createAggregate$default$2() {
        return false;
    }

    private scala.collection.immutable.Seq<NamedExpression> createAggregate$default$3() {
        return Nil$.MODULE$;
    }

    private scala.collection.immutable.Seq<AggregateExpression> createAggregate$default$4() {
        return Nil$.MODULE$;
    }

    private scala.collection.immutable.Seq<Attribute> createAggregate$default$5() {
        return Nil$.MODULE$;
    }

    private int createAggregate$default$6() {
        return 0;
    }

    private scala.collection.immutable.Seq<NamedExpression> createAggregate$default$7() {
        return Nil$.MODULE$;
    }

    public scala.collection.immutable.Seq<SparkPlan> planAggregateWithoutDistinct(scala.collection.immutable.Seq<NamedExpression> groupingExpressions, scala.collection.immutable.Seq<AggregateExpression> aggregateExpressions, scala.collection.immutable.Seq<NamedExpression> resultExpressions, SparkPlan child) {
        SparkPlan finalAggregate;
        scala.collection.immutable.Seq groupingAttributes = (scala.collection.immutable.Seq)groupingExpressions.map((Function1 & Serializable)x$2 -> x$2.toAttribute());
        scala.collection.immutable.Seq partialAggregateExpressions = (scala.collection.immutable.Seq)aggregateExpressions.map((Function1 & Serializable)x$3 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$3.copy$default$1();
            boolean x$32 = x$3.copy$default$3();
            Option x$4 = x$3.copy$default$4();
            ExprId x$5 = x$3.copy$default$5();
            return x$3.copy(x$2, (AggregateMode)x$1, x$32, x$4, x$5);
        });
        scala.collection.immutable.Seq partialAggregateAttributes = (scala.collection.immutable.Seq)partialAggregateExpressions.flatMap((Function1 & Serializable)x$4 -> x$4.aggregateFunction().aggBufferAttributes());
        scala.collection.immutable.Seq partialResultExpressions = (scala.collection.immutable.Seq)groupingAttributes.$plus$plus((IterableOnce)partialAggregateExpressions.flatMap((Function1 & Serializable)x$5 -> x$5.aggregateFunction().inputAggBufferAttributes()));
        None$ x$62 = None$.MODULE$;
        scala.collection.immutable.Seq<NamedExpression> x$72 = groupingExpressions;
        scala.collection.immutable.Seq x$8 = partialAggregateExpressions;
        scala.collection.immutable.Seq x$9 = partialAggregateAttributes;
        boolean x$10 = false;
        scala.collection.immutable.Seq x$11 = partialResultExpressions;
        SparkPlan x$12 = child;
        boolean x$13 = this.createAggregate$default$2();
        SparkPlan partialAggregate = this.createAggregate((Option<scala.collection.immutable.Seq<Expression>>)x$62, x$13, x$72, (scala.collection.immutable.Seq<AggregateExpression>)x$8, (scala.collection.immutable.Seq<Attribute>)x$9, 0, (scala.collection.immutable.Seq<NamedExpression>)x$11, x$12);
        SparkPlan interExec = this.mayAppendMergingSessionExec(groupingExpressions, aggregateExpressions, partialAggregate, this.mayAppendMergingSessionExec$default$4());
        scala.collection.immutable.Seq finalAggregateExpressions = (scala.collection.immutable.Seq)aggregateExpressions.map((Function1 & Serializable)x$6 -> {
            Final$ x$14 = Final$.MODULE$;
            AggregateFunction x$15 = x$6.copy$default$1();
            boolean x$16 = x$6.copy$default$3();
            Option x$17 = x$6.copy$default$4();
            ExprId x$18 = x$6.copy$default$5();
            return x$6.copy(x$15, (AggregateMode)x$14, x$16, x$17, x$18);
        });
        scala.collection.immutable.Seq finalAggregateAttributes = (scala.collection.immutable.Seq)finalAggregateExpressions.map((Function1 & Serializable)x$7 -> x$7.resultAttribute());
        Some x$19 = new Some((Object)groupingAttributes);
        scala.collection.immutable.Seq x$20 = groupingAttributes;
        scala.collection.immutable.Seq x$21 = finalAggregateExpressions;
        scala.collection.immutable.Seq x$22 = finalAggregateAttributes;
        int x$23 = groupingExpressions.length();
        scala.collection.immutable.Seq<NamedExpression> x$24 = resultExpressions;
        SparkPlan x$25 = interExec;
        boolean x$26 = this.createAggregate$default$2();
        SparkPlan sparkPlan = finalAggregate = this.createAggregate((Option<scala.collection.immutable.Seq<Expression>>)x$19, x$26, (scala.collection.immutable.Seq<NamedExpression>)x$20, (scala.collection.immutable.Seq<AggregateExpression>)x$21, (scala.collection.immutable.Seq<Attribute>)x$22, x$23, x$24, x$25);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    public scala.collection.immutable.Seq<SparkPlan> planAggregateWithOneDistinct(scala.collection.immutable.Seq<NamedExpression> groupingExpressions, scala.collection.immutable.Seq<AggregateExpression> functionsWithDistinct, scala.collection.immutable.Seq<AggregateExpression> functionsWithoutDistinct, scala.collection.immutable.Seq<Expression> distinctExpressions, scala.collection.immutable.Seq<NamedExpression> normalizedNamedDistinctExpressions, scala.collection.immutable.Seq<NamedExpression> resultExpressions, SparkPlan child) {
        SparkPlan finalAndCompleteAggregate;
        SparkPlan maySessionChild = this.mayAppendUpdatingSessionExec(groupingExpressions, child, this.mayAppendUpdatingSessionExec$default$3());
        scala.collection.immutable.Seq distinctAttributes = (scala.collection.immutable.Seq)normalizedNamedDistinctExpressions.map((Function1 & Serializable)x$8 -> x$8.toAttribute());
        scala.collection.immutable.Seq groupingAttributes = (scala.collection.immutable.Seq)groupingExpressions.map((Function1 & Serializable)x$9 -> x$9.toAttribute());
        scala.collection.immutable.Seq aggregateExpressions = (scala.collection.immutable.Seq)functionsWithoutDistinct.map((Function1 & Serializable)x$10 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$10.copy$default$1();
            boolean x$3 = x$10.copy$default$3();
            Option x$4 = x$10.copy$default$4();
            ExprId x$5 = x$10.copy$default$5();
            return x$10.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
        });
        scala.collection.immutable.Seq aggregateAttributes = (scala.collection.immutable.Seq)aggregateExpressions.map((Function1 & Serializable)x$11 -> x$11.resultAttribute());
        scala.collection.immutable.Seq x$6 = (scala.collection.immutable.Seq)groupingExpressions.$plus$plus(normalizedNamedDistinctExpressions);
        scala.collection.immutable.Seq x$7 = aggregateExpressions;
        scala.collection.immutable.Seq x$82 = aggregateAttributes;
        scala.collection.immutable.Seq x$92 = (scala.collection.immutable.Seq)((IterableOps)groupingAttributes.$plus$plus((IterableOnce)distinctAttributes)).$plus$plus((IterableOnce)aggregateExpressions.flatMap((Function1 & Serializable)x$12 -> x$12.aggregateFunction().inputAggBufferAttributes()));
        SparkPlan x$102 = maySessionChild;
        Option<scala.collection.immutable.Seq<Expression>> x$112 = this.createAggregate$default$1();
        boolean x$122 = this.createAggregate$default$2();
        int x$132 = this.createAggregate$default$6();
        SparkPlan partialAggregate = this.createAggregate(x$112, x$122, (scala.collection.immutable.Seq<NamedExpression>)x$6, (scala.collection.immutable.Seq<AggregateExpression>)x$7, (scala.collection.immutable.Seq<Attribute>)x$82, x$132, (scala.collection.immutable.Seq<NamedExpression>)x$92, x$102);
        scala.collection.immutable.Seq aggregateExpressions2 = (scala.collection.immutable.Seq)functionsWithoutDistinct.map((Function1 & Serializable)x$13 -> {
            PartialMerge$ x$14 = PartialMerge$.MODULE$;
            AggregateFunction x$15 = x$13.copy$default$1();
            boolean x$16 = x$13.copy$default$3();
            Option x$17 = x$13.copy$default$4();
            ExprId x$18 = x$13.copy$default$5();
            return x$13.copy(x$15, (AggregateMode)x$14, x$16, x$17, x$18);
        });
        scala.collection.immutable.Seq aggregateAttributes2 = (scala.collection.immutable.Seq)aggregateExpressions2.map((Function1 & Serializable)x$14 -> x$14.resultAttribute());
        Some x$19 = new Some(groupingAttributes.$plus$plus((IterableOnce)distinctAttributes));
        scala.collection.immutable.Seq x$202 = (scala.collection.immutable.Seq)groupingAttributes.$plus$plus((IterableOnce)distinctAttributes);
        scala.collection.immutable.Seq x$212 = aggregateExpressions2;
        scala.collection.immutable.Seq x$222 = aggregateAttributes2;
        int x$232 = ((SeqOps)groupingAttributes.$plus$plus((IterableOnce)distinctAttributes)).length();
        scala.collection.immutable.Seq x$24 = (scala.collection.immutable.Seq)((IterableOps)groupingAttributes.$plus$plus((IterableOnce)distinctAttributes)).$plus$plus((IterableOnce)aggregateExpressions2.flatMap((Function1 & Serializable)x$15 -> x$15.aggregateFunction().inputAggBufferAttributes()));
        SparkPlan x$25 = partialAggregate;
        boolean x$26 = this.createAggregate$default$2();
        SparkPlan partialMergeAggregate = this.createAggregate((Option<scala.collection.immutable.Seq<Expression>>)x$19, x$26, (scala.collection.immutable.Seq<NamedExpression>)x$202, (scala.collection.immutable.Seq<AggregateExpression>)x$212, (scala.collection.immutable.Seq<Attribute>)x$222, x$232, (scala.collection.immutable.Seq<NamedExpression>)x$24, x$25);
        Map distinctColumnAttributeLookup = Utils$.MODULE$.toMap((Iterable)distinctExpressions.map((Function1 & Serializable)x$16 -> x$16.canonicalized()), (Iterable)distinctAttributes);
        scala.collection.immutable.Seq rewrittenDistinctFunctions = (scala.collection.immutable.Seq)functionsWithDistinct.map((Function1 & Serializable)x0$1 -> {
            AggregateExpression aggregateExpression = x0$1;
            if (aggregateExpression != null) {
                AggregateFunction aggregateFunction = aggregateExpression.aggregateFunction();
                boolean bl = aggregateExpression.isDistinct();
                if (bl) {
                    return (AggregateFunction)aggregateFunction.transformDown((PartialFunction)new Serializable(distinctColumnAttributeLookup){
                        private static final long serialVersionUID = 0L;
                        private final Map distinctColumnAttributeLookup$1;

                        public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1;
                            A1 A12 = x1;
                            if (A12 != null && this.distinctColumnAttributeLookup$1.contains((Object)(A1 = A12).canonicalized())) {
                                return (B1)this.distinctColumnAttributeLookup$1.apply((Object)A1.canonicalized());
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Expression x1) {
                            Expression expression;
                            Expression expression2 = x1;
                            return expression2 != null && this.distinctColumnAttributeLookup$1.contains((Object)(expression = expression2).canonicalized());
                        }
                        {
                            this.distinctColumnAttributeLookup$1 = distinctColumnAttributeLookup$1;
                        }
                    });
                }
            }
            throw new IllegalArgumentException("Non-distinct aggregate is found in functionsWithDistinct at planAggregateWithOneDistinct: " + aggregateExpression);
        });
        scala.collection.immutable.Seq mergeAggregateExpressions = (scala.collection.immutable.Seq)functionsWithoutDistinct.map((Function1 & Serializable)x$17 -> {
            PartialMerge$ x$27 = PartialMerge$.MODULE$;
            AggregateFunction x$28 = x$17.copy$default$1();
            boolean x$29 = x$17.copy$default$3();
            Option x$30 = x$17.copy$default$4();
            ExprId x$31 = x$17.copy$default$5();
            return x$17.copy(x$28, (AggregateMode)x$27, x$29, x$30, x$31);
        });
        scala.collection.immutable.Seq mergeAggregateAttributes = (scala.collection.immutable.Seq)mergeAggregateExpressions.map((Function1 & Serializable)x$18 -> x$18.resultAttribute());
        Tuple2 tuple2 = ((IterableOps)((IterableOps)rewrittenDistinctFunctions.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                AggregateFunction func = (AggregateFunction)tuple2._1();
                int i = tuple2._2$mcI$sp();
                AggregateExpression expr = AggregateExpression$.MODULE$.apply(func, (AggregateMode)Partial$.MODULE$, true, AggregateExpression$.MODULE$.apply$default$4());
                Attribute attr = ((AggregateExpression)functionsWithDistinct.apply(i)).resultAttribute();
                return new Tuple2((Object)expr, (Object)attr);
            }
            throw new MatchError((Object)tuple2);
        })).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq distinctAggregateExpressions = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq distinctAggregateAttributes = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)distinctAggregateExpressions, (Object)distinctAggregateAttributes);
        scala.collection.immutable.Seq distinctAggregateExpressions2 = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq distinctAggregateAttributes2 = (scala.collection.immutable.Seq)tuple22._2();
        scala.collection.immutable.Seq partialAggregateResult = (scala.collection.immutable.Seq)((IterableOps)groupingAttributes.$plus$plus((IterableOnce)mergeAggregateExpressions.flatMap((Function1 & Serializable)x$20 -> x$20.aggregateFunction().inputAggBufferAttributes()))).$plus$plus((IterableOnce)distinctAggregateExpressions2.flatMap((Function1 & Serializable)x$21 -> x$21.aggregateFunction().inputAggBufferAttributes()));
        scala.collection.immutable.Seq x$32 = groupingAttributes;
        scala.collection.immutable.Seq x$33 = (scala.collection.immutable.Seq)mergeAggregateExpressions.$plus$plus((IterableOnce)distinctAggregateExpressions2);
        scala.collection.immutable.Seq x$34 = (scala.collection.immutable.Seq)mergeAggregateAttributes.$plus$plus((IterableOnce)distinctAggregateAttributes2);
        int x$35 = ((SeqOps)groupingAttributes.$plus$plus((IterableOnce)distinctAttributes)).length();
        scala.collection.immutable.Seq x$36 = partialAggregateResult;
        SparkPlan x$37 = partialMergeAggregate;
        Option<scala.collection.immutable.Seq<Expression>> x$38 = this.createAggregate$default$1();
        boolean x$39 = this.createAggregate$default$2();
        SparkPlan partialDistinctAggregate = this.createAggregate(x$38, x$39, (scala.collection.immutable.Seq<NamedExpression>)x$32, (scala.collection.immutable.Seq<AggregateExpression>)x$33, (scala.collection.immutable.Seq<Attribute>)x$34, x$35, (scala.collection.immutable.Seq<NamedExpression>)x$36, x$37);
        scala.collection.immutable.Seq finalAggregateExpressions = (scala.collection.immutable.Seq)functionsWithoutDistinct.map((Function1 & Serializable)x$22 -> {
            Final$ x$40 = Final$.MODULE$;
            AggregateFunction x$41 = x$22.copy$default$1();
            boolean x$42 = x$22.copy$default$3();
            Option x$43 = x$22.copy$default$4();
            ExprId x$44 = x$22.copy$default$5();
            return x$22.copy(x$41, (AggregateMode)x$40, x$42, x$43, x$44);
        });
        scala.collection.immutable.Seq finalAggregateAttributes = (scala.collection.immutable.Seq)finalAggregateExpressions.map((Function1 & Serializable)x$23 -> x$23.resultAttribute());
        Tuple2 tuple23 = ((IterableOps)((IterableOps)rewrittenDistinctFunctions.zipWithIndex()).map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                AggregateFunction func = (AggregateFunction)tuple2._1();
                int i = tuple2._2$mcI$sp();
                AggregateExpression expr = AggregateExpression$.MODULE$.apply(func, (AggregateMode)Final$.MODULE$, true, AggregateExpression$.MODULE$.apply$default$4());
                Attribute attr = ((AggregateExpression)functionsWithDistinct.apply(i)).resultAttribute();
                return new Tuple2((Object)expr, (Object)attr);
            }
            throw new MatchError((Object)tuple2);
        })).unzip(Predef$.MODULE$.$conforms());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        scala.collection.immutable.Seq distinctAggregateExpressions3 = (scala.collection.immutable.Seq)tuple23._1();
        scala.collection.immutable.Seq distinctAggregateAttributes3 = (scala.collection.immutable.Seq)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)distinctAggregateExpressions3, (Object)distinctAggregateAttributes3);
        scala.collection.immutable.Seq distinctAggregateExpressions4 = (scala.collection.immutable.Seq)tuple24._1();
        scala.collection.immutable.Seq distinctAggregateAttributes4 = (scala.collection.immutable.Seq)tuple24._2();
        Some x$45 = new Some((Object)groupingAttributes);
        scala.collection.immutable.Seq x$46 = groupingAttributes;
        scala.collection.immutable.Seq x$47 = (scala.collection.immutable.Seq)finalAggregateExpressions.$plus$plus((IterableOnce)distinctAggregateExpressions4);
        scala.collection.immutable.Seq x$48 = (scala.collection.immutable.Seq)finalAggregateAttributes.$plus$plus((IterableOnce)distinctAggregateAttributes4);
        int x$49 = groupingAttributes.length();
        scala.collection.immutable.Seq<NamedExpression> x$50 = resultExpressions;
        SparkPlan x$51 = partialDistinctAggregate;
        boolean x$52 = this.createAggregate$default$2();
        SparkPlan sparkPlan = finalAndCompleteAggregate = this.createAggregate((Option<scala.collection.immutable.Seq<Expression>>)x$45, x$52, (scala.collection.immutable.Seq<NamedExpression>)x$46, (scala.collection.immutable.Seq<AggregateExpression>)x$47, (scala.collection.immutable.Seq<Attribute>)x$48, x$49, x$50, x$51);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    public scala.collection.immutable.Seq<SparkPlan> planStreamingAggregation(scala.collection.immutable.Seq<NamedExpression> groupingExpressions, scala.collection.immutable.Seq<AggregateExpression> functionsWithoutDistinct, scala.collection.immutable.Seq<NamedExpression> resultExpressions, int stateFormatVersion, SparkPlan child) {
        SparkPlan finalAndCompleteAggregate;
        scala.collection.immutable.Seq groupingAttributes = (scala.collection.immutable.Seq)groupingExpressions.map((Function1 & Serializable)x$25 -> x$25.toAttribute());
        scala.collection.immutable.Seq aggregateExpressions = (scala.collection.immutable.Seq)functionsWithoutDistinct.map((Function1 & Serializable)x$26 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$26.copy$default$1();
            boolean x$3 = x$26.copy$default$3();
            Option x$4 = x$26.copy$default$4();
            ExprId x$5 = x$26.copy$default$5();
            return x$26.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
        });
        scala.collection.immutable.Seq aggregateAttributes = (scala.collection.immutable.Seq)aggregateExpressions.map((Function1 & Serializable)x$27 -> x$27.resultAttribute());
        scala.collection.immutable.Seq<NamedExpression> x$6 = groupingExpressions;
        scala.collection.immutable.Seq x$7 = aggregateExpressions;
        scala.collection.immutable.Seq x$8 = aggregateAttributes;
        scala.collection.immutable.Seq x$9 = (scala.collection.immutable.Seq)groupingAttributes.$plus$plus((IterableOnce)aggregateExpressions.flatMap((Function1 & Serializable)x$28 -> x$28.aggregateFunction().inputAggBufferAttributes()));
        SparkPlan x$10 = child;
        Option<scala.collection.immutable.Seq<Expression>> x$11 = this.createStreamingAggregate$default$1();
        int x$12 = this.createStreamingAggregate$default$5();
        SparkPlan partialAggregate = this.createStreamingAggregate(x$11, x$6, (scala.collection.immutable.Seq<AggregateExpression>)x$7, (scala.collection.immutable.Seq<Attribute>)x$8, x$12, (scala.collection.immutable.Seq<NamedExpression>)x$9, x$10);
        scala.collection.immutable.Seq aggregateExpressions2 = (scala.collection.immutable.Seq)functionsWithoutDistinct.map((Function1 & Serializable)x$29 -> {
            PartialMerge$ x$13 = PartialMerge$.MODULE$;
            AggregateFunction x$14 = x$29.copy$default$1();
            boolean x$15 = x$29.copy$default$3();
            Option x$16 = x$29.copy$default$4();
            ExprId x$17 = x$29.copy$default$5();
            return x$29.copy(x$14, (AggregateMode)x$13, x$15, x$16, x$17);
        });
        scala.collection.immutable.Seq aggregateAttributes2 = (scala.collection.immutable.Seq)aggregateExpressions2.map((Function1 & Serializable)x$30 -> x$30.resultAttribute());
        SparkPlan partialMerged1 = this.createStreamingAggregate((Option<scala.collection.immutable.Seq<Expression>>)new Some((Object)groupingAttributes), (scala.collection.immutable.Seq<NamedExpression>)groupingAttributes, (scala.collection.immutable.Seq<AggregateExpression>)aggregateExpressions2, (scala.collection.immutable.Seq<Attribute>)aggregateAttributes2, groupingAttributes.length(), (scala.collection.immutable.Seq<NamedExpression>)((scala.collection.immutable.Seq)groupingAttributes.$plus$plus((IterableOnce)aggregateExpressions2.flatMap((Function1 & Serializable)x$31 -> x$31.aggregateFunction().inputAggBufferAttributes()))), partialAggregate);
        StateStoreRestoreExec restored = new StateStoreRestoreExec((scala.collection.immutable.Seq<Attribute>)groupingAttributes, (Option<StatefulOperatorStateInfo>)None$.MODULE$, stateFormatVersion, partialMerged1);
        scala.collection.immutable.Seq aggregateExpressions3 = (scala.collection.immutable.Seq)functionsWithoutDistinct.map((Function1 & Serializable)x$32 -> {
            PartialMerge$ x$18 = PartialMerge$.MODULE$;
            AggregateFunction x$19 = x$32.copy$default$1();
            boolean x$20 = x$32.copy$default$3();
            Option x$21 = x$32.copy$default$4();
            ExprId x$22 = x$32.copy$default$5();
            return x$32.copy(x$19, (AggregateMode)x$18, x$20, x$21, x$22);
        });
        scala.collection.immutable.Seq aggregateAttributes3 = (scala.collection.immutable.Seq)aggregateExpressions3.map((Function1 & Serializable)x$33 -> x$33.resultAttribute());
        SparkPlan partialMerged2 = this.createStreamingAggregate((Option<scala.collection.immutable.Seq<Expression>>)new Some((Object)groupingAttributes), (scala.collection.immutable.Seq<NamedExpression>)groupingAttributes, (scala.collection.immutable.Seq<AggregateExpression>)aggregateExpressions3, (scala.collection.immutable.Seq<Attribute>)aggregateAttributes3, groupingAttributes.length(), (scala.collection.immutable.Seq<NamedExpression>)((scala.collection.immutable.Seq)groupingAttributes.$plus$plus((IterableOnce)aggregateExpressions3.flatMap((Function1 & Serializable)x$34 -> x$34.aggregateFunction().inputAggBufferAttributes()))), restored);
        StateStoreSaveExec saved = new StateStoreSaveExec((scala.collection.immutable.Seq<Attribute>)groupingAttributes, (Option<StatefulOperatorStateInfo>)None$.MODULE$, (Option<OutputMode>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, stateFormatVersion, partialMerged2);
        scala.collection.immutable.Seq finalAggregateExpressions = (scala.collection.immutable.Seq)functionsWithoutDistinct.map((Function1 & Serializable)x$35 -> {
            Final$ x$23 = Final$.MODULE$;
            AggregateFunction x$24 = x$35.copy$default$1();
            boolean x$25 = x$35.copy$default$3();
            Option x$26 = x$35.copy$default$4();
            ExprId x$27 = x$35.copy$default$5();
            return x$35.copy(x$24, (AggregateMode)x$23, x$25, x$26, x$27);
        });
        scala.collection.immutable.Seq finalAggregateAttributes = (scala.collection.immutable.Seq)finalAggregateExpressions.map((Function1 & Serializable)x$36 -> x$36.resultAttribute());
        SparkPlan sparkPlan = finalAndCompleteAggregate = this.createStreamingAggregate((Option<scala.collection.immutable.Seq<Expression>>)new Some((Object)groupingAttributes), (scala.collection.immutable.Seq<NamedExpression>)groupingAttributes, (scala.collection.immutable.Seq<AggregateExpression>)finalAggregateExpressions, (scala.collection.immutable.Seq<Attribute>)finalAggregateAttributes, groupingAttributes.length(), resultExpressions, saved);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan);
    }

    public scala.collection.immutable.Seq<SparkPlan> planStreamingAggregationForSession(scala.collection.immutable.Seq<NamedExpression> groupingExpressions, NamedExpression sessionExpression, scala.collection.immutable.Seq<AggregateExpression> functionsWithoutDistinct, scala.collection.immutable.Seq<NamedExpression> resultExpressions, int stateFormatVersion, boolean mergeSessionsInLocalPartition, SparkPlan child) {
        SparkPlan finalAndCompleteAggregate;
        SparkPlan sparkPlan;
        scala.collection.immutable.Seq groupWithoutSessionExpression = (scala.collection.immutable.Seq)groupingExpressions.filterNot((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AggUtils$.$anonfun$planStreamingAggregationForSession$1(sessionExpression, p)));
        if (groupWithoutSessionExpression.isEmpty()) {
            throw new AnalysisException("_LEGACY_ERROR_TEMP_3068", Predef$.MODULE$.Map().empty());
        }
        scala.collection.immutable.Seq groupingWithoutSessionAttributes = (scala.collection.immutable.Seq)groupWithoutSessionExpression.map((Function1 & Serializable)x$37 -> x$37.toAttribute());
        scala.collection.immutable.Seq groupingAttributes = (scala.collection.immutable.Seq)groupingExpressions.map((Function1 & Serializable)x$38 -> x$38.toAttribute());
        scala.collection.immutable.Seq aggregateExpressions = (scala.collection.immutable.Seq)functionsWithoutDistinct.map((Function1 & Serializable)x$39 -> {
            Partial$ x$1 = Partial$.MODULE$;
            AggregateFunction x$2 = x$39.copy$default$1();
            boolean x$3 = x$39.copy$default$3();
            Option x$4 = x$39.copy$default$4();
            ExprId x$5 = x$39.copy$default$5();
            return x$39.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
        });
        scala.collection.immutable.Seq aggregateAttributes = (scala.collection.immutable.Seq)aggregateExpressions.map((Function1 & Serializable)x$40 -> x$40.resultAttribute());
        scala.collection.immutable.Seq<NamedExpression> x$6 = groupingExpressions;
        scala.collection.immutable.Seq x$7 = aggregateExpressions;
        scala.collection.immutable.Seq x$8 = aggregateAttributes;
        scala.collection.immutable.Seq x$9 = (scala.collection.immutable.Seq)groupingAttributes.$plus$plus((IterableOnce)aggregateExpressions.flatMap((Function1 & Serializable)x$41 -> x$41.aggregateFunction().inputAggBufferAttributes()));
        SparkPlan x$10 = child;
        Option<scala.collection.immutable.Seq<Expression>> x$11 = this.createStreamingAggregate$default$1();
        int x$12 = this.createStreamingAggregate$default$5();
        SparkPlan partialAggregate = this.createStreamingAggregate(x$11, x$6, (scala.collection.immutable.Seq<AggregateExpression>)x$7, (scala.collection.immutable.Seq<Attribute>)x$8, x$12, (scala.collection.immutable.Seq<NamedExpression>)x$9, x$10);
        if (mergeSessionsInLocalPartition) {
            scala.collection.immutable.Seq aggregateExpressions2 = (scala.collection.immutable.Seq)functionsWithoutDistinct.map((Function1 & Serializable)x$42 -> {
                PartialMerge$ x$13 = PartialMerge$.MODULE$;
                AggregateFunction x$14 = x$42.copy$default$1();
                boolean x$15 = x$42.copy$default$3();
                Option x$16 = x$42.copy$default$4();
                ExprId x$17 = x$42.copy$default$5();
                return x$42.copy(x$14, (AggregateMode)x$13, x$15, x$16, x$17);
            });
            scala.collection.immutable.Seq aggregateAttributes2 = (scala.collection.immutable.Seq)aggregateExpressions2.map((Function1 & Serializable)x$43 -> x$43.resultAttribute());
            sparkPlan = new MergingSessionsExec((Option<scala.collection.immutable.Seq<Expression>>)None$.MODULE$, true, (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<NamedExpression>)groupingAttributes, sessionExpression, (scala.collection.immutable.Seq<AggregateExpression>)aggregateExpressions2, (scala.collection.immutable.Seq<Attribute>)aggregateAttributes2, groupingAttributes.length(), (scala.collection.immutable.Seq<NamedExpression>)((scala.collection.immutable.Seq)groupingAttributes.$plus$plus((IterableOnce)aggregateExpressions2.flatMap((Function1 & Serializable)x$44 -> x$44.aggregateFunction().inputAggBufferAttributes()))), partialAggregate);
        } else {
            sparkPlan = partialAggregate;
        }
        SparkPlan partialMerged1 = sparkPlan;
        SessionWindowStateStoreRestoreExec restored = new SessionWindowStateStoreRestoreExec((scala.collection.immutable.Seq<Attribute>)groupingWithoutSessionAttributes, sessionExpression.toAttribute(), (Option<StatefulOperatorStateInfo>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, stateFormatVersion, partialMerged1);
        scala.collection.immutable.Seq aggregateExpressions3 = (scala.collection.immutable.Seq)functionsWithoutDistinct.map((Function1 & Serializable)x$45 -> {
            PartialMerge$ x$18 = PartialMerge$.MODULE$;
            AggregateFunction x$19 = x$45.copy$default$1();
            boolean x$20 = x$45.copy$default$3();
            Option x$21 = x$45.copy$default$4();
            ExprId x$22 = x$45.copy$default$5();
            return x$45.copy(x$19, (AggregateMode)x$18, x$20, x$21, x$22);
        });
        scala.collection.immutable.Seq aggregateAttributes3 = (scala.collection.immutable.Seq)aggregateExpressions3.map((Function1 & Serializable)x$46 -> x$46.resultAttribute());
        MergingSessionsExec mergedSessions = new MergingSessionsExec((Option<scala.collection.immutable.Seq<Expression>>)new Some((Object)groupingWithoutSessionAttributes), true, (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<NamedExpression>)groupingAttributes, sessionExpression, (scala.collection.immutable.Seq<AggregateExpression>)aggregateExpressions3, (scala.collection.immutable.Seq<Attribute>)aggregateAttributes3, groupingAttributes.length(), (scala.collection.immutable.Seq<NamedExpression>)((scala.collection.immutable.Seq)groupingAttributes.$plus$plus((IterableOnce)aggregateExpressions3.flatMap((Function1 & Serializable)x$47 -> x$47.aggregateFunction().inputAggBufferAttributes()))), restored);
        SessionWindowStateStoreSaveExec saved = new SessionWindowStateStoreSaveExec((scala.collection.immutable.Seq<Attribute>)groupingWithoutSessionAttributes, sessionExpression.toAttribute(), (Option<StatefulOperatorStateInfo>)None$.MODULE$, (Option<OutputMode>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, stateFormatVersion, mergedSessions);
        scala.collection.immutable.Seq finalAggregateExpressions = (scala.collection.immutable.Seq)functionsWithoutDistinct.map((Function1 & Serializable)x$48 -> {
            Final$ x$23 = Final$.MODULE$;
            AggregateFunction x$24 = x$48.copy$default$1();
            boolean x$25 = x$48.copy$default$3();
            Option x$26 = x$48.copy$default$4();
            ExprId x$27 = x$48.copy$default$5();
            return x$48.copy(x$24, (AggregateMode)x$23, x$25, x$26, x$27);
        });
        scala.collection.immutable.Seq finalAggregateAttributes = (scala.collection.immutable.Seq)finalAggregateExpressions.map((Function1 & Serializable)x$49 -> x$49.resultAttribute());
        SparkPlan sparkPlan2 = finalAndCompleteAggregate = this.createStreamingAggregate((Option<scala.collection.immutable.Seq<Expression>>)new Some((Object)groupingWithoutSessionAttributes), (scala.collection.immutable.Seq<NamedExpression>)groupingAttributes, (scala.collection.immutable.Seq<AggregateExpression>)finalAggregateExpressions, (scala.collection.immutable.Seq<Attribute>)finalAggregateAttributes, groupingAttributes.length(), resultExpressions, saved);
        return Nil$.MODULE$.$colon$colon((Object)sparkPlan2);
    }

    private SparkPlan mayAppendUpdatingSessionExec(scala.collection.immutable.Seq<NamedExpression> groupingExpressions, SparkPlan maybeChildPlan, boolean isStreaming) {
        Option option = groupingExpressions.find((Function1 & Serializable)x$50 -> BoxesRunTime.boxToBoolean((boolean)AggUtils$.$anonfun$mayAppendUpdatingSessionExec$1(x$50)));
        if (option instanceof Some) {
            Some some = (Some)option;
            NamedExpression sessionExpression = (NamedExpression)some.value();
            return new UpdatingSessionsExec(isStreaming, (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<Attribute>)((scala.collection.immutable.Seq)groupingExpressions.map((Function1 & Serializable)x$51 -> x$51.toAttribute())), sessionExpression.toAttribute(), maybeChildPlan);
        }
        if (None$.MODULE$.equals(option)) {
            return maybeChildPlan;
        }
        throw new MatchError((Object)option);
    }

    private boolean mayAppendUpdatingSessionExec$default$3() {
        return false;
    }

    private SparkPlan mayAppendMergingSessionExec(scala.collection.immutable.Seq<NamedExpression> groupingExpressions, scala.collection.immutable.Seq<AggregateExpression> aggregateExpressions, SparkPlan partialAggregate, boolean isStreaming) {
        Option option = groupingExpressions.find((Function1 & Serializable)x$52 -> BoxesRunTime.boxToBoolean((boolean)AggUtils$.$anonfun$mayAppendMergingSessionExec$1(x$52)));
        if (option instanceof Some) {
            Some some = (Some)option;
            NamedExpression sessionExpression = (NamedExpression)some.value();
            scala.collection.immutable.Seq aggExpressions = (scala.collection.immutable.Seq)aggregateExpressions.map((Function1 & Serializable)x$53 -> {
                PartialMerge$ x$1 = PartialMerge$.MODULE$;
                AggregateFunction x$2 = x$53.copy$default$1();
                boolean x$3 = x$53.copy$default$3();
                Option x$4 = x$53.copy$default$4();
                ExprId x$5 = x$53.copy$default$5();
                return x$53.copy(x$2, (AggregateMode)x$1, x$3, x$4, x$5);
            });
            scala.collection.immutable.Seq aggAttributes = (scala.collection.immutable.Seq)aggregateExpressions.map((Function1 & Serializable)x$54 -> x$54.resultAttribute());
            scala.collection.immutable.Seq groupingAttributes = (scala.collection.immutable.Seq)groupingExpressions.map((Function1 & Serializable)x$55 -> x$55.toAttribute());
            scala.collection.immutable.Seq groupingWithoutSessionExpressions = (scala.collection.immutable.Seq)groupingExpressions.diff((Seq)new .colon.colon((Object)sessionExpression, (List)Nil$.MODULE$));
            scala.collection.immutable.Seq groupingWithoutSessionsAttributes = (scala.collection.immutable.Seq)groupingWithoutSessionExpressions.map((Function1 & Serializable)x$56 -> x$56.toAttribute());
            return new MergingSessionsExec((Option<scala.collection.immutable.Seq<Expression>>)new Some((Object)groupingWithoutSessionsAttributes), isStreaming, (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<NamedExpression>)groupingAttributes, sessionExpression, (scala.collection.immutable.Seq<AggregateExpression>)aggExpressions, (scala.collection.immutable.Seq<Attribute>)aggAttributes, groupingAttributes.length(), (scala.collection.immutable.Seq<NamedExpression>)((scala.collection.immutable.Seq)groupingAttributes.$plus$plus((IterableOnce)aggExpressions.flatMap((Function1 & Serializable)x$57 -> x$57.aggregateFunction().inputAggBufferAttributes()))), partialAggregate);
        }
        if (None$.MODULE$.equals(option)) {
            return partialAggregate;
        }
        throw new MatchError((Object)option);
    }

    private boolean mayAppendMergingSessionExec$default$4() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean forceApplySortAggregate(SQLConf conf) {
        if (!org.apache.spark.util.Utils$.MODULE$.isTesting()) return false;
        String string = conf.getConfString("spark.sql.test.forceApplySortAggregate", "false");
        String string2 = "true";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean forceApplyObjectHashAggregate(SQLConf conf) {
        if (!org.apache.spark.util.Utils$.MODULE$.isTesting()) return false;
        String string = conf.getConfString("spark.sql.test.forceApplyObjectHashAggregate", "false");
        String string2 = "true";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$planStreamingAggregationForSession$1(NamedExpression sessionExpression$1, NamedExpression p) {
        return ((Expression)p).semanticEquals((Expression)sessionExpression$1);
    }

    public static final /* synthetic */ boolean $anonfun$mayAppendUpdatingSessionExec$1(NamedExpression x$50) {
        return x$50.metadata().contains(SessionWindow$.MODULE$.marker());
    }

    public static final /* synthetic */ boolean $anonfun$mayAppendMergingSessionExec$1(NamedExpression x$52) {
        return x$52.metadata().contains(SessionWindow$.MODULE$.marker());
    }

    private AggUtils$() {
    }
}

