/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.classic;

import java.io.Serializable;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.UnresolvedDataSource;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.classic.ClassicConversions$;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.Dataset$;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.json.JsonUtils$;
import org.apache.spark.sql.execution.datasources.xml.XmlUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Evolving
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005g\u0001B\u0012%\u0005=B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0007u\u0001!\tAJ\u001e\t\u000by\u0002A\u0011A \t\u000bA\u0003A\u0011A)\t\u000be\u0003A\u0011\u0001.\t\u000b}\u0003A\u0011\u00011\t\u000b!\u0004A\u0011A5\t\u000bE\u0004A\u0011\u0002:\t\u000b!\u0004A\u0011A=\t\u000bm\u0004A\u0011\u0001?\t\r}\u0004A\u0011KA\u0001\u0011\u001d\ti\u0001\u0001C)\u0003\u001fAq!!\u0005\u0001\t#\ny\u0001\u0003\u0004Q\u0001\u0011\u0005\u00131\u0003\u0005\u00073\u0002!\t%!\u0007\t\re\u0003A\u0011IA\u0013\u0011\u0019I\u0006\u0001\"\u0011\u00022!1q\f\u0001C!\u0003{Aq!a\u0014\u0001\t\u0003\n\t\u0006C\u0004\u0002V\u0001!\t%a\u0016\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^!9\u0011\u0011\r\u0001\u0005B\u0005\r\u0004bBA4\u0001\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003[\u0002A\u0011IA8\u0011\u001d\t\u0019\b\u0001C!\u0003kB\u0001B\u0011\u0001A\u0002\u0013%\u0011q\u0010\u0005\n\u0003\u0003\u0003\u0001\u0019!C\u0005\u0003\u0007Cq!!#\u0001A\u0003&1\tC\u0005\u0002\f\u0002\u0001\r\u0011\"\u0003\u0002\u000e\"I\u0011\u0011\u0013\u0001A\u0002\u0013%\u00111\u0013\u0005\t\u0003/\u0003\u0001\u0015)\u0003\u0002\u0010\"I\u0011\u0011\u0014\u0001A\u0002\u0013%\u00111\u0014\u0005\n\u0003W\u0003\u0001\u0019!C\u0005\u0003[C\u0001\"!-\u0001A\u0003&\u0011Q\u0014\u0002\u0011\t\u0006$\u0018m\u0015;sK\u0006l'+Z1eKJT!!\n\u0014\u0002\u000f\rd\u0017m]:jG*\u0011q\u0005K\u0001\u0004gFd'BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\r\t\u0003cQj\u0011A\r\u0006\u0003g\u0019\n\u0011b\u001d;sK\u0006l\u0017N\\4\n\u0005\r\u0012\u0014\u0001D:qCJ\\7+Z:tS>t\u0007CA\u001c9\u001b\u0005!\u0013BA\u001d%\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019a\u0014N\\5u}Q\u0011A(\u0010\t\u0003o\u0001AQ!\u000e\u0002A\u0002Y\naAZ8s[\u0006$HC\u0001!B\u001b\u0005\u0001\u0001\"\u0002\"\u0004\u0001\u0004\u0019\u0015AB:pkJ\u001cW\r\u0005\u0002E\u001b:\u0011Qi\u0013\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011:\na\u0001\u0010:p_Rt$\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K\u0015A\u0002)sK\u0012,g-\u0003\u0002O\u001f\n11\u000b\u001e:j]\u001eT!\u0001T%\u0002\rM\u001c\u0007.Z7b)\t\u0001%\u000bC\u0003Q\t\u0001\u00071\u000b\u0005\u0002U/6\tQK\u0003\u0002WM\u0005)A/\u001f9fg&\u0011\u0001,\u0016\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017AB8qi&|g\u000eF\u0002A7vCQ\u0001X\u0003A\u0002\r\u000b1a[3z\u0011\u0015qV\u00011\u0001D\u0003\u00151\u0018\r\\;f\u0003\u001dy\u0007\u000f^5p]N$\"\u0001Q1\t\u000b}3\u0001\u0019\u00012\u0011\t\r47iQ\u0007\u0002I*\u0011Q-S\u0001\u000bG>dG.Z2uS>t\u0017BA4e\u0005\ri\u0015\r]\u0001\u0005Y>\fG\rF\u0001k!\tYgN\u0004\u00028Y&\u0011Q\u000eJ\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0007OA\u0005ECR\fgI]1nK*\u0011Q\u000eJ\u0001\rY>\fG-\u00138uKJt\u0017\r\u001c\u000b\u0003UNDQ\u0001\u001e\u0005A\u0002U\fA\u0001]1uQB\u0019ao^\"\u000e\u0003%K!\u0001_%\u0003\r=\u0003H/[8o)\tQ'\u0010C\u0003u\u0013\u0001\u00071)A\u0003uC\ndW\r\u0006\u0002k{\")aP\u0003a\u0001\u0007\u0006IA/\u00192mK:\u000bW.Z\u0001\u0018CN\u001cXM\u001d;O_N\u0003XmY5gS\u0016$7k\u00195f[\u0006$B!a\u0001\u0002\nA\u0019a/!\u0002\n\u0007\u0005\u001d\u0011J\u0001\u0003V]&$\bBBA\u0006\u0017\u0001\u00071)A\u0005pa\u0016\u0014\u0018\r^5p]\u0006\u0011b/\u00197jI\u0006$XMS:p]N\u001b\u0007.Z7b)\t\t\u0019!A\twC2LG-\u0019;f16d7k\u00195f[\u0006$2\u0001QA\u000b\u0011\u0019\t9B\u0004a\u0001\u0007\u0006a1o\u00195f[\u0006\u001cFO]5oOR)\u0001)a\u0007\u0002\u001e!)Al\u0004a\u0001\u0007\"1al\u0004a\u0001\u0003?\u00012A^A\u0011\u0013\r\t\u0019#\u0013\u0002\b\u0005>|G.Z1o)\u0015\u0001\u0015qEA\u0015\u0011\u0015a\u0006\u00031\u0001D\u0011\u0019q\u0006\u00031\u0001\u0002,A\u0019a/!\f\n\u0007\u0005=\u0012J\u0001\u0003M_:<G#\u0002!\u00024\u0005U\u0002\"\u0002/\u0012\u0001\u0004\u0019\u0005B\u00020\u0012\u0001\u0004\t9\u0004E\u0002w\u0003sI1!a\u000fJ\u0005\u0019!u.\u001e2mKR\u0019\u0001)a\u0010\t\r}\u0013\u0002\u0019AA!!\u0019\t\u0019%!\u0014D\u00076\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0003vi&d'BAA&\u0003\u0011Q\u0017M^1\n\u0007\u001d\f)%\u0001\u0003kg>tGc\u00016\u0002T!)Ao\u0005a\u0001\u0007\u0006\u00191m\u001d<\u0015\u0007)\fI\u0006C\u0003u)\u0001\u00071)A\u0002y[2$2A[A0\u0011\u0015!X\u00031\u0001D\u0003\ry'o\u0019\u000b\u0004U\u0006\u0015\u0004\"\u0002;\u0017\u0001\u0004\u0019\u0015a\u00029beF,X\r\u001e\u000b\u0004U\u0006-\u0004\"\u0002;\u0018\u0001\u0004\u0019\u0015\u0001\u0002;fqR$2A[A9\u0011\u0015!\b\u00041\u0001D\u0003!!X\r\u001f;GS2,G\u0003BA<\u0003{\u0002BaNA=\u0007&\u0019\u00111\u0010\u0013\u0003\u000f\u0011\u000bG/Y:fi\")A/\u0007a\u0001\u0007V\t1)\u0001\u0006t_V\u00148-Z0%KF$B!a\u0001\u0002\u0006\"A\u0011qQ\u000e\u0002\u0002\u0003\u00071)A\u0002yIE\nqa]8ve\u000e,\u0007%A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017-\u0006\u0002\u0002\u0010B\u0019ao^*\u0002/U\u001cXM]*qK\u000eLg-[3e'\u000eDW-\\1`I\u0015\fH\u0003BA\u0002\u0003+C\u0011\"a\"\u001f\u0003\u0003\u0005\r!a$\u0002)U\u001cXM]*qK\u000eLg-[3e'\u000eDW-\\1!\u00031)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8t+\t\ti\nE\u0003\u0002 \u0006\u001d6)\u0004\u0002\u0002\"*!\u0011qIAR\u0015\r\t)KJ\u0001\tG\u0006$\u0018\r\\=ti&!\u0011\u0011VAQ\u0005I\u0019\u0015m]3J]N,gn]5uSZ,W*\u00199\u0002!\u0015DHO]1PaRLwN\\:`I\u0015\fH\u0003BA\u0002\u0003_C\u0011\"a\"\"\u0003\u0003\u0005\r!!(\u0002\u001b\u0015DHO]1PaRLwN\\:!Q\r\u0001\u0011Q\u0017\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111\u0018\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002@\u0006e&\u0001C#w_24\u0018N\\4")
public final class DataStreamReader
extends org.apache.spark.sql.streaming.DataStreamReader {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private CaseInsensitiveMap<String> extraOptions;

    public DataStreamReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamReader schema(StructType schema) {
        block0: {
            if (schema == null) break block0;
            StructType replaced = (StructType)CharVarcharUtils$.MODULE$.failIfHasCharVarchar((DataType)schema);
            this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)replaced));
        }
        return this;
    }

    public DataStreamReader option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataStreamReader options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public Dataset<Row> load() {
        return this.loadInternal((Option<String>)None$.MODULE$);
    }

    private Dataset<Row> loadInternal(Option<String> path) {
        UnresolvedDataSource unresolved = new UnresolvedDataSource(this.source(), this.userSpecifiedSchema(), this.extraOptions(), true, (Seq<String>)Option$.MODULE$.option2Iterable(path).toSeq());
        return Dataset$.MODULE$.ofRows(this.sparkSession, unresolved);
    }

    public Dataset<Row> load(String path) {
        if (!this.sparkSession.sessionState().conf().legacyPathOptionBehavior() && this.extraOptions().contains("path")) {
            throw QueryCompilationErrors$.MODULE$.setPathOptionAndCallWithPathParameterError("load");
        }
        return this.loadInternal((Option<String>)new Some((Object)path));
    }

    public Dataset<Row> table(String tableName) {
        Predef$.MODULE$.require(tableName != null, (Function0 & Serializable)() -> "The table name can't be null");
        Seq identifier = this.sparkSession.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new UnresolvedRelation(identifier, new CaseInsensitiveStringMap(CollectionConverters$.MODULE$.MapHasAsJava((Map)this.extraOptions().toMap()).asJava()), true));
    }

    public void assertNoSpecifiedSchema(String operation) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.userSpecifiedSchemaUnsupportedError(operation);
        }
    }

    public void validateJsonSchema() {
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            JsonUtils$.MODULE$.checkJsonSchema(schema);
            return BoxedUnit.UNIT;
        });
    }

    public void validateXmlSchema() {
        this.userSpecifiedSchema().foreach((Function1 & Serializable)schema -> {
            XmlUtils$.MODULE$.checkXmlSchema(schema);
            return BoxedUnit.UNIT;
        });
    }

    public DataStreamReader schema(String schemaString) {
        return (DataStreamReader)super.schema(schemaString);
    }

    public DataStreamReader option(String key, boolean value) {
        return (DataStreamReader)super.option(key, value);
    }

    public DataStreamReader option(String key, long value) {
        return (DataStreamReader)super.option(key, value);
    }

    public DataStreamReader option(String key, double value) {
        return (DataStreamReader)super.option(key, value);
    }

    public DataStreamReader options(java.util.Map<String, String> options) {
        return (DataStreamReader)super.options(options);
    }

    public Dataset<Row> json(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.json(path));
    }

    public Dataset<Row> csv(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.csv(path));
    }

    public Dataset<Row> xml(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.xml(path));
    }

    public Dataset<Row> orc(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.orc(path));
    }

    public Dataset<Row> parquet(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.parquet(path));
    }

    public Dataset<Row> text(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.text(path));
    }

    public Dataset<String> textFile(String path) {
        return ClassicConversions$.MODULE$.castToImpl(super.textFile(path));
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    public DataStreamReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
    }
}

