/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.context;

import java.lang.reflect.Array;
import java.util.Dictionary;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.MapUtil;
import org.apache.sling.testing.mock.osgi.MockEventAdmin;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@ConsumerType
public class OsgiContextImpl {
    protected ComponentContext componentContext;

    protected void setUp() {
        this.registerDefaultServices();
    }

    protected void tearDown() {
        if (this.componentContext != null) {
            MockOsgi.shutdown(this.componentContext.getBundleContext());
        }
        this.componentContext = null;
    }

    private void registerDefaultServices() {
        this.registerInjectActivateService(new MockEventAdmin());
    }

    @NotNull
    public final ComponentContext componentContext() {
        if (this.componentContext == null) {
            this.componentContext = MockOsgi.newComponentContext();
        }
        return this.componentContext;
    }

    @NotNull
    public final BundleContext bundleContext() {
        return this.componentContext().getBundleContext();
    }

    @NotNull
    public final <T> T registerService(@NotNull T service) {
        return this.registerService(null, service, null);
    }

    @NotNull
    public final <T> T registerService(@Nullable Class<T> serviceClass, @NotNull T service) {
        return this.registerService(serviceClass, service, null);
    }

    @NotNull
    public final <T> T registerService(@Nullable Class<T> serviceClass, @NotNull T service, @Nullable Map<String, Object> properties) {
        Dictionary<String, Object> serviceProperties = MapUtil.toDictionary(properties);
        this.bundleContext().registerService(serviceClass != null ? serviceClass.getName() : null, service, serviceProperties);
        return service;
    }

    @NotNull
    public final <T> T registerService(@Nullable Class<T> serviceClass, @NotNull T service, Object ... properties) {
        return this.registerService(serviceClass, service, MapUtil.toMap(properties));
    }

    @NotNull
    public final <T> T registerInjectActivateService(@NotNull T component) {
        return this.registerInjectActivateService(component, (Map<String, Object>)null);
    }

    @NotNull
    public final <T> T registerInjectActivateService(@NotNull T component, @Nullable Map<String, Object> properties) {
        MockOsgi.registerInjectActivateService(component, this.bundleContext(), properties);
        return component;
    }

    @NotNull
    public final <T> T registerInjectActivateService(@NotNull T component, Object ... properties) {
        return this.registerInjectActivateService(component, MapUtil.toMap(properties));
    }

    @NotNull
    public final <T> T registerInjectActivateService(@NotNull Class<T> componentClass) {
        return this.registerInjectActivateService(componentClass, (Map<String, Object>)null);
    }

    @NotNull
    public final <T> T registerInjectActivateService(@NotNull Class<T> componentClass, @Nullable Map<String, Object> properties) {
        return MockOsgi.registerInjectActivateService(componentClass, this.bundleContext(), properties);
    }

    @NotNull
    public final <T> T registerInjectActivateService(@NotNull Class<T> componentClass, Object ... properties) {
        return this.registerInjectActivateService(componentClass, MapUtil.toMap(properties));
    }

    @Nullable
    public final <ServiceType> ServiceType getService(@NotNull Class<ServiceType> serviceType) {
        ServiceReference serviceReference = this.bundleContext().getServiceReference(serviceType.getName());
        if (serviceReference != null) {
            return (ServiceType)this.bundleContext().getService(serviceReference);
        }
        return null;
    }

    @NotNull
    public final <ServiceType> @NotNull ServiceType @NotNull [] getServices(@NotNull Class<ServiceType> serviceType, @Nullable String filter) {
        try {
            ServiceReference[] serviceReferences = this.bundleContext().getServiceReferences(serviceType.getName(), filter);
            if (serviceReferences != null) {
                Object[] services = (Object[])Array.newInstance(serviceType, serviceReferences.length);
                for (int i = 0; i < serviceReferences.length; ++i) {
                    services[i] = this.bundleContext().getService(serviceReferences[i]);
                }
                return services;
            }
            return (Object[])Array.newInstance(serviceType, 0);
        }
        catch (InvalidSyntaxException ex) {
            throw new RuntimeException("Invalid filter syntax: " + filter, ex);
        }
    }
}

