/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt;

import java.io.File;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.Mounter;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.VaultFileSystem;
import org.apache.jackrabbit.vault.fs.api.VaultFsConfig;
import org.apache.jackrabbit.vault.fs.config.AbstractVaultFsConfig;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.sling.ide.impl.vlt.VaultFsLocator;
import org.osgi.service.component.annotations.Component;

@Component(service={VaultFsLocator.class})
public class VaultFsLocatorImpl
implements VaultFsLocator {
    @Override
    public VaultFileSystem getFileSystem(RepositoryAddress repositoryAddress, File contentSyncRoot, Session session) throws RepositoryException, IOException, ConfigurationException {
        File configFile;
        File vaultDir;
        File metaInfDir;
        VaultFsConfig config = null;
        DefaultWorkspaceFilter filter = null;
        File filterFile = this.findFilterFile(contentSyncRoot);
        if (filterFile != null) {
            filter = new DefaultWorkspaceFilter();
            filter.load(filterFile);
        }
        if ((metaInfDir = new File(contentSyncRoot.getParent(), "META-INF")).isDirectory() && (vaultDir = new File(metaInfDir, "vault")).isDirectory() && (configFile = new File(vaultDir, "config.xml")).exists()) {
            config = AbstractVaultFsConfig.load(configFile);
        }
        return Mounter.mount(config, filter, repositoryAddress, "/", session);
    }

    @Override
    public File findFilterFile(File contentSyncRoot) {
        File vaultDir;
        File metaInfDir = new File(contentSyncRoot.getParent(), "META-INF");
        if (metaInfDir.isDirectory() && (vaultDir = new File(metaInfDir, "vault")).isDirectory()) {
            File filterFile = new File(vaultDir, "filter-vlt.xml");
            if (filterFile.isFile()) {
                return filterFile;
            }
            filterFile = new File(vaultDir, "filter.xml");
            if (filterFile.isFile()) {
                return filterFile;
            }
        }
        return null;
    }
}

