/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.request.builder.impl;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;

public class FastMessageFormat {
    private NumberFormat numberFormat;
    private DateFormat dateFormat;

    private NumberFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = NumberFormat.getNumberInstance();
        }
        return this.numberFormat;
    }

    private DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getDateTimeInstance(3, 3);
        }
        return this.dateFormat;
    }

    public String format(String pattern, Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return pattern;
        }
        if (pattern.indexOf(39) != -1) {
            return MessageFormat.format(pattern, arguments);
        }
        StringBuilder message = new StringBuilder();
        int previousEnd = 0;
        for (int i = 0; i < arguments.length; ++i) {
            String placeholder = "{" + String.valueOf(i);
            int placeholderIndex = pattern.indexOf(placeholder);
            if (placeholderIndex < previousEnd || pattern.charAt(placeholderIndex + placeholder.length()) != '}') {
                return MessageFormat.format(pattern, arguments);
            }
            Object argument = arguments[i];
            if (argument instanceof Number) {
                argument = this.getNumberFormat().format(argument);
            } else if (argument instanceof Date) {
                argument = this.getDateFormat().format(argument);
            }
            message.append(pattern.substring(previousEnd, placeholderIndex));
            message.append(argument);
            previousEnd = placeholderIndex + placeholder.length() + 1;
        }
        message.append(pattern.substring(previousEnd, pattern.length()));
        return message.toString();
    }
}

