/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.servicecomb.foundation.vertx.http.BodyBufferSupport;
import org.apache.servicecomb.foundation.vertx.http.BodyBufferSupportImpl;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.stream.BufferInputStream;

public class StandardHttpServletRequestEx
extends HttpServletRequestWrapper
implements HttpServletRequestEx {
    private final BodyBufferSupport bodyBuffer = new BodyBufferSupportImpl();
    private boolean cacheRequest;
    private ServletInputStream inputStream;
    private Map<String, String[]> parameterMap;

    public StandardHttpServletRequestEx(HttpServletRequest request) {
        super(request);
    }

    public void setCacheRequest(boolean cacheRequest) {
        this.cacheRequest = cacheRequest;
    }

    @VisibleForTesting
    public boolean isCacheRequest() {
        return this.cacheRequest;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            if (this.cacheRequest) {
                byte[] inputBytes = IOUtils.toByteArray((InputStream)this.getRequest().getInputStream());
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])inputBytes);
                this.inputStream = new BufferInputStream(byteBuf);
                this.setBodyBuffer(Buffer.buffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuf)byteBuf)));
            } else {
                this.inputStream = this.getRequest().getInputStream();
            }
        }
        return this.inputStream;
    }

    @Override
    public void setBodyBuffer(Buffer bodyBuffer) {
        this.bodyBuffer.setBodyBuffer(bodyBuffer);
    }

    @Override
    public Buffer getBodyBuffer() {
        return this.bodyBuffer.getBodyBuffer();
    }

    @Override
    public byte[] getBodyBytes() {
        return this.bodyBuffer.getBodyBytes();
    }

    @Override
    public int getBodyBytesLength() {
        return this.bodyBuffer.getBodyBytesLength();
    }

    private Map<String, String[]> parseParameterMap() {
        if (this.getMethod().equalsIgnoreCase("POST") || !StringUtils.startsWithIgnoreCase((String)this.getContentType(), (String)"application/x-www-form-urlencoded")) {
            return super.getParameterMap();
        }
        Map<String, List<String>> listMap = this.parseUrlEncodedBody();
        this.mergeParameterMaptoListMap(listMap);
        return this.convertListMapToArrayMap(listMap);
    }

    private Map<String, String[]> convertListMapToArrayMap(Map<String, List<String>> listMap) {
        HashMap<String, String[]> arrayMap = new HashMap<String, String[]>();
        for (Map.Entry<String, List<String>> entry : listMap.entrySet()) {
            arrayMap.put(entry.getKey(), entry.getValue().toArray(new String[0]));
        }
        return arrayMap;
    }

    private void mergeParameterMaptoListMap(Map<String, List<String>> listMap) {
        for (Map.Entry entry : super.getParameterMap().entrySet()) {
            List values = listMap.computeIfAbsent((String)entry.getKey(), (Function<String, List<String>>)((Function<String, List>)k -> new ArrayList()));
            values.addAll(0, Arrays.asList((Object[])entry.getValue()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<String>> parseUrlEncodedBody() {
        try (ServletInputStream inputStream = this.getInputStream();){
            HashMap<String, List> listMap = new HashMap<String, List>();
            String body = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            List pairs = URLEncodedUtils.parse((String)body, this.getCharacterEncoding() == null ? null : Charset.forName(this.getCharacterEncoding()));
            for (NameValuePair pair : pairs) {
                List values = listMap.computeIfAbsent(pair.getName(), k -> new ArrayList());
                values.add(pair.getValue());
            }
            HashMap<String, List> hashMap = listMap;
            return hashMap;
        }
        catch (IOException e) {
            throw new IllegalStateException("", e);
        }
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public String getParameter(String name) {
        String[] values = this.getParameterMap().get(name);
        return values == null ? null : values[0];
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap == null) {
            this.parameterMap = this.parseParameterMap();
        }
        return this.parameterMap;
    }

    @Override
    public void setParameter(String name, String value) {
        this.getParameterMap().put(name, new String[]{value});
    }
}

