/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import apache.rocketmq.v2.AckMessageRequest;
import apache.rocketmq.v2.AckMessageResponse;
import apache.rocketmq.v2.ChangeInvisibleDurationRequest;
import apache.rocketmq.v2.ChangeInvisibleDurationResponse;
import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueRequest;
import apache.rocketmq.v2.ForwardMessageToDeadLetterQueueResponse;
import apache.rocketmq.v2.ReceiveMessageRequest;
import apache.rocketmq.v2.Status;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.FilterExpression;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.java.exception.BadRequestException;
import org.apache.rocketmq.client.java.exception.TooManyRequestsException;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.hook.MessageInterceptorContextImpl;
import org.apache.rocketmq.client.java.impl.consumer.ConsumeService;
import org.apache.rocketmq.client.java.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.java.impl.consumer.PushConsumerImpl;
import org.apache.rocketmq.client.java.impl.consumer.ReceiveMessageResult;
import org.apache.rocketmq.client.java.message.GeneralMessage;
import org.apache.rocketmq.client.java.message.GeneralMessageImpl;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.retry.RetryPolicy;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.rpc.RpcFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProcessQueueImpl
implements ProcessQueue {
    static final Duration FORWARD_FIFO_MESSAGE_TO_DLQ_FAILURE_BACKOFF_DELAY = Duration.ofSeconds(1L);
    static final Duration ACK_MESSAGE_FAILURE_BACKOFF_DELAY = Duration.ofSeconds(1L);
    static final Duration CHANGE_INVISIBLE_DURATION_FAILURE_BACKOFF_DELAY = Duration.ofSeconds(1L);
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessQueueImpl.class);
    private static final Duration RECEIVING_FLOW_CONTROL_BACKOFF_DELAY = Duration.ofMillis(20L);
    private static final Duration RECEIVING_FAILURE_BACKOFF_DELAY = Duration.ofSeconds(1L);
    private static final Duration RECEIVING_BACKOFF_DELAY_WHEN_CACHE_IS_FULL = Duration.ofSeconds(1L);
    private final PushConsumerImpl consumer;
    private volatile boolean dropped;
    private final MessageQueueImpl mq;
    private final FilterExpression filterExpression;
    @GuardedBy(value="cachedMessageLock")
    private final List<MessageViewImpl> cachedMessages;
    private final ReadWriteLock cachedMessageLock;
    private final AtomicLong cachedMessagesBytes;
    private final AtomicLong receptionTimes;
    private final AtomicLong receivedMessagesQuantity;
    private volatile long activityNanoTime = System.nanoTime();
    private volatile long cacheFullNanoTime = Long.MIN_VALUE;

    public ProcessQueueImpl(PushConsumerImpl consumer, MessageQueueImpl mq, FilterExpression filterExpression) {
        this.consumer = consumer;
        this.dropped = false;
        this.mq = mq;
        this.filterExpression = filterExpression;
        this.cachedMessages = new ArrayList<MessageViewImpl>();
        this.cachedMessageLock = new ReentrantReadWriteLock();
        this.cachedMessagesBytes = new AtomicLong();
        this.receptionTimes = new AtomicLong(0L);
        this.receivedMessagesQuantity = new AtomicLong(0L);
    }

    @Override
    public MessageQueueImpl getMessageQueue() {
        return this.mq;
    }

    @Override
    public void drop() {
        this.dropped = true;
    }

    @Override
    public boolean expired() {
        Duration longPollingTimeout = this.consumer.getPushConsumerSettings().getLongPollingTimeout();
        Duration requestTimeout = this.consumer.getClientConfiguration().getRequestTimeout();
        Duration maxIdleDuration = longPollingTimeout.plus(requestTimeout).multipliedBy(3L);
        Duration idleDuration = Duration.ofNanos(System.nanoTime() - this.activityNanoTime);
        if (idleDuration.compareTo(maxIdleDuration) < 0) {
            return false;
        }
        Duration afterCacheFullDuration = Duration.ofNanos(System.nanoTime() - this.cacheFullNanoTime);
        if (afterCacheFullDuration.compareTo(maxIdleDuration) < 0) {
            return false;
        }
        LOGGER.warn("Process queue is idle, idleDuration={}, maxIdleDuration={}, afterCacheFullDuration={}, mq={}, clientId={}", new Object[]{idleDuration, maxIdleDuration, afterCacheFullDuration, this.mq, this.consumer.getClientId()});
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheMessages(List<MessageViewImpl> messageList) {
        this.cachedMessageLock.writeLock().lock();
        try {
            for (MessageViewImpl messageView : messageList) {
                this.cachedMessages.add(messageView);
                this.cachedMessagesBytes.addAndGet(messageView.getBody().remaining());
            }
        }
        finally {
            this.cachedMessageLock.writeLock().unlock();
        }
    }

    private int getReceptionBatchSize() {
        int bufferSize = this.consumer.cacheMessageCountThresholdPerQueue() - this.cachedMessagesCount();
        bufferSize = Math.max(bufferSize, 1);
        return Math.min(bufferSize, this.consumer.getPushConsumerSettings().getReceiveBatchSize());
    }

    @Override
    public void fetchMessageImmediately() {
        this.receiveMessageImmediately();
    }

    public void onReceiveMessageException(Throwable t) {
        Duration delay = t instanceof TooManyRequestsException ? RECEIVING_FLOW_CONTROL_BACKOFF_DELAY : RECEIVING_FAILURE_BACKOFF_DELAY;
        this.receiveMessageLater(delay);
    }

    private void receiveMessageLater(Duration delay) {
        ClientId clientId = this.consumer.getClientId();
        ScheduledExecutorService scheduler = this.consumer.getScheduler();
        try {
            LOGGER.info("Try to receive message later, mq={}, delay={}, clientId={}", new Object[]{this.mq, delay, clientId});
            scheduler.schedule(this::receiveMessage, delay.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (Throwable t) {
            if (scheduler.isShutdown()) {
                return;
            }
            LOGGER.error("[Bug] Failed to schedule message receiving request, mq={}, clientId={}", new Object[]{this.mq, clientId, t});
            this.onReceiveMessageException(t);
        }
    }

    public void receiveMessage() {
        ClientId clientId = this.consumer.getClientId();
        if (this.dropped) {
            LOGGER.info("Process queue has been dropped, no longer receive message, mq={}, clientId={}", (Object)this.mq, (Object)clientId);
            return;
        }
        if (this.isCacheFull()) {
            LOGGER.warn("Process queue cache is full, would receive message later, mq={}, clientId={}", (Object)this.mq, (Object)clientId);
            this.receiveMessageLater(RECEIVING_BACKOFF_DELAY_WHEN_CACHE_IS_FULL);
            return;
        }
        this.receiveMessageImmediately();
    }

    private void receiveMessageImmediately() {
        final ClientId clientId = this.consumer.getClientId();
        if (!this.consumer.isRunning()) {
            LOGGER.info("Stop to receive message because consumer is not running, mq={}, clientId={}", (Object)this.mq, (Object)clientId);
            return;
        }
        try {
            final Endpoints endpoints = this.mq.getBroker().getEndpoints();
            int batchSize = this.getReceptionBatchSize();
            ReceiveMessageRequest request = this.consumer.wrapReceiveMessageRequest(batchSize, this.mq, this.filterExpression);
            this.activityNanoTime = System.nanoTime();
            final MessageInterceptorContextImpl context = new MessageInterceptorContextImpl(MessageHookPoints.RECEIVE);
            this.consumer.doBefore(context, Collections.emptyList());
            ListenableFuture<ReceiveMessageResult> future = this.consumer.receiveMessage(request, this.mq, this.consumer.getPushConsumerSettings().getLongPollingTimeout());
            Futures.addCallback(future, (FutureCallback)new FutureCallback<ReceiveMessageResult>(){

                public void onSuccess(ReceiveMessageResult result) {
                    List<GeneralMessage> generalMessages = result.getMessageViewImpls().stream().map(GeneralMessageImpl::new).collect(Collectors.toList());
                    MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, MessageHookPointsStatus.OK);
                    ProcessQueueImpl.this.consumer.doAfter(context0, generalMessages);
                    try {
                        ProcessQueueImpl.this.onReceiveMessageResult(result);
                    }
                    catch (Throwable t) {
                        LOGGER.error("[Bug] Exception raised while handling receive result, mq={}, endpoints={}, clientId={}", new Object[]{ProcessQueueImpl.this.mq, endpoints, clientId, t});
                        ProcessQueueImpl.this.onReceiveMessageException(t);
                    }
                }

                public void onFailure(Throwable t) {
                    MessageInterceptorContextImpl context0 = new MessageInterceptorContextImpl(context, MessageHookPointsStatus.ERROR);
                    ProcessQueueImpl.this.consumer.doAfter(context0, Collections.emptyList());
                    LOGGER.error("Exception raised during message reception, mq={}, endpoints={}, clientId={}", new Object[]{ProcessQueueImpl.this.mq, endpoints, clientId, t});
                    ProcessQueueImpl.this.onReceiveMessageException(t);
                }
            }, (Executor)MoreExecutors.directExecutor());
            this.receptionTimes.getAndIncrement();
            this.consumer.getReceptionTimes().getAndIncrement();
        }
        catch (Throwable t) {
            LOGGER.error("Exception raised during message reception, mq={}, clientId={}", new Object[]{this.mq, clientId, t});
            this.onReceiveMessageException(t);
        }
    }

    public boolean isCacheFull() {
        long actualCachedMessagesBytes;
        int cacheMessageCountThresholdPerQueue = this.consumer.cacheMessageCountThresholdPerQueue();
        long actualMessagesQuantity = this.cachedMessagesCount();
        ClientId clientId = this.consumer.getClientId();
        if ((long)cacheMessageCountThresholdPerQueue <= actualMessagesQuantity) {
            LOGGER.warn("Process queue total cached messages quantity exceeds the threshold, threshold={}, actual={}, mq={}, clientId={}", new Object[]{cacheMessageCountThresholdPerQueue, actualMessagesQuantity, this.mq, clientId});
            this.cacheFullNanoTime = System.nanoTime();
            return true;
        }
        int cacheMessageBytesThresholdPerQueue = this.consumer.cacheMessageBytesThresholdPerQueue();
        if ((long)cacheMessageBytesThresholdPerQueue <= (actualCachedMessagesBytes = this.cachedMessageBytes())) {
            LOGGER.warn("Process queue total cached messages memory exceeds the threshold, threshold={} bytes, actual={} bytes, mq={}, clientId={}", new Object[]{cacheMessageBytesThresholdPerQueue, actualCachedMessagesBytes, this.mq, clientId});
            this.cacheFullNanoTime = System.nanoTime();
            return true;
        }
        return false;
    }

    @Override
    public void discardMessage(MessageViewImpl messageView) {
        LOGGER.info("Discard message, mq={}, messageId={}, clientId={}", new Object[]{this.mq, messageView.getMessageId(), this.consumer.getClientId()});
        ListenableFuture<Void> future = this.nackMessage(messageView);
        future.addListener(() -> this.evictCache(messageView), MoreExecutors.directExecutor());
    }

    @Override
    public void discardFifoMessage(MessageViewImpl messageView) {
        LOGGER.info("Discard fifo message, mq={}, messageId={}, clientId={}", new Object[]{this.mq, messageView.getMessageId(), this.consumer.getClientId()});
        ListenableFuture<Void> future = this.forwardToDeadLetterQueue(messageView);
        future.addListener(() -> this.evictCache(messageView), MoreExecutors.directExecutor());
    }

    public int cachedMessagesCount() {
        this.cachedMessageLock.readLock().lock();
        try {
            int n = this.cachedMessages.size();
            return n;
        }
        finally {
            this.cachedMessageLock.readLock().unlock();
        }
    }

    public long cachedMessageBytes() {
        return this.cachedMessagesBytes.get();
    }

    private void onReceiveMessageResult(ReceiveMessageResult result) {
        List<MessageViewImpl> messages = result.getMessageViewImpls();
        if (!messages.isEmpty()) {
            this.cacheMessages(messages);
            this.receivedMessagesQuantity.getAndAdd(messages.size());
            this.consumer.getReceivedMessagesQuantity().getAndAdd(messages.size());
            this.consumer.getConsumeService().consume(this, messages);
        }
        this.receiveMessage();
    }

    private void evictCache(MessageViewImpl messageView) {
        this.cachedMessageLock.writeLock().lock();
        try {
            if (this.cachedMessages.remove(messageView)) {
                this.cachedMessagesBytes.addAndGet(-messageView.getBody().remaining());
            }
        }
        finally {
            this.cachedMessageLock.writeLock().unlock();
        }
    }

    private void statsConsumptionResult(ConsumeResult consumeResult) {
        if (ConsumeResult.SUCCESS.equals((Object)consumeResult)) {
            this.consumer.consumptionOkQuantity.incrementAndGet();
            return;
        }
        this.consumer.consumptionErrorQuantity.incrementAndGet();
    }

    @Override
    public void eraseMessage(MessageViewImpl messageView, ConsumeResult consumeResult) {
        this.statsConsumptionResult(consumeResult);
        ListenableFuture<Void> future = ConsumeResult.SUCCESS.equals((Object)consumeResult) ? this.ackMessage(messageView) : this.nackMessage(messageView);
        future.addListener(() -> this.evictCache(messageView), MoreExecutors.directExecutor());
    }

    private ListenableFuture<Void> nackMessage(MessageViewImpl messageView) {
        int deliveryAttempt = messageView.getDeliveryAttempt();
        Duration duration = this.consumer.getRetryPolicy().getNextAttemptDelay(deliveryAttempt);
        SettableFuture future0 = SettableFuture.create();
        this.changeInvisibleDuration(messageView, duration, 1, (SettableFuture<Void>)future0);
        return future0;
    }

    private void changeInvisibleDuration(final MessageViewImpl messageView, final Duration duration, final int attempt, final SettableFuture<Void> future0) {
        final ClientId clientId = this.consumer.getClientId();
        final String consumerGroup = this.consumer.getConsumerGroup();
        final MessageId messageId = messageView.getMessageId();
        final Endpoints endpoints = messageView.getEndpoints();
        final RpcFuture<ChangeInvisibleDurationRequest, ChangeInvisibleDurationResponse> future = this.consumer.changeInvisibleDuration(messageView, duration);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<ChangeInvisibleDurationResponse>(){

            public void onSuccess(ChangeInvisibleDurationResponse response) {
                String requestId = future.getContext().getRequestId();
                Status status = response.getStatus();
                Code code = status.getCode();
                if (Code.INVALID_RECEIPT_HANDLE.equals((Object)code)) {
                    LOGGER.error("Failed to change invisible duration due to the invalid receipt handle, forgive to retry, clientId={}, consumerGroup={}, messageId={}, attempt={}, mq={}, endpoints={}, requestId={}, status message=[{}]", new Object[]{clientId, consumerGroup, messageId, attempt, ProcessQueueImpl.this.mq, endpoints, requestId, status.getMessage()});
                    future0.setException((Throwable)((Object)new BadRequestException(code.getNumber(), requestId, status.getMessage())));
                    return;
                }
                if (!Code.OK.equals((Object)code)) {
                    LOGGER.error("Failed to change invisible duration, would retry later, clientId={}, consumerGroup={}, messageId={}, attempt={}, mq={}, endpoints={}, requestId={}, status message=[{}]", new Object[]{clientId, consumerGroup, messageId, attempt, ProcessQueueImpl.this.mq, endpoints, requestId, status.getMessage()});
                    ProcessQueueImpl.this.changeInvisibleDurationLater(messageView, duration, 1 + attempt, (SettableFuture<Void>)future0);
                    return;
                }
                future0.setFuture(Futures.immediateVoidFuture());
                if (1 < attempt) {
                    LOGGER.info("Finally, change invisible duration successfully, clientId={}, consumerGroup={} messageId={}, attempt={}, mq={}, endpoints={}, requestId={}", new Object[]{clientId, consumerGroup, messageId, attempt, ProcessQueueImpl.this.mq, endpoints, requestId});
                    return;
                }
                LOGGER.debug("Change invisible duration successfully, clientId={}, consumerGroup={}, messageId={}, mq={}, endpoints={}, requestId={}", new Object[]{clientId, consumerGroup, messageId, ProcessQueueImpl.this.mq, endpoints, requestId});
            }

            public void onFailure(Throwable t) {
                LOGGER.error("Exception raised while changing invisible duration, would retry later, clientId={}, consumerGroup={}, messageId={}, mq={}, endpoints={}", new Object[]{clientId, consumerGroup, messageId, ProcessQueueImpl.this.mq, endpoints, t});
                ProcessQueueImpl.this.changeInvisibleDurationLater(messageView, duration, 1 + attempt, (SettableFuture<Void>)future0);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void changeInvisibleDurationLater(MessageViewImpl messageView, Duration duration, int attempt, SettableFuture<Void> future) {
        MessageId messageId = messageView.getMessageId();
        ScheduledExecutorService scheduler = this.consumer.getScheduler();
        try {
            scheduler.schedule(() -> this.changeInvisibleDuration(messageView, duration, attempt, future), CHANGE_INVISIBLE_DURATION_FAILURE_BACKOFF_DELAY.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (Throwable t) {
            if (scheduler.isShutdown()) {
                return;
            }
            LOGGER.error("[Bug] Failed to schedule message change invisible duration request, mq={}, messageId={}, clientId={}", new Object[]{this.mq, messageId, this.consumer.getClientId()});
            this.changeInvisibleDurationLater(messageView, duration, 1 + attempt, future);
        }
    }

    @Override
    public ListenableFuture<Void> eraseFifoMessage(MessageViewImpl messageView, ConsumeResult consumeResult) {
        this.statsConsumptionResult(consumeResult);
        RetryPolicy retryPolicy = this.consumer.getRetryPolicy();
        int maxAttempts = retryPolicy.getMaxAttempts();
        int attempt = messageView.getDeliveryAttempt();
        MessageId messageId = messageView.getMessageId();
        ConsumeService service = this.consumer.getConsumeService();
        ClientId clientId = this.consumer.getClientId();
        if (ConsumeResult.FAILURE.equals((Object)consumeResult) && attempt < maxAttempts) {
            Duration nextAttemptDelay = retryPolicy.getNextAttemptDelay(attempt);
            attempt = messageView.incrementAndGetDeliveryAttempt();
            LOGGER.debug("Prepare to redeliver the fifo message because of the consumption failure, maxAttempt={}, attempt={}, mq={}, messageId={}, nextAttemptDelay={}, clientId={}", new Object[]{maxAttempts, attempt, this.mq, messageId, nextAttemptDelay, clientId});
            ListenableFuture<ConsumeResult> future = service.consume(messageView, nextAttemptDelay);
            return Futures.transformAsync(future, result -> this.eraseFifoMessage(messageView, (ConsumeResult)result), (Executor)MoreExecutors.directExecutor());
        }
        boolean ok = ConsumeResult.SUCCESS.equals((Object)consumeResult);
        if (!ok) {
            LOGGER.info("Failed to consume fifo message finally, run out of attempt times, maxAttempts={}, attempt={}, mq={}, messageId={}, clientId={}", new Object[]{maxAttempts, attempt, this.mq, messageId, clientId});
        }
        ListenableFuture<Void> future = ok ? this.ackMessage(messageView) : this.forwardToDeadLetterQueue(messageView);
        future.addListener(() -> this.evictCache(messageView), (Executor)this.consumer.getConsumptionExecutor());
        return future;
    }

    private ListenableFuture<Void> forwardToDeadLetterQueue(MessageViewImpl messageView) {
        SettableFuture future = SettableFuture.create();
        this.forwardToDeadLetterQueue(messageView, 1, (SettableFuture<Void>)future);
        return future;
    }

    private void forwardToDeadLetterQueue(final MessageViewImpl messageView, final int attempt, final SettableFuture<Void> future0) {
        final RpcFuture<ForwardMessageToDeadLetterQueueRequest, ForwardMessageToDeadLetterQueueResponse> future = this.consumer.forwardMessageToDeadLetterQueue(messageView);
        final ClientId clientId = this.consumer.getClientId();
        final String consumerGroup = this.consumer.getConsumerGroup();
        final MessageId messageId = messageView.getMessageId();
        final Endpoints endpoints = messageView.getEndpoints();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<ForwardMessageToDeadLetterQueueResponse>(){

            public void onSuccess(ForwardMessageToDeadLetterQueueResponse response) {
                String requestId = future.getContext().getRequestId();
                Status status = response.getStatus();
                Code code = status.getCode();
                if (!Code.OK.equals((Object)code)) {
                    LOGGER.error("Failed to forward message to dead letter queue, would attempt to re-forward later, clientId={}, consumerGroup={}, messageId={}, attempt={}, mq={}, endpoints={}, requestId={}, code={}, status message={}", new Object[]{clientId, consumerGroup, messageId, attempt, ProcessQueueImpl.this.mq, endpoints, requestId, code, status.getMessage()});
                    ProcessQueueImpl.this.forwardToDeadLetterQueueLater(messageView, 1 + attempt, (SettableFuture<Void>)future0);
                    return;
                }
                future0.setFuture(Futures.immediateVoidFuture());
                if (1 < attempt) {
                    LOGGER.info("Re-forward message to dead letter queue successfully, clientId={}, consumerGroup={}, attempt={}, messageId={}, mq={}, endpoints={}, requestId={}", new Object[]{clientId, consumerGroup, attempt, messageId, ProcessQueueImpl.this.mq, endpoints, requestId});
                    return;
                }
                LOGGER.info("Forward message to dead letter queue successfully, clientId={}, consumerGroup={}, messageId={}, mq={}, endpoints={}, requestId={}", new Object[]{clientId, consumerGroup, messageId, ProcessQueueImpl.this.mq, endpoints, requestId});
            }

            public void onFailure(Throwable t) {
                LOGGER.error("Exception raised while forward message to DLQ, would attempt to re-forward later, clientId={}, consumerGroup={}, attempt={}, messageId={}, mq={}", new Object[]{clientId, consumerGroup, attempt, messageId, ProcessQueueImpl.this.mq, t});
                ProcessQueueImpl.this.forwardToDeadLetterQueueLater(messageView, 1 + attempt, (SettableFuture<Void>)future0);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void forwardToDeadLetterQueueLater(MessageViewImpl messageView, int attempt, SettableFuture<Void> future0) {
        ScheduledExecutorService scheduler = this.consumer.getScheduler();
        try {
            scheduler.schedule(() -> this.forwardToDeadLetterQueue(messageView, attempt, future0), FORWARD_FIFO_MESSAGE_TO_DLQ_FAILURE_BACKOFF_DELAY.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (Throwable t) {
            if (scheduler.isShutdown()) {
                return;
            }
            LOGGER.error("[Bug] Failed to schedule DLQ message request, mq={}, messageId={}, clientId={}", new Object[]{this.mq, messageView.getMessageId(), this.consumer.getClientId()});
            this.forwardToDeadLetterQueueLater(messageView, 1 + attempt, future0);
        }
    }

    private ListenableFuture<Void> ackMessage(MessageViewImpl messageView) {
        SettableFuture future = SettableFuture.create();
        this.ackMessage(messageView, 1, (SettableFuture<Void>)future);
        return future;
    }

    private void ackMessage(final MessageViewImpl messageView, final int attempt, final SettableFuture<Void> future0) {
        final ClientId clientId = this.consumer.getClientId();
        final String consumerGroup = this.consumer.getConsumerGroup();
        final MessageId messageId = messageView.getMessageId();
        final Endpoints endpoints = messageView.getEndpoints();
        final RpcFuture<AckMessageRequest, AckMessageResponse> future = this.consumer.ackMessage(messageView);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<AckMessageResponse>(){

            public void onSuccess(AckMessageResponse response) {
                String requestId = future.getContext().getRequestId();
                Status status = response.getStatus();
                Code code = status.getCode();
                if (Code.INVALID_RECEIPT_HANDLE.equals((Object)code)) {
                    LOGGER.error("Failed to ack message due to the invalid receipt handle, forgive to retry, clientId={}, consumerGroup={}, messageId={}, attempt={}, mq={}, endpoints={}, requestId={}, status message=[{}]", new Object[]{clientId, consumerGroup, messageId, attempt, ProcessQueueImpl.this.mq, endpoints, requestId, status.getMessage()});
                    future0.setException((Throwable)((Object)new BadRequestException(code.getNumber(), requestId, status.getMessage())));
                    return;
                }
                if (!Code.OK.equals((Object)code)) {
                    LOGGER.error("Failed to ack message, would attempt to re-ack later, clientId={}, consumerGroup={}, attempt={}, messageId={}, mq={}, code={}, requestId={}, endpoints={}, status message=[{}]", new Object[]{clientId, consumerGroup, attempt, messageId, ProcessQueueImpl.this.mq, code, requestId, endpoints, status.getMessage()});
                    ProcessQueueImpl.this.ackMessageLater(messageView, 1 + attempt, (SettableFuture<Void>)future0);
                    return;
                }
                future0.setFuture(Futures.immediateVoidFuture());
                if (1 < attempt) {
                    LOGGER.info("Finally, ack message successfully, clientId={}, consumerGroup={}, attempt={}, messageId={}, mq={}, endpoints={}, requestId={}", new Object[]{clientId, consumerGroup, attempt, messageId, ProcessQueueImpl.this.mq, endpoints, requestId});
                    return;
                }
                LOGGER.debug("Ack message successfully, clientId={}, consumerGroup={}, messageId={}, mq={}, endpoints={}, requestId={}", new Object[]{clientId, consumerGroup, messageId, ProcessQueueImpl.this.mq, endpoints, requestId});
            }

            public void onFailure(Throwable t) {
                LOGGER.error("Exception raised while acknowledging message, clientId={}, consumerGroup={}, would attempt to re-ack later, attempt={}, messageId={}, mq={}, endpoints={}", new Object[]{clientId, consumerGroup, attempt, messageId, ProcessQueueImpl.this.mq, endpoints, t});
                ProcessQueueImpl.this.ackMessageLater(messageView, 1 + attempt, (SettableFuture<Void>)future0);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void ackMessageLater(MessageViewImpl messageView, int attempt, SettableFuture<Void> future) {
        MessageId messageId = messageView.getMessageId();
        ScheduledExecutorService scheduler = this.consumer.getScheduler();
        try {
            scheduler.schedule(() -> this.ackMessage(messageView, attempt, future), ACK_MESSAGE_FAILURE_BACKOFF_DELAY.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (Throwable t) {
            if (scheduler.isShutdown()) {
                return;
            }
            LOGGER.error("[Bug] Failed to schedule message ack request, mq={}, messageId={}, clientId={}", new Object[]{this.mq, messageId, this.consumer.getClientId()});
            this.ackMessageLater(messageView, 1 + attempt, future);
        }
    }

    @Override
    public long getCachedMessageCount() {
        this.cachedMessageLock.readLock().lock();
        try {
            long l = this.cachedMessages.size();
            return l;
        }
        finally {
            this.cachedMessageLock.readLock().unlock();
        }
    }

    @Override
    public long getCachedMessageBytes() {
        return this.cachedMessagesBytes.get();
    }

    @Override
    public void doStats() {
        long receptionTimes = this.receptionTimes.getAndSet(0L);
        long receivedMessagesQuantity = this.receivedMessagesQuantity.getAndSet(0L);
        LOGGER.info("Process queue stats: clientId={}, mq={}, receptionTimes={}, receivedMessageQuantity={}, cachedMessageCount={}, cachedMessageBytes={}", new Object[]{this.consumer.getClientId(), this.mq, receptionTimes, receivedMessagesQuantity, this.getCachedMessageCount(), this.getCachedMessageBytes()});
    }
}

