/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.metrics;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.apache.rocketmq.client.apis.consumer.PushConsumer;
import org.apache.rocketmq.client.apis.consumer.SimpleConsumer;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.impl.ClientImpl;
import org.apache.rocketmq.client.java.message.MessageCommon;
import org.apache.rocketmq.client.java.metrics.ClientMeterProvider;
import org.apache.rocketmq.client.java.metrics.HistogramEnum;
import org.apache.rocketmq.client.java.metrics.InvocationStatus;
import org.apache.rocketmq.client.java.metrics.MetricLabels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageMeterInterceptor
implements MessageInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageMeterInterceptor.class);
    private final ClientMeterProvider clientMeterProvider;

    public MessageMeterInterceptor(ClientMeterProvider clientMeterProvider) {
        this.clientMeterProvider = clientMeterProvider;
    }

    private void doAfterSendMessage(List<MessageCommon> messageCommons, Duration duration, MessageHookPointsStatus status) {
        Optional<DoubleHistogram> optionalHistogram = this.clientMeterProvider.getHistogramByEnum(HistogramEnum.SEND_SUCCESS_COST_TIME);
        if (!optionalHistogram.isPresent()) {
            return;
        }
        DoubleHistogram histogram = optionalHistogram.get();
        for (MessageCommon messageCommon : messageCommons) {
            InvocationStatus invocationStatus = MessageHookPointsStatus.OK.equals((Object)status) ? InvocationStatus.SUCCESS : InvocationStatus.FAILURE;
            Attributes attributes = Attributes.builder().put(MetricLabels.TOPIC, (Object)messageCommon.getTopic()).put(MetricLabels.CLIENT_ID, (Object)this.clientMeterProvider.getClient().clientId()).put(MetricLabels.INVOCATION_STATUS, (Object)invocationStatus.getName()).build();
            histogram.record((double)duration.toMillis(), attributes);
        }
    }

    private void doAfterReceive(List<MessageCommon> messageCommons) {
        long deliveryTimestampFromRemoteMillis;
        if (messageCommons.isEmpty()) {
            return;
        }
        ClientImpl client = this.clientMeterProvider.getClient();
        String consumerGroup = null;
        if (client instanceof PushConsumer) {
            consumerGroup = ((PushConsumer)client).getConsumerGroup();
        }
        if (client instanceof SimpleConsumer) {
            consumerGroup = ((SimpleConsumer)client).getConsumerGroup();
        }
        if (null == consumerGroup) {
            LOGGER.error("[Bug] consumerGroup is not recognized, clientId={}", (Object)client.clientId());
            return;
        }
        MessageCommon messageCommon = messageCommons.iterator().next();
        Optional<Timestamp> optionalDeliveryTimestampFromRemote = messageCommon.getDeliveryTimestampFromRemote();
        if (!optionalDeliveryTimestampFromRemote.isPresent()) {
            return;
        }
        Timestamp deliveryTimestampFromRemote = optionalDeliveryTimestampFromRemote.get();
        long currentTimeMillis = System.currentTimeMillis();
        long latency = currentTimeMillis - (deliveryTimestampFromRemoteMillis = Timestamps.toMillis((Timestamp)deliveryTimestampFromRemote));
        if (0L > latency) {
            LOGGER.debug("[Bug] latency is negative, latency={}ms, currentTimeMillis={}, deliveryTimestampFromRemoteMillis={}", new Object[]{latency, currentTimeMillis, deliveryTimestampFromRemoteMillis});
            return;
        }
        Optional<DoubleHistogram> optionalHistogram = this.clientMeterProvider.getHistogramByEnum(HistogramEnum.DELIVERY_LATENCY);
        if (!optionalHistogram.isPresent()) {
            return;
        }
        DoubleHistogram histogram = optionalHistogram.get();
        Attributes attributes = Attributes.builder().put(MetricLabels.TOPIC, (Object)messageCommon.getTopic()).put(MetricLabels.CONSUMER_GROUP, (Object)consumerGroup).put(MetricLabels.CLIENT_ID, (Object)client.clientId()).build();
        histogram.record((double)latency, attributes);
    }

    private void doBeforeConsumeMessage(List<MessageCommon> messageCommons) {
        ClientImpl client = this.clientMeterProvider.getClient();
        String consumerGroup = null;
        if (client instanceof PushConsumer) {
            consumerGroup = ((PushConsumer)client).getConsumerGroup();
        }
        if (null == consumerGroup) {
            LOGGER.error("[Bug] consumerGroup is not recognized, clientId={}", (Object)client.clientId());
            return;
        }
        MessageCommon messageCommon = messageCommons.iterator().next();
        Optional<Duration> optionalDurationAfterDecoding = messageCommon.getDurationAfterDecoding();
        if (!optionalDurationAfterDecoding.isPresent()) {
            return;
        }
        Duration durationAfterDecoding = optionalDurationAfterDecoding.get();
        Attributes attributes = Attributes.builder().put(MetricLabels.TOPIC, (Object)messageCommon.getTopic()).put(MetricLabels.CONSUMER_GROUP, (Object)consumerGroup).put(MetricLabels.CLIENT_ID, (Object)client.clientId()).build();
        Optional<DoubleHistogram> optionalHistogram = this.clientMeterProvider.getHistogramByEnum(HistogramEnum.AWAIT_TIME);
        if (!optionalHistogram.isPresent()) {
            return;
        }
        DoubleHistogram histogram = optionalHistogram.get();
        histogram.record((double)durationAfterDecoding.toMillis(), attributes);
    }

    private void doAfterProcessMessage(List<MessageCommon> messageCommons, Duration duration, MessageHookPointsStatus status) {
        ClientImpl client = this.clientMeterProvider.getClient();
        if (!(client instanceof PushConsumer)) {
            LOGGER.error("[Bug] current client is not push consumer, clientId={}", (Object)client.clientId());
            return;
        }
        PushConsumer pushConsumer = (PushConsumer)client;
        for (MessageCommon messageCommon : messageCommons) {
            InvocationStatus invocationStatus = MessageHookPointsStatus.OK.equals((Object)status) ? InvocationStatus.SUCCESS : InvocationStatus.FAILURE;
            Attributes attributes = Attributes.builder().put(MetricLabels.TOPIC, (Object)messageCommon.getTopic()).put(MetricLabels.CONSUMER_GROUP, (Object)pushConsumer.getConsumerGroup()).put(MetricLabels.CLIENT_ID, (Object)this.clientMeterProvider.getClient().clientId()).put(MetricLabels.INVOCATION_STATUS, (Object)invocationStatus.getName()).build();
            Optional<DoubleHistogram> optionalHistogram = this.clientMeterProvider.getHistogramByEnum(HistogramEnum.PROCESS_TIME);
            if (!optionalHistogram.isPresent()) {
                return;
            }
            DoubleHistogram histogram = optionalHistogram.get();
            histogram.record((double)duration.toMillis(), attributes);
        }
    }

    @Override
    public void doBefore(MessageHookPoints messageHookPoints, List<MessageCommon> messageCommons) {
        if (!this.clientMeterProvider.isEnabled()) {
            return;
        }
        if (MessageHookPoints.CONSUME.equals((Object)messageHookPoints)) {
            this.doBeforeConsumeMessage(messageCommons);
        }
    }

    @Override
    public void doAfter(MessageHookPoints messageHookPoints, List<MessageCommon> messageCommons, Duration duration, MessageHookPointsStatus status) {
        if (!this.clientMeterProvider.isEnabled()) {
            return;
        }
        switch (messageHookPoints) {
            case SEND: {
                this.doAfterSendMessage(messageCommons, duration, status);
                break;
            }
            case RECEIVE: {
                this.doAfterReceive(messageCommons);
                break;
            }
            case CONSUME: {
                this.doAfterProcessMessage(messageCommons, duration, status);
                break;
            }
        }
    }
}

