/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URISyntaxException;
import java.time.Duration;
import org.apache.james.CleanupTasksPerformer;
import org.apache.james.backends.rabbitmq.DockerRabbitMQ;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.RabbitMQFixture;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueueManagement;
import org.apache.james.queue.rabbitmq.view.RabbitMQMailQueueConfiguration;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.apache.james.task.Task;

public class TestRabbitMQModule
extends AbstractModule {
    private static final int MAX_THREE_RETRIES = 3;
    private static final int MIN_DELAY_OF_ONE_HUNDRED_MILLISECONDS = 100;
    private static final int CONNECTION_TIMEOUT_OF_ONE_SECOND = 1000;
    private static final int CHANNEL_RPC_TIMEOUT_OF_ONE_SECOND = 1000;
    private static final int HANDSHAKE_TIMEOUT_OF_ONE_SECOND = 1000;
    private static final int SHUTDOWN_TIMEOUT_OF_ONE_SECOND = 1000;
    private static final int NETWORK_RECOVERY_INTERVAL_OF_ONE_SECOND = 1000;
    private final DockerRabbitMQ rabbitMQ;

    public TestRabbitMQModule(DockerRabbitMQ rabbitMQ) {
        this.rabbitMQ = rabbitMQ;
    }

    protected void configure() {
        this.bind(CassandraMailQueueViewConfiguration.class).toInstance((Object)CassandraMailQueueViewConfiguration.builder().bucketCount(1).updateBrowseStartPace(1000).sliceWindow(Duration.ofHours(1L)).build());
        Multibinder.newSetBinder((Binder)this.binder(), CleanupTasksPerformer.CleanupTask.class).addBinding().to(QueueCleanUp.class);
    }

    @Provides
    @Singleton
    protected RabbitMQConfiguration provideRabbitMQConfiguration() throws URISyntaxException {
        return RabbitMQConfiguration.builder().amqpUri(this.rabbitMQ.amqpUri()).managementUri(this.rabbitMQ.managementUri()).managementCredentials(RabbitMQFixture.DEFAULT_MANAGEMENT_CREDENTIAL).maxRetries(3).minDelayInMs(100).connectionTimeoutInMs(1000).channelRpcTimeoutInMs(1000).handshakeTimeoutInMs(1000).shutdownTimeoutInMs(1000).networkRecoveryIntervalInMs(1000).build();
    }

    @Provides
    @Singleton
    private RabbitMQMailQueueConfiguration getMailQueueSizeConfiguration() {
        return RabbitMQMailQueueConfiguration.sizeMetricsEnabled();
    }

    public static class QueueCleanUp
    implements CleanupTasksPerformer.CleanupTask {
        private final RabbitMQMailQueueManagement api;

        @Inject
        public QueueCleanUp(RabbitMQMailQueueManagement api) {
            this.api = api;
        }

        public Task.Result run() {
            this.api.deleteAllQueues();
            return Task.Result.COMPLETED;
        }
    }
}

