/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vacation.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.RecipientId;
import reactor.core.publisher.Mono;

public class CassandraNotificationRegistryDAO {
    public static final String TTL = "TTL";
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement registerStatement;
    private final PreparedStatement registerWithTTLStatement;
    private final PreparedStatement isRegisteredStatement;
    private final PreparedStatement flushStatement;

    @Inject
    public CassandraNotificationRegistryDAO(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.registerStatement = session.prepare(this.createInsert().build());
        this.registerWithTTLStatement = session.prepare(this.createInsert().usingTtl(QueryBuilder.bindMarker((String)TTL)).build());
        this.isRegisteredStatement = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"vacation_notification_registry").all().whereColumn("accountId").isEqualTo((Term)QueryBuilder.bindMarker((String)"accountId"))).whereColumn("recipientId").isEqualTo((Term)QueryBuilder.bindMarker((String)"recipientId"))).build());
        this.flushStatement = session.prepare(((Delete)QueryBuilder.deleteFrom((String)"vacation_notification_registry").whereColumn("accountId").isEqualTo((Term)QueryBuilder.bindMarker((String)"accountId"))).build());
    }

    private RegularInsert createInsert() {
        return QueryBuilder.insertInto((String)"vacation_notification_registry").value("accountId", (Term)QueryBuilder.bindMarker((String)"accountId")).value("recipientId", (Term)QueryBuilder.bindMarker((String)"recipientId"));
    }

    public Mono<Void> register(AccountId accountId, RecipientId recipientId, Optional<Integer> ttl) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)ttl.filter(value -> value <= 630720000).map(value -> (BoundStatement)this.registerWithTTLStatement.bind(new Object[0]).setInt(TTL, value.intValue())).orElse(this.registerStatement.bind(new Object[0])).setString("accountId", accountId.getIdentifier())).setString("recipientId", recipientId.getAsString()));
    }

    public Mono<Boolean> isRegistered(AccountId accountId, RecipientId recipientId) {
        return this.cassandraAsyncExecutor.executeSingleRowOptional((Statement)((BoundStatement)this.isRegisteredStatement.bind(new Object[0]).setString("accountId", accountId.getIdentifier())).setString("recipientId", recipientId.getAsString())).map(Optional::isPresent);
    }

    public Mono<Void> flush(AccountId accountId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.flushStatement.bind(new Object[0]).setString("accountId", accountId.getIdentifier()));
    }
}

