/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.pushsubscription;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Set;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.api.model.ExpireTimeInvalidException;
import org.apache.james.jmap.api.model.InvalidPushSubscriptionKeys;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.PushSubscriptionCreationRequest;
import org.apache.james.jmap.api.model.PushSubscriptionExpiredTime;
import org.apache.james.jmap.api.model.PushSubscriptionId;
import org.apache.james.jmap.api.model.PushSubscriptionKeys;
import org.apache.james.jmap.api.model.PushSubscriptionNotFoundException;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionHelpers;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionRepository;
import org.apache.james.jmap.postgres.pushsubscription.PostgresPushSubscriptionDAO;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

public class PostgresPushSubscriptionRepository
implements PushSubscriptionRepository {
    private final Clock clock;
    private final TypeStateFactory typeStateFactory;
    private final PostgresExecutor.Factory executorFactory;

    @Inject
    @Singleton
    public PostgresPushSubscriptionRepository(Clock clock, TypeStateFactory typeStateFactory, PostgresExecutor.Factory executorFactory) {
        this.clock = clock;
        this.typeStateFactory = typeStateFactory;
        this.executorFactory = executorFactory;
    }

    public Mono<PushSubscription> save(Username username, PushSubscriptionCreationRequest request) {
        PostgresPushSubscriptionDAO pushSubscriptionDAO = this.getDAO(username);
        return this.validateCreationRequest(request).then(Mono.defer(() -> {
            PushSubscription pushSubscription = PushSubscription.from((PushSubscriptionCreationRequest)request, (PushSubscriptionExpiredTime)PushSubscriptionHelpers.evaluateExpiresTime((Optional)OptionConverters.toJava((Option)request.expires().map(PushSubscriptionExpiredTime::value)), (Clock)this.clock), (TypeStateFactory)this.typeStateFactory);
            return pushSubscriptionDAO.save(username, pushSubscription).thenReturn((Object)pushSubscription);
        }));
    }

    private Mono<Object> validateCreationRequest(PushSubscriptionCreationRequest request) {
        return Mono.just((Object)request).handle((creationRequest, sink) -> {
            if (PushSubscriptionHelpers.isInThePast((Option)request.expires(), (Clock)this.clock)) {
                sink.error((Throwable)new ExpireTimeInvalidException(((PushSubscriptionExpiredTime)request.expires().get()).value(), "expires must be greater than now"));
                return;
            }
            if (PushSubscriptionHelpers.isInvalidPushSubscriptionKey((Option)request.keys())) {
                sink.error((Throwable)new InvalidPushSubscriptionKeys((PushSubscriptionKeys)request.keys().get()));
            }
        });
    }

    public Mono<PushSubscriptionExpiredTime> updateExpireTime(Username username, PushSubscriptionId id, ZonedDateTime newExpire) {
        return Mono.just((Object)newExpire).handle((inputTime, sink) -> {
            if (newExpire.isBefore(ZonedDateTime.now(this.clock))) {
                sink.error((Throwable)new ExpireTimeInvalidException(inputTime, "expires must be greater than now"));
            }
        }).then(this.getDAO(username).updateExpireTime(username, id, PushSubscriptionHelpers.evaluateExpiresTime(Optional.of(newExpire), (Clock)this.clock).value()).map(PushSubscriptionExpiredTime::new).switchIfEmpty(Mono.error(() -> new PushSubscriptionNotFoundException(id))));
    }

    public Mono<Void> updateTypes(Username username, PushSubscriptionId id, Set<TypeName> types) {
        return this.getDAO(username).updateType(username, id, types).switchIfEmpty(Mono.error(() -> new PushSubscriptionNotFoundException(id))).then();
    }

    public Mono<Void> validateVerificationCode(Username username, PushSubscriptionId id) {
        return this.getDAO(username).updateValidated(username, id, true).switchIfEmpty(Mono.error(() -> new PushSubscriptionNotFoundException(id))).then();
    }

    public Mono<Void> revoke(Username username, PushSubscriptionId id) {
        return this.getDAO(username).deleteByUsernameAndId(username, id);
    }

    public Mono<Void> delete(Username username) {
        return this.getDAO(username).deleteByUsername(username);
    }

    public Flux<PushSubscription> get(Username username, Set<PushSubscriptionId> ids) {
        return this.getDAO(username).getByUsernameAndIds(username, ids);
    }

    public Flux<PushSubscription> list(Username username) {
        return this.getDAO(username).listByUsername(username);
    }

    private PostgresPushSubscriptionDAO getDAO(Username username) {
        return new PostgresPushSubscriptionDAO(this.executorFactory.create(username.getDomainPart()), this.typeStateFactory);
    }
}

