/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class DeleteMailsFromMailQueueTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"delete-mails-from-mail-queue");
    private final Optional<MailAddress> optionalSender;
    private final Optional<String> optionalName;
    private final Optional<MailAddress> optionalRecipient;
    private final MailQueueFactory factory;
    private final MailQueueName queueName;
    private Optional<Long> initialCount;
    private Optional<ManageableMailQueue> queue;
    private Optional<TaskExecutionDetails.AdditionalInformation> lastAdditionalInformation;

    public DeleteMailsFromMailQueueTask(MailQueueName queueName, MailQueueFactory factory, Optional<MailAddress> optionalSender, Optional<String> optionalName, Optional<MailAddress> optionalRecipient) {
        this.factory = factory;
        this.queueName = queueName;
        Preconditions.checkArgument((Booleans.countTrue((boolean[])new boolean[]{optionalSender.isPresent(), optionalName.isPresent(), optionalRecipient.isPresent()}) == 1 ? 1 : 0) != 0, (Object)"You should provide one and only one of the query parameters 'sender', 'name' or 'recipient'.");
        this.optionalSender = optionalSender;
        this.optionalName = optionalName;
        this.optionalRecipient = optionalRecipient;
        this.initialCount = Optional.empty();
        this.queue = Optional.empty();
        this.lastAdditionalInformation = Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task.Result run() {
        try {
            Task.Result result;
            block11: {
                ManageableMailQueue queue = this.factory.create(this.queueName);
                try {
                    this.initialCount = Mono.justOrEmpty((Object)queue).flatMap(q -> Mono.from((Publisher)q.getSizeReactive())).blockOptional();
                    this.queue = Optional.of(queue);
                    this.optionalSender.ifPresent((Consumer<MailAddress>)Throwing.consumer(sender -> queue.remove(ManageableMailQueue.Type.Sender, sender.asString())));
                    this.optionalName.ifPresent((Consumer<String>)Throwing.consumer(name -> queue.remove(ManageableMailQueue.Type.Name, name)));
                    this.optionalRecipient.ifPresent((Consumer<MailAddress>)Throwing.consumer(recipient -> queue.remove(ManageableMailQueue.Type.Recipient, recipient.asString())));
                    this.lastAdditionalInformation = (Optional)Mono.from(this.detailsReactive()).block();
                    result = Task.Result.COMPLETED;
                    if (queue == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (queue != null) {
                            try {
                                queue.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | MailQueue.MailQueueException e) {
                        LOGGER.error("Delete mails from MailQueue got an exception", e);
                        Task.Result result2 = Task.Result.PARTIAL;
                        return result2;
                    }
                }
                queue.close();
            }
            return result;
        }
        finally {
            this.queue = Optional.empty();
        }
    }

    public MailQueueName getQueueName() {
        return this.queueName;
    }

    public TaskType type() {
        return TYPE;
    }

    Optional<String> getMaybeName() {
        return this.optionalName;
    }

    Optional<MailAddress> getMaybeRecipient() {
        return this.optionalRecipient;
    }

    Optional<MailAddress> getMaybeSender() {
        return this.optionalSender;
    }

    public Publisher<Optional<TaskExecutionDetails.AdditionalInformation>> detailsReactive() {
        return Mono.justOrEmpty(this.lastAdditionalInformation).switchIfEmpty(this.getAdditionalInformation()).map(Optional::of).switchIfEmpty(Mono.just(Optional.empty()));
    }

    private Mono<TaskExecutionDetails.AdditionalInformation> getAdditionalInformation() {
        return Mono.justOrEmpty(this.queue).flatMap(q -> Mono.from((Publisher)q.getSizeReactive())).map(remainingSize -> new AdditionalInformation(this.queueName, this.initialCount.get(), (long)remainingSize, this.optionalSender, this.optionalName, this.optionalRecipient, Clock.systemUTC().instant()));
    }

    @FunctionalInterface
    public static interface MailQueueFactory {
        public ManageableMailQueue create(MailQueueName var1) throws MailQueue.MailQueueException;
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final MailQueueName mailQueueName;
        private final long remainingCount;
        private final long initialCount;
        private final Optional<String> sender;
        private final Optional<String> name;
        private final Optional<String> recipient;
        private final Instant timestamp;

        public AdditionalInformation(MailQueueName mailQueueName, long initialCount, long remainingCount, Optional<MailAddress> optionalSender, Optional<String> optionalName, Optional<MailAddress> optionalRecipient, Instant timestamp) {
            this.mailQueueName = mailQueueName;
            this.initialCount = initialCount;
            this.remainingCount = remainingCount;
            this.sender = optionalSender.map(MailAddress::asString);
            this.name = optionalName;
            this.recipient = optionalRecipient.map(MailAddress::asString);
            this.timestamp = timestamp;
        }

        public String getMailQueueName() {
            return this.mailQueueName.asString();
        }

        public long getRemainingCount() {
            return this.remainingCount;
        }

        public long getInitialCount() {
            return this.initialCount;
        }

        public Optional<String> getSender() {
            return this.sender;
        }

        public Optional<String> getName() {
            return this.name;
        }

        public Optional<String> getRecipient() {
            return this.recipient;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }

    public static class UnknownSerializedQueue
    extends RuntimeException {
        public UnknownSerializedQueue(String queueName) {
            super("Unable to retrieve '" + queueName + "' queue");
        }
    }
}

