/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.common.base.Preconditions;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Modules;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.events.EventListener;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.GuiceLoader;

public class MailboxListenerFactory {
    private final GuiceLoader guiceLoader;

    @Inject
    public MailboxListenerFactory(GuiceLoader guiceLoader) {
        this.guiceLoader = guiceLoader;
    }

    public MailboxListenerBuilder newInstance() {
        return new MailboxListenerBuilder(this.guiceLoader);
    }

    public static class MailboxListenerBuilder {
        private final GuiceLoader guiceLoader;
        private Optional<ClassName> clazz;
        private Optional<EventListener.ExecutionMode> executionMode;
        private Optional<HierarchicalConfiguration<ImmutableNode>> configuration;

        @Inject
        public MailboxListenerBuilder(GuiceLoader genericLoader) {
            this.guiceLoader = genericLoader;
            this.clazz = Optional.empty();
            this.executionMode = Optional.empty();
            this.configuration = Optional.empty();
        }

        public MailboxListenerBuilder withExecutionMode(EventListener.ExecutionMode executionMode) {
            this.executionMode = Optional.of(executionMode);
            return this;
        }

        public MailboxListenerBuilder withConfiguration(HierarchicalConfiguration<ImmutableNode> configuration) {
            this.configuration = Optional.of(configuration);
            return this;
        }

        public MailboxListenerBuilder withExecutionMode(Optional<EventListener.ExecutionMode> executionMode) {
            executionMode.ifPresent(this::withExecutionMode);
            return this;
        }

        public MailboxListenerBuilder withConfiguration(Optional<HierarchicalConfiguration<ImmutableNode>> configuration) {
            configuration.ifPresent(this::withConfiguration);
            return this;
        }

        public MailboxListenerBuilder clazz(ClassName clazz) {
            this.clazz = Optional.of(clazz);
            return this;
        }

        public EventListener build() throws ClassNotFoundException {
            Preconditions.checkState((boolean)this.clazz.isPresent(), (Object)"'clazz' is mandatory");
            Module childModule = Modules.combine((Module[])new Module[]{binder -> binder.bind(EventListener.ExecutionMode.class).toInstance((Object)this.executionMode.orElse(EventListener.ExecutionMode.SYNCHRONOUS)), binder -> binder.bind((TypeLiteral)new TypeLiteral<HierarchicalConfiguration<ImmutableNode>>(this){}).toInstance(this.configuration.orElse((HierarchicalConfiguration<ImmutableNode>)new BaseHierarchicalConfiguration()))});
            return (EventListener)this.guiceLoader.withChildModule(childModule).instantiate(this.clazz.get());
        }
    }
}

