/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.ldap.sdk.unboundidds.tools.ToolUtils;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentValueValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class FileArgument
extends Argument {
    @NotNull
    private static final List<char[]> POTENTIAL_PASSPHRASES_TO_AVOID_PROMPTING = Collections.singletonList(new char[0]);
    private static final long serialVersionUID = 741228505566416489L;
    private final boolean fileMustExist;
    private final boolean mustBeDirectory;
    private final boolean mustBeFile;
    private final boolean parentMustExist;
    @NotNull
    private final ArrayList<File> values;
    @Nullable
    private File relativeBaseDirectory;
    @NotNull
    private final List<ArgumentValueValidator> validators;
    @Nullable
    private final List<File> defaultValues;

    public FileArgument(@Nullable Character shortIdentifier, @Nullable String longIdentifier, @NotNull String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, false, 1, null, description);
    }

    public FileArgument(@Nullable Character shortIdentifier, @Nullable String longIdentifier, boolean isRequired, int maxOccurrences, @Nullable String valuePlaceholder, @NotNull String description) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, false, false, false, false, null);
    }

    public FileArgument(@Nullable Character shortIdentifier, @Nullable String longIdentifier, boolean isRequired, int maxOccurrences, @Nullable String valuePlaceholder, @NotNull String description, boolean fileMustExist, boolean parentMustExist, boolean mustBeFile, boolean mustBeDirectory) throws ArgumentException {
        this(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder, description, fileMustExist, parentMustExist, mustBeFile, mustBeDirectory, null);
    }

    public FileArgument(@Nullable Character shortIdentifier, @Nullable String longIdentifier, boolean isRequired, int maxOccurrences, @Nullable String valuePlaceholder, @NotNull String description, boolean fileMustExist, boolean parentMustExist, boolean mustBeFile, boolean mustBeDirectory, @Nullable List<File> defaultValues) throws ArgumentException {
        super(shortIdentifier, longIdentifier, isRequired, maxOccurrences, valuePlaceholder == null ? ArgsMessages.INFO_PLACEHOLDER_PATH.get() : valuePlaceholder, description);
        if (mustBeFile && mustBeDirectory) {
            throw new ArgumentException(ArgsMessages.ERR_FILE_CANNOT_BE_FILE_AND_DIRECTORY.get(this.getIdentifierString()));
        }
        this.fileMustExist = fileMustExist;
        this.parentMustExist = parentMustExist;
        this.mustBeFile = mustBeFile;
        this.mustBeDirectory = mustBeDirectory;
        this.defaultValues = defaultValues == null || defaultValues.isEmpty() ? null : Collections.unmodifiableList(defaultValues);
        this.values = new ArrayList(5);
        this.validators = new ArrayList<ArgumentValueValidator>(5);
        this.relativeBaseDirectory = null;
    }

    private FileArgument(@NotNull FileArgument source) {
        super(source);
        this.fileMustExist = source.fileMustExist;
        this.mustBeDirectory = source.mustBeDirectory;
        this.mustBeFile = source.mustBeFile;
        this.parentMustExist = source.parentMustExist;
        this.defaultValues = source.defaultValues;
        this.relativeBaseDirectory = source.relativeBaseDirectory;
        this.validators = new ArrayList<ArgumentValueValidator>(source.validators);
        this.values = new ArrayList(5);
    }

    public boolean fileMustExist() {
        return this.fileMustExist;
    }

    public boolean parentMustExist() {
        return this.parentMustExist;
    }

    public boolean mustBeFile() {
        return this.mustBeFile;
    }

    public boolean mustBeDirectory() {
        return this.mustBeDirectory;
    }

    @Nullable
    public List<File> getDefaultValues() {
        return this.defaultValues;
    }

    @Nullable
    public File getRelativeBaseDirectory() {
        return this.relativeBaseDirectory;
    }

    public void setRelativeBaseDirectory(@Nullable File relativeBaseDirectory) {
        this.relativeBaseDirectory = relativeBaseDirectory;
    }

    public void addValueValidator(@NotNull ArgumentValueValidator validator) {
        this.validators.add(validator);
    }

    @Override
    protected void addValue(@NotNull String valueString) throws ArgumentException {
        File f = new File(valueString);
        if (!f.isAbsolute()) {
            f = this.relativeBaseDirectory == null ? new File(f.getAbsolutePath()) : new File(new File(this.relativeBaseDirectory, valueString).getAbsolutePath());
        }
        if (f.exists()) {
            if (this.mustBeFile && !f.isFile()) {
                throw new ArgumentException(ArgsMessages.ERR_FILE_VALUE_NOT_FILE.get(this.getIdentifierString(), f.getAbsolutePath()));
            }
            if (this.mustBeDirectory && !f.isDirectory()) {
                throw new ArgumentException(ArgsMessages.ERR_FILE_VALUE_NOT_DIRECTORY.get(this.getIdentifierString(), f.getAbsolutePath()));
            }
        } else {
            File parentFile;
            if (this.fileMustExist) {
                throw new ArgumentException(ArgsMessages.ERR_FILE_DOESNT_EXIST.get(f.getAbsolutePath(), this.getIdentifierString()));
            }
            if (!(!this.parentMustExist || (parentFile = f.getAbsoluteFile().getParentFile()) != null && parentFile.exists() && parentFile.isDirectory())) {
                throw new ArgumentException(ArgsMessages.ERR_FILE_PARENT_DOESNT_EXIST.get(f.getAbsolutePath(), this.getIdentifierString()));
            }
        }
        if (this.values.size() >= this.getMaxOccurrences()) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        for (ArgumentValueValidator v : this.validators) {
            v.validateArgumentValue(this, valueString);
        }
        this.values.add(f);
    }

    @Nullable
    public File getValue() {
        if (this.values.isEmpty()) {
            if (this.defaultValues == null || this.defaultValues.isEmpty()) {
                return null;
            }
            return this.defaultValues.get(0);
        }
        return this.values.get(0);
    }

    @NotNull
    public List<File> getValues() {
        if (this.values.isEmpty() && this.defaultValues != null) {
            return this.defaultValues;
        }
        return Collections.unmodifiableList(this.values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public InputStream getFileInputStream() throws IOException {
        File f = this.getValue();
        if (f == null) {
            return null;
        }
        InputStream inputStream = new FileInputStream(f);
        boolean closeStream = true;
        try {
            ArrayList potentialPassphrases = new ArrayList();
            try {
                ObjectPair<InputStream, char[]> streamPair = ToolUtils.getPossiblyPassphraseEncryptedInputStream(inputStream, POTENTIAL_PASSPHRASES_TO_AVOID_PROMPTING, false, (CharSequence)ArgsMessages.INFO_FILE_ENTER_ENC_PW.get(f.getAbsolutePath()), (CharSequence)ArgsMessages.ERR_FILE_WRONG_ENC_PW.get(f.getAbsolutePath()), System.out, System.err);
                inputStream = streamPair.getFirst();
            }
            catch (GeneralSecurityException e) {
                throw new IOException(ArgsMessages.ERR_FILE_CANNOT_DECRYPT.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
            }
            inputStream = ToolUtils.getPossiblyGZIPCompressedInputStream(inputStream);
            closeStream = false;
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            if (closeStream) {
                inputStream.close();
            }
        }
    }

    @Nullable
    public List<String> getFileLines() throws IOException {
        return this.getFileLines(true);
    }

    @Nullable
    public List<String> getNonBlankFileLines() throws IOException {
        return this.getFileLines(false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private List<String> getFileLines(boolean includeBlank) throws IOException {
        inputStream = this.getFileInputStream();
        if (inputStream == null) {
            return null;
        }
        try {
            inputStreamReader = new InputStreamReader(inputStream);
            var4_4 = null;
            try {
                bufferedReader = new BufferedReader(inputStreamReader);
                var6_7 = null;
                lines = new ArrayList<String>();
lbl12:
                // 3 sources

                while (true) {
                    line = bufferedReader.readLine();
                    if (line != null) ** GOTO lbl42
                    var9_11 = lines;
                    if (bufferedReader == null) return var9_11;
                    if (var6_7 != null) {
                    }
                    ** GOTO lbl40
                    break;
                }
                {
                    catch (Throwable var7_9) {
                        var6_7 = var7_9;
                        throw var7_9;
                    }
                    catch (Throwable var11_14) {
                        if (bufferedReader == null) throw var11_14;
                        if (var6_7 == null) {
                            bufferedReader.close();
                            throw var11_14;
                        }
                        try {
                            bufferedReader.close();
                            throw var11_14;
                        }
                        catch (Throwable var12_15) {
                            var6_7.addSuppressed(var12_15);
                            throw var11_14;
                        }
                    }
                    try {
                        bufferedReader.close();
                        return var9_11;
                    }
                    catch (Throwable var10_12) {
                        var6_7.addSuppressed(var10_12);
                        return var9_11;
                    }
lbl40:
                    // 1 sources

                    bufferedReader.close();
                    return var9_11;
lbl42:
                    // 1 sources

                    ** try [egrp 7[TRYBLOCK] [8 : 135->209)] { 
lbl-1000:
                    // 1 sources

                    {
                        if (!includeBlank && line.isEmpty()) ** GOTO lbl12
                        lines.add(line);
                        ** continue;
                    }
                }
            }
lbl47:
            // 2 sources

            catch (Throwable var5_6) {
                var4_4 = var5_6;
                throw var5_6;
            }
            finally {
                if (inputStreamReader != null) {
                    if (var4_4 != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (Throwable var10_13) {
                            var4_4.addSuppressed(var10_13);
                        }
                    } else {
                        inputStreamReader.close();
                    }
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] getFileBytes() throws IOException {
        InputStream inputStream = this.getFileInputStream();
        if (inputStream == null) {
            return null;
        }
        try {
            ByteStringBuffer buffer = new ByteStringBuffer();
            buffer.readFrom(inputStream);
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<String> getValueStringRepresentations(boolean useDefault) {
        List<File> files;
        if (this.values.isEmpty()) {
            if (!useDefault) return Collections.emptyList();
            files = this.defaultValues;
        } else {
            files = this.values;
        }
        if (files == null || files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> valueStrings = new ArrayList<String>(files.size());
        for (File f : files) {
            valueStrings.add(f.getAbsolutePath());
        }
        return Collections.unmodifiableList(valueStrings);
    }

    @Override
    protected boolean hasDefaultValue() {
        return this.defaultValues != null && !this.defaultValues.isEmpty();
    }

    @Override
    @NotNull
    public String getDataTypeName() {
        if (this.mustBeDirectory) {
            return ArgsMessages.INFO_FILE_TYPE_PATH_DIRECTORY.get();
        }
        return ArgsMessages.INFO_FILE_TYPE_PATH_FILE.get();
    }

    @Override
    @NotNull
    public String getValueConstraints() {
        StringBuilder buffer = new StringBuilder();
        if (this.mustBeDirectory) {
            if (this.fileMustExist) {
                buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_DIR_MUST_EXIST.get());
            } else if (this.parentMustExist) {
                buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_DIR_PARENT_MUST_EXIST.get());
            } else {
                buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_DIR_MAY_EXIST.get());
            }
        } else if (this.fileMustExist) {
            buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_FILE_MUST_EXIST.get());
        } else if (this.parentMustExist) {
            buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_FILE_PARENT_MUST_EXIST.get());
        } else {
            buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_FILE_MAY_EXIST.get());
        }
        if (this.relativeBaseDirectory != null) {
            buffer.append("  ");
            buffer.append(ArgsMessages.INFO_FILE_CONSTRAINTS_RELATIVE_PATH_SPECIFIED_ROOT.get(this.relativeBaseDirectory.getAbsolutePath()));
        }
        return buffer.toString();
    }

    @Override
    protected void reset() {
        super.reset();
        this.values.clear();
    }

    @Override
    @NotNull
    public FileArgument getCleanCopy() {
        return new FileArgument(this);
    }

    @Override
    protected void addToCommandLine(@NotNull List<String> argStrings) {
        for (File f : this.values) {
            argStrings.add(this.getIdentifierString());
            if (this.isSensitive()) {
                argStrings.add("***REDACTED***");
                continue;
            }
            argStrings.add(f.getAbsolutePath());
        }
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("FileArgument(");
        this.appendBasicToStringInfo(buffer);
        buffer.append(", fileMustExist=");
        buffer.append(this.fileMustExist);
        buffer.append(", parentMustExist=");
        buffer.append(this.parentMustExist);
        buffer.append(", mustBeFile=");
        buffer.append(this.mustBeFile);
        buffer.append(", mustBeDirectory=");
        buffer.append(this.mustBeDirectory);
        if (this.relativeBaseDirectory != null) {
            buffer.append(", relativeBaseDirectory='");
            buffer.append(this.relativeBaseDirectory.getAbsolutePath());
            buffer.append('\'');
        }
        if (this.defaultValues != null && !this.defaultValues.isEmpty()) {
            if (this.defaultValues.size() == 1) {
                buffer.append(", defaultValue='");
                buffer.append(this.defaultValues.get(0).toString());
            } else {
                buffer.append(", defaultValues={");
                Iterator<File> iterator = this.defaultValues.iterator();
                while (iterator.hasNext()) {
                    buffer.append('\'');
                    buffer.append(iterator.next().toString());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append('}');
            }
        }
        buffer.append(')');
    }
}

