/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.jmap.api.model.DeviceClientIdInvalidException;
import org.apache.james.jmap.api.model.ExpireTimeInvalidException;
import org.apache.james.jmap.api.model.PushSubscriptionCreationRequest;
import org.apache.james.jmap.api.model.PushSubscriptionExpiredTime;
import org.apache.james.jmap.api.model.PushSubscriptionKeys;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionRepository;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.PushSubscriptionCreation$;
import org.apache.james.jmap.core.PushSubscriptionCreationId;
import org.apache.james.jmap.core.PushSubscriptionCreationParseException;
import org.apache.james.jmap.core.PushSubscriptionCreationResponse;
import org.apache.james.jmap.core.PushSubscriptionSetRequest;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.PushSubscriptionSerializer;
import org.apache.james.jmap.method.PushSubscriptionSetCreatePerformer$;
import org.apache.james.jmap.method.PushSubscriptionSetCreatePerformer$CreationResults$;
import org.apache.james.jmap.method.PushSubscriptionSetCreateProcessor;
import org.apache.james.jmap.method.PushVerification;
import org.apache.james.jmap.method.package$;
import org.apache.james.mailbox.MailboxSession;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\r\u0015w!B.]\u0011\u00039g!B5]\u0011\u0003Q\u0007\"B9\u0002\t\u0003\u0011\bbB:\u0002\u0005\u0004%I\u0001\u001e\u0005\u0007w\u0006\u0001\u000b\u0011B;\u0007\u000fq\f\u0001\u0013aI\u0001{\u001a!a0\u0001!\u0000\u0011)\t\u0019C\u0002BK\u0002\u0013\u0005\u0011Q\u0005\u0005\u000b\u0003g1!\u0011#Q\u0001\n\u0005\u001d\u0002BCA\u001b\r\tU\r\u0011\"\u0001\u00028!Q\u0011q\b\u0004\u0003\u0012\u0003\u0006I!!\u000f\t\rE4A\u0011AA!\u0011%\tIEBA\u0001\n\u0003\tY\u0005C\u0005\u0002R\u0019\t\n\u0011\"\u0001\u0002T!I\u0011\u0011\u000e\u0004\u0012\u0002\u0013\u0005\u00111\u000e\u0005\n\u0003_2\u0011\u0011!C!\u0003cB\u0011\"a!\u0007\u0003\u0003%\t!!\"\t\u0013\u00055e!!A\u0005\u0002\u0005=\u0005\"CAN\r\u0005\u0005I\u0011IAO\u0011%\tYKBA\u0001\n\u0003\ti\u000bC\u0005\u00028\u001a\t\t\u0011\"\u0011\u0002:\"I\u0011Q\u0018\u0004\u0002\u0002\u0013\u0005\u0013q\u0018\u0005\n\u0003\u00034\u0011\u0011!C!\u0003\u0007D\u0011\"!2\u0007\u0003\u0003%\t%a2\b\u0013\u0005-\u0017!!A\t\u0002\u00055g\u0001\u0003@\u0002\u0003\u0003E\t!a4\t\rELB\u0011AAt\u0011%\t\t-GA\u0001\n\u000b\n\u0019\rC\u0005\u0002jf\t\t\u0011\"!\u0002l\"I\u0011\u0011_\r\u0002\u0002\u0013\u0005\u00151\u001f\u0005\n\u0005\u000bI\u0012\u0011!C\u0005\u0005\u000f1aAa\u0004\u0002\u0001\nE\u0001BCA\u0012?\tU\r\u0011\"\u0001\u0002&!Q\u00111G\u0010\u0003\u0012\u0003\u0006I!a\n\t\u0015\tMqD!f\u0001\n\u0003\u0011)\u0002\u0003\u0006\u0003\u001e}\u0011\t\u0012)A\u0005\u0005/Aa!]\u0010\u0005\u0002\t}\u0001b\u0002B\u0014?\u0011\u0005!\u0011\u0006\u0005\n\u0003\u0013z\u0012\u0011!C\u0001\u0005cA\u0011\"!\u0015 #\u0003%\t!a\u0015\t\u0013\u0005%t$%A\u0005\u0002\t]\u0002\"CA8?\u0005\u0005I\u0011IA9\u0011%\t\u0019iHA\u0001\n\u0003\t)\tC\u0005\u0002\u000e~\t\t\u0011\"\u0001\u0003<!I\u00111T\u0010\u0002\u0002\u0013\u0005\u0013Q\u0014\u0005\n\u0003W{\u0012\u0011!C\u0001\u0005\u007fA\u0011\"a. \u0003\u0003%\tEa\u0011\t\u0013\u0005uv$!A\u0005B\u0005}\u0006\"CAa?\u0005\u0005I\u0011IAb\u0011%\t)mHA\u0001\n\u0003\u00129eB\u0005\u0003L\u0005\t\t\u0011#\u0001\u0003N\u0019I!qB\u0001\u0002\u0002#\u0005!q\n\u0005\u0007cN\"\tAa\u0015\t\u0013\u0005\u00057'!A\u0005F\u0005\r\u0007\"CAug\u0005\u0005I\u0011\u0011B+\u0011%\t\tpMA\u0001\n\u0003\u0013Y\u0006C\u0005\u0003\u0006M\n\t\u0011\"\u0003\u0003\b\u00191!1M\u0001A\u0005KB!Ba\u001a:\u0005+\u0007I\u0011\u0001B5\u0011)\u0011\t(\u000fB\tB\u0003%!1\u000e\u0005\u0007cf\"\tAa\u001d\t\u000f\te\u0014\b\"\u0001\u0003|!9!qR\u001d\u0005\u0002\tE\u0005\"CA%s\u0005\u0005I\u0011\u0001BL\u0011%\t\t&OI\u0001\n\u0003\u0011Y\nC\u0005\u0002pe\n\t\u0011\"\u0011\u0002r!I\u00111Q\u001d\u0002\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003\u001bK\u0014\u0011!C\u0001\u0005?C\u0011\"a':\u0003\u0003%\t%!(\t\u0013\u0005-\u0016(!A\u0005\u0002\t\r\u0006\"CA\\s\u0005\u0005I\u0011\tBT\u0011%\ti,OA\u0001\n\u0003\ny\fC\u0005\u0002Bf\n\t\u0011\"\u0011\u0002D\"I\u0011QY\u001d\u0002\u0002\u0013\u0005#1V\u0004\n\u0005_\u000b\u0011\u0011!E\u0001\u0005c3\u0011Ba\u0019\u0002\u0003\u0003E\tAa-\t\rE\\E\u0011\u0001B^\u0011%\t\tmSA\u0001\n\u000b\n\u0019\rC\u0005\u0002j.\u000b\t\u0011\"!\u0003>\"I\u0011\u0011_&\u0002\u0002\u0013\u0005%\u0011\u0019\u0005\n\u0005\u000bY\u0015\u0011!C\u0005\u0005\u000f1Q!\u001b/\u0001\u0005\u000fD!B!3R\u0005\u0003\u0005\u000b\u0011\u0002Bf\u0011)\u0011Y.\u0015B\u0001B\u0003%!Q\u001c\u0005\u000b\u0005S\f&\u0011!Q\u0001\n\t-\bBB9R\t\u0003\u0011\t\u0010C\u0004\u0004\u000eE#\taa\u0004\t\u000f\r]\u0013\u000b\"\u0003\u0004Z!91QB)\u0005\n\r-\u0005bBBL#\u0012%1\u0011\u0014\u0005\b\u0007S\u000bF\u0011BBV\u0003\t\u0002Vo\u001d5Tk\n\u001c8M]5qi&|gnU3u\u0007J,\u0017\r^3QKJ4wN]7fe*\u0011QLX\u0001\u0007[\u0016$\bn\u001c3\u000b\u0005}\u0003\u0017\u0001\u00026nCBT!!\u00192\u0002\u000b)\fW.Z:\u000b\u0005\r$\u0017AB1qC\u000eDWMC\u0001f\u0003\ry'oZ\u0002\u0001!\tA\u0017!D\u0001]\u0005\t\u0002Vo\u001d5Tk\n\u001c8M]5qi&|gnU3u\u0007J,\u0017\r^3QKJ4wN]7feN\u0011\u0011a\u001b\t\u0003Y>l\u0011!\u001c\u0006\u0002]\u0006)1oY1mC&\u0011\u0001/\u001c\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0017A\u0002'P\u000f\u001e+%+F\u0001v!\t1\u00180D\u0001x\u0015\tAH-A\u0003tY\u001a$$.\u0003\u0002{o\n1Aj\\4hKJ\fq\u0001T(H\u000f\u0016\u0013\u0006E\u0001\bDe\u0016\fG/[8o%\u0016\u001cX\u000f\u001c;\u0014\u0005\u0015Y'aD\"sK\u0006$\u0018n\u001c8Tk\u000e\u001cWm]:\u0014\u0011\u0019Y\u0017\u0011AA\u0003\u0003\u0017\u00012!a\u0001\u0006\u001b\u0005\t\u0001c\u00017\u0002\b%\u0019\u0011\u0011B7\u0003\u000fA\u0013x\u000eZ;diB!\u0011QBA\u000f\u001d\u0011\ty!!\u0007\u000f\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006g\u0003\u0019a$o\\8u}%\ta.C\u0002\u0002\u001c5\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002 \u0005\u0005\"\u0001D*fe&\fG.\u001b>bE2,'bAA\u000e[\u0006A1\r\\5f]RLE-\u0006\u0002\u0002(A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.y\u000bAaY8sK&!\u0011\u0011GA\u0016\u0005i\u0001Vo\u001d5Tk\n\u001c8M]5qi&|gn\u0011:fCRLwN\\%e\u0003%\u0019G.[3oi&#\u0007%\u0001\u0005sKN\u0004xN\\:f+\t\tI\u0004\u0005\u0003\u0002*\u0005m\u0012\u0002BA\u001f\u0003W\u0011\u0001\u0005U;tQN+(m]2sSB$\u0018n\u001c8De\u0016\fG/[8o%\u0016\u001c\bo\u001c8tK\u0006I!/Z:q_:\u001cX\r\t\u000b\u0007\u0003\u0007\n)%a\u0012\u0011\u0007\u0005\ra\u0001C\u0004\u0002$-\u0001\r!a\n\t\u000f\u0005U2\u00021\u0001\u0002:\u0005!1m\u001c9z)\u0019\t\u0019%!\u0014\u0002P!I\u00111\u0005\u0007\u0011\u0002\u0003\u0007\u0011q\u0005\u0005\n\u0003ka\u0001\u0013!a\u0001\u0003s\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002V)\"\u0011qEA,W\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0015TBAA/\u0015\u0011\ty&!\u0019\u0002\u0013Ut7\r[3dW\u0016$'bAA2[\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0014Q\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003[RC!!\u000f\u0002X\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u001d\u0011\t\u0005U\u0014qP\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005!A.\u00198h\u0015\t\ti(\u0001\u0003kCZ\f\u0017\u0002BAA\u0003o\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAD!\ra\u0017\u0011R\u0005\u0004\u0003\u0017k'aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAI\u0003/\u00032\u0001\\AJ\u0013\r\t)*\u001c\u0002\u0004\u0003:L\b\"CAM#\u0005\u0005\t\u0019AAD\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0014\t\u0007\u0003C\u000b9+!%\u000e\u0005\u0005\r&bAAS[\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00161\u0015\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00020\u0006U\u0006c\u00017\u00022&\u0019\u00111W7\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011T\n\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002t\u0005m\u0006\"CAM)\u0005\u0005\t\u0019AAD\u0003!A\u0017m\u001d5D_\u0012,GCAAD\u0003!!xn\u0015;sS:<GCAA:\u0003\u0019)\u0017/^1mgR!\u0011qVAe\u0011%\tIjFA\u0001\u0002\u0004\t\t*A\bDe\u0016\fG/[8o'V\u001c7-Z:t!\r\t\u0019!G\n\u00063\u0005E\u0017Q\u001c\t\u000b\u0003'\fI.a\n\u0002:\u0005\rSBAAk\u0015\r\t9.\\\u0001\beVtG/[7f\u0013\u0011\tY.!6\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002`\u0006\u0015XBAAq\u0015\u0011\t\u0019/a\u001f\u0002\u0005%|\u0017\u0002BA\u0010\u0003C$\"!!4\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005\r\u0013Q^Ax\u0011\u001d\t\u0019\u0003\ba\u0001\u0003OAq!!\u000e\u001d\u0001\u0004\tI$A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005U(\u0011\u0001\t\u0006Y\u0006]\u00181`\u0005\u0004\u0003sl'AB(qi&|g\u000eE\u0004m\u0003{\f9#!\u000f\n\u0007\u0005}XN\u0001\u0004UkBdWM\r\u0005\n\u0005\u0007i\u0012\u0011!a\u0001\u0003\u0007\n1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011I\u0001\u0005\u0003\u0002v\t-\u0011\u0002\u0002B\u0007\u0003o\u0012aa\u00142kK\u000e$(aD\"sK\u0006$\u0018n\u001c8GC&dWO]3\u0014\u0011}Y\u0017\u0011AA\u0003\u0003\u0017\t\u0011!Z\u000b\u0003\u0005/\u0001B!!\u0004\u0003\u001a%!!1DA\u0011\u0005%!\u0006N]8xC\ndW-\u0001\u0002fAQ1!\u0011\u0005B\u0012\u0005K\u00012!a\u0001 \u0011\u001d\t\u0019\u0003\na\u0001\u0003OAqAa\u0005%\u0001\u0004\u00119\"A\tbg6+7o]1hKN+G/\u0012:s_J,\"Aa\u000b\u0011\t\u0005%\"QF\u0005\u0005\u0005_\tYC\u0001\u0005TKR,%O]8s)\u0019\u0011\tCa\r\u00036!I\u00111\u0005\u0014\u0011\u0002\u0003\u0007\u0011q\u0005\u0005\n\u0005'1\u0003\u0013!a\u0001\u0005/)\"A!\u000f+\t\t]\u0011q\u000b\u000b\u0005\u0003#\u0013i\u0004C\u0005\u0002\u001a.\n\t\u00111\u0001\u0002\bR!\u0011q\u0016B!\u0011%\tI*LA\u0001\u0002\u0004\t\t\n\u0006\u0003\u0002t\t\u0015\u0003\"CAM]\u0005\u0005\t\u0019AAD)\u0011\tyK!\u0013\t\u0013\u0005e\u0015'!AA\u0002\u0005E\u0015aD\"sK\u0006$\u0018n\u001c8GC&dWO]3\u0011\u0007\u0005\r1gE\u00034\u0005#\ni\u000e\u0005\u0006\u0002T\u0006e\u0017q\u0005B\f\u0005C!\"A!\u0014\u0015\r\t\u0005\"q\u000bB-\u0011\u001d\t\u0019C\u000ea\u0001\u0003OAqAa\u00057\u0001\u0004\u00119\u0002\u0006\u0003\u0003^\t\u0005\u0004#\u00027\u0002x\n}\u0003c\u00027\u0002~\u0006\u001d\"q\u0003\u0005\n\u0005\u00079\u0014\u0011!a\u0001\u0005C\u0011qb\u0011:fCRLwN\u001c*fgVdGo]\n\u0007s-\f)!a\u0003\u0002\u000fI,7/\u001e7ugV\u0011!1\u000e\t\u0007\u0003\u001b\u0011i'!\u0001\n\t\t=\u0014\u0011\u0005\u0002\u0004'\u0016\f\u0018\u0001\u0003:fgVdGo\u001d\u0011\u0015\t\tU$q\u000f\t\u0004\u0003\u0007I\u0004b\u0002B4y\u0001\u0007!1N\u0001\bGJ,\u0017\r^3e+\t\u0011i\bE\u0003m\u0003o\u0014y\b\u0005\u0005\u0003\u0002\n%\u0015qEA\u001d\u001d\u0011\u0011\u0019I!\"\u0011\u0007\u0005EQ.C\u0002\u0003\b6\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002BF\u0005\u001b\u00131!T1q\u0015\r\u00119)\\\u0001\u000b]>$8I]3bi\u0016$WC\u0001BJ!\u0015a\u0017q\u001fBK!!\u0011\tI!#\u0002(\t-B\u0003\u0002B;\u00053C\u0011Ba\u001a@!\u0003\u0005\rAa\u001b\u0016\u0005\tu%\u0006\u0002B6\u0003/\"B!!%\u0003\"\"I\u0011\u0011T\"\u0002\u0002\u0003\u0007\u0011q\u0011\u000b\u0005\u0003_\u0013)\u000bC\u0005\u0002\u001a\u0016\u000b\t\u00111\u0001\u0002\u0012R!\u00111\u000fBU\u0011%\tIJRA\u0001\u0002\u0004\t9\t\u0006\u0003\u00020\n5\u0006\"CAM\u0013\u0006\u0005\t\u0019AAI\u0003=\u0019%/Z1uS>t'+Z:vYR\u001c\bcAA\u0002\u0017N)1J!.\u0002^BA\u00111\u001bB\\\u0005W\u0012)(\u0003\u0003\u0003:\u0006U'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011!\u0011\u0017\u000b\u0005\u0005k\u0012y\fC\u0004\u0003h9\u0003\rAa\u001b\u0015\t\t\r'Q\u0019\t\u0006Y\u0006](1\u000e\u0005\n\u0005\u0007y\u0015\u0011!a\u0001\u0005k\u001a\"!U6\u00025A,8\u000f[*vEN\u001c'/\u001b9uS>t'+\u001a9pg&$xN]=\u0011\t\t5'q[\u0007\u0003\u0005\u001fTAA!5\u0003T\u0006\u0001\u0002/^:igV\u00147o\u0019:jaRLwN\u001c\u0006\u0004\u0005+t\u0016aA1qS&!!\u0011\u001cBh\u0005i\u0001Vo\u001d5Tk\n\u001c8M]5qi&|gNU3q_NLGo\u001c:z\u0003i\u0001Xo\u001d5Tk\n\u001c8M]5qi&|gnU3sS\u0006d\u0017N_3s!\u0011\u0011yN!:\u000e\u0005\t\u0005(b\u0001Br=\u0006!!n]8o\u0013\u0011\u00119O!9\u00035A+8\u000f[*vEN\u001c'/\u001b9uS>t7+\u001a:jC2L'0\u001a:\u00027Y,'/\u001b4jG\u0006$\u0018n\u001c8De\u0016\fG/\u001a)s_\u000e,7o]8s!\rA'Q^\u0005\u0004\u0005_d&A\t)vg\"\u001cVOY:de&\u0004H/[8o'\u0016$8I]3bi\u0016\u0004&o\\2fgN|'\u000f\u0006\u0005\u0003t\nU(q\u001fB}!\tA\u0017\u000bC\u0004\u0003JV\u0003\rAa3\t\u000f\tmW\u000b1\u0001\u0003^\"9!\u0011^+A\u0002\t-\bfA+\u0003~B!!q`B\u0005\u001b\t\u0019\tA\u0003\u0003\u0004\u0004\r\u0015\u0011AB5oU\u0016\u001cGO\u0003\u0002\u0004\b\u00059!.Y6beR\f\u0017\u0002BB\u0006\u0007\u0003\u0011a!\u00138kK\u000e$\u0018AB2sK\u0006$X\r\u0006\u0004\u0004\u0012\ru2q\t\t\u0007\u0007'\u0019\tc!\n\u000e\u0005\rU!\u0002BB\f\u00073\t\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u00079\u001cYB\u0003\u0003\u0002.\ru!BAB\u0010\u0003\u001d\u0011X-Y2u_JLAaa\t\u0004\u0016\t)1+T8o_B\u00191qE\u001d\u000f\u0007\r%\u0002A\u0004\u0003\u0004,\rmb\u0002BB\u0017\u0007sqAaa\f\u000489!1\u0011GB\u001b\u001d\u0011\t\tba\r\n\u0003\u0015L!a\u00193\n\u0005\u0005\u0014\u0017BA0a\u0013\tif\fC\u0004\u0004@Y\u0003\ra!\u0011\u0002\u000fI,\u0017/^3tiB!\u0011\u0011FB\"\u0013\u0011\u0019)%a\u000b\u00035A+8\u000f[*vEN\u001c'/\u001b9uS>t7+\u001a;SKF,Xm\u001d;\t\u000f\r%c\u000b1\u0001\u0004L\u0005qQ.Y5mE>D8+Z:tS>t\u0007\u0003BB'\u0007'j!aa\u0014\u000b\u0007\rE\u0003-A\u0004nC&d'm\u001c=\n\t\rU3q\n\u0002\u000f\u001b\u0006LGNY8y'\u0016\u001c8/[8o\u0003-\u0001\u0018M]:f\u0007J,\u0017\r^3\u0015\t\rm31\u000f\t\t\u0003\u001b\u0019if!\u0019\u0004h%!1qLA\u0011\u0005\u0019)\u0015\u000e\u001e5feB!\u0011QBB2\u0013\u0011\u0019)'!\t\u0003\u0013\u0015C8-\u001a9uS>t\u0007\u0003BB5\u0007_j!aa\u001b\u000b\t\r5$1[\u0001\u0006[>$W\r\\\u0005\u0005\u0007c\u001aYGA\u0010QkND7+\u001e2tGJL\u0007\u000f^5p]\u000e\u0013X-\u0019;j_:\u0014V-];fgRDqa!\u001eX\u0001\u0004\u00199(\u0001\u0005kg>\u0013'.Z2u!\u0011\u0019Iha\"\u000e\u0005\rm$\u0002\u0002Br\u0007{RAaa \u0004\u0002\u0006!A.\u001b2t\u0015\u0011\u0011)na!\u000b\u0005\r\u0015\u0015\u0001\u00029mCfLAa!#\u0004|\tA!j](cU\u0016\u001cG\u000f\u0006\u0005\u0004\u000e\u000eE51SBK!\u0019\u0019\u0019b!\t\u0004\u0010B\u00191qE\u0003\t\u000f\u0005\r\u0002\f1\u0001\u0002(!91q\b-A\u0002\r\u001d\u0004bBB%1\u0002\u000711J\u0001\fg\"|w/\u0012=qSJ,7\u000f\u0006\u0004\u0004\u001c\u000e\r6q\u0015\t\u0006Y\u0006]8Q\u0014\t\u0005\u0007S\u001ay*\u0003\u0003\u0004\"\u000e-$a\u0007)vg\"\u001cVOY:de&\u0004H/[8o\u000bb\u0004\u0018N]3e)&lW\rC\u0004\u0004&f\u0003\ra!(\u0002\u000f\u0015D\b/\u001b:fg\"91qH-A\u0002\r\u001d\u0014\u0001\u00079vg\"\u001cVOY:de&\u0004H/[8o'\u0016$XI\u001d:peR!!1FBW\u0011\u001d\u0019yK\u0017a\u0001\u0007c\u000ba!\u001a:s_J\u001c\bCBAQ\u0007g\u001b),\u0003\u0003\u0003p\u0005\r\u0006c\u00027\u0002~\u000e]6Q\u0018\t\u0005\u0007s\u001aI,\u0003\u0003\u0004<\u000em$A\u0002&t!\u0006$\b\u000e\u0005\u0004\u0002\"\u000eM6q\u0018\t\u0005\u0007s\u001a\t-\u0003\u0003\u0004D\u000em$a\u0005&t_:4\u0016\r\\5eCRLwN\\#se>\u0014\b")
public class PushSubscriptionSetCreatePerformer {
    private final PushSubscriptionRepository pushSubscriptionRepository;
    private final PushSubscriptionSerializer pushSubscriptionSerializer;
    private final PushSubscriptionSetCreateProcessor verificationCreateProcessor;

    public SMono<CreationResults> create(PushSubscriptionSetRequest request, MailboxSession mailboxSession) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)request.create().getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                PushSubscriptionCreationId clientId = (PushSubscriptionCreationId)tuple2._1();
                JsObject json = (JsObject)tuple2._2();
                return (SMono)this.parseCreate(json).fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, (Throwable)e)), (Function1 & Serializable)creationRequest -> this.create(clientId, (PushSubscriptionCreationRequest)creationRequest, mailboxSession));
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = qual$1.concatMap$default$2();
        return qual$1.concatMap((Function1)x$1, x$2).collectSeq().map((Function1)PushSubscriptionSetCreatePerformer$CreationResults$.MODULE$);
    }

    private Either<Exception, PushSubscriptionCreationRequest> parseCreate(JsObject jsObject) {
        return PushSubscriptionCreation$.MODULE$.validateProperties(jsObject).flatMap((Function1 & Serializable)validJsObject -> $this.pushSubscriptionSerializer.deserializePushSubscriptionCreationRequest((JsValue)validJsObject).asEither().left().map((Function1 & Serializable)errors -> new PushSubscriptionCreationParseException(this.pushSubscriptionSetError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)errors))).flatMap((Function1 & Serializable)parsedRequest -> parsedRequest.validate().left().map((Function1 & Serializable)e -> new PushSubscriptionCreationParseException(SetError$.MODULE$.invalidArguments(e.getMessage(), SetError$.MODULE$.invalidArguments$default$2()))).map((Function1 & Serializable)validatedRequest -> validatedRequest)));
    }

    private SMono<CreationResult> create(PushSubscriptionCreationId clientId, PushSubscriptionCreationRequest request, MailboxSession mailboxSession) {
        return SMono$.MODULE$.fromPublisher(this.pushSubscriptionRepository.save(mailboxSession.getUser(), request)).flatMap((Function1 & Serializable)subscription -> $this.verificationCreateProcessor.pushVerificationToPushServer(subscription.url(), new PushVerification(subscription.id(), subscription.verificationCode()), (Option<PushSubscriptionKeys>)request.keys()).onErrorResume((Function1 & Serializable)error -> SMono$.MODULE$.fromPublisher($this.pushSubscriptionRepository.revoke(mailboxSession.getUser(), subscription.id())).then(SMono$.MODULE$.error(error))).then(SMono$.MODULE$.just(subscription))).map((Function1 & Serializable)subscription -> new CreationSuccess(clientId, new PushSubscriptionCreationResponse(subscription.id(), this.showExpires(subscription.expires(), request)))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new CreationFailure(clientId, (Throwable)e)));
    }

    private Option<PushSubscriptionExpiredTime> showExpires(PushSubscriptionExpiredTime expires, PushSubscriptionCreationRequest request) {
        Some some;
        PushSubscriptionExpiredTime requestExpires;
        Option option = request.expires();
        if (option instanceof Some && expires == (requestExpires = (PushSubscriptionExpiredTime)(some = (Some)option).value())) {
            return None$.MODULE$;
        }
        return new Some((Object)expires);
    }

    private SetError pushSubscriptionSetError(Seq<Tuple2<JsPath, Seq<JsonValidationError>>> errors) {
        return package$.MODULE$.standardError(errors);
    }

    @Inject
    public PushSubscriptionSetCreatePerformer(PushSubscriptionRepository pushSubscriptionRepository, PushSubscriptionSerializer pushSubscriptionSerializer, PushSubscriptionSetCreateProcessor verificationCreateProcessor) {
        this.pushSubscriptionRepository = pushSubscriptionRepository;
        this.pushSubscriptionSerializer = pushSubscriptionSerializer;
        this.verificationCreateProcessor = verificationCreateProcessor;
    }

    public static class CreationFailure
    implements CreationResult,
    Product,
    Serializable {
        private final PushSubscriptionCreationId clientId;
        private final Throwable e;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public PushSubscriptionCreationId clientId() {
            return this.clientId;
        }

        public Throwable e() {
            return this.e;
        }

        public SetError asMessageSetError() {
            Throwable throwable = this.e();
            if (throwable instanceof PushSubscriptionCreationParseException) {
                PushSubscriptionCreationParseException pushSubscriptionCreationParseException = (PushSubscriptionCreationParseException)throwable;
                PushSubscriptionSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$PushSubscriptionSetCreatePerformer$$LOGGER().info("Failure to parse PushSubscription/set create", (Throwable)pushSubscriptionCreationParseException);
                return pushSubscriptionCreationParseException.setError();
            }
            if (throwable instanceof ExpireTimeInvalidException) {
                ExpireTimeInvalidException expireTimeInvalidException = (ExpireTimeInvalidException)throwable;
                PushSubscriptionSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$PushSubscriptionSetCreatePerformer$$LOGGER().info("Invalid time expiracy for push subscription: {}", (Object)expireTimeInvalidException.getMessage());
                return SetError$.MODULE$.invalidArguments(expireTimeInvalidException.getMessage(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((scala.collection.immutable.Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"expires")).value()))}))));
            }
            if (throwable instanceof DeviceClientIdInvalidException) {
                DeviceClientIdInvalidException deviceClientIdInvalidException = (DeviceClientIdInvalidException)throwable;
                PushSubscriptionSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$PushSubscriptionSetCreatePerformer$$LOGGER().info("Invalid deviceId for push subscription: {}", (Object)deviceClientIdInvalidException.getMessage());
                return SetError$.MODULE$.invalidArguments(deviceClientIdInvalidException.getMessage(), SetError$.MODULE$.invalidArguments$default$2());
            }
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                PushSubscriptionSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$PushSubscriptionSetCreatePerformer$$LOGGER().info("Illegal argument in PushSubscription/set create", (Throwable)illegalArgumentException);
                return SetError$.MODULE$.invalidArguments(illegalArgumentException.getMessage(), SetError$.MODULE$.invalidArguments$default$2());
            }
            PushSubscriptionSetCreatePerformer$.MODULE$.org$apache$james$jmap$method$PushSubscriptionSetCreatePerformer$$LOGGER().error("Failed to create push subscription", throwable);
            return SetError$.MODULE$.serverFail(throwable.getMessage());
        }

        public CreationFailure copy(PushSubscriptionCreationId clientId, Throwable e) {
            return new CreationFailure(clientId, e);
        }

        public PushSubscriptionCreationId copy$default$1() {
            return this.clientId();
        }

        public Throwable copy$default$2() {
            return this.e();
        }

        public String productPrefix() {
            return "CreationFailure";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.clientId();
                }
                case 1: {
                    return this.e();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "clientId";
                }
                case 1: {
                    return "e";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationFailure creationFailure = (CreationFailure)x$1;
            PushSubscriptionCreationId pushSubscriptionCreationId = this.clientId();
            PushSubscriptionCreationId pushSubscriptionCreationId2 = creationFailure.clientId();
            if (pushSubscriptionCreationId == null) {
                if (pushSubscriptionCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)pushSubscriptionCreationId).equals(pushSubscriptionCreationId2)) return false;
            Throwable throwable = this.e();
            Throwable throwable2 = creationFailure.e();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!creationFailure.canEqual(this)) return false;
            return true;
        }

        public CreationFailure(PushSubscriptionCreationId clientId, Throwable e) {
            this.clientId = clientId;
            this.e = e;
            Product.$init$((Product)this);
        }
    }

    public static interface CreationResult {
    }

    public static class CreationResults
    implements Product,
    Serializable {
        private final scala.collection.immutable.Seq<CreationResult> results;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public scala.collection.immutable.Seq<CreationResult> results() {
            return this.results;
        }

        public Option<Map<PushSubscriptionCreationId, PushSubscriptionCreationResponse>> created() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                CreationResult creationResult = x0$1;
                if (creationResult instanceof CreationSuccess) {
                    CreationSuccess creationSuccess = (CreationSuccess)creationResult;
                    return new Some((Object)new Tuple2((Object)creationSuccess.clientId(), (Object)creationSuccess.response()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()));
        }

        public Option<Map<PushSubscriptionCreationId, SetError>> notCreated() {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)this.results().flatMap((Function1 & Serializable)x0$1 -> {
                CreationResult creationResult = x0$1;
                if (creationResult instanceof CreationFailure) {
                    CreationFailure creationFailure = (CreationFailure)creationResult;
                    return new Some((Object)new Tuple2((Object)creationFailure.clientId(), (Object)creationFailure.asMessageSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.nonEmpty()));
        }

        public CreationResults copy(scala.collection.immutable.Seq<CreationResult> results) {
            return new CreationResults(results);
        }

        public scala.collection.immutable.Seq<CreationResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "CreationResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationResults creationResults = (CreationResults)x$1;
            scala.collection.immutable.Seq<CreationResult> seq = this.results();
            scala.collection.immutable.Seq<CreationResult> seq2 = creationResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!creationResults.canEqual(this)) return false;
            return true;
        }

        public CreationResults(scala.collection.immutable.Seq<CreationResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class CreationSuccess
    implements CreationResult,
    Product,
    Serializable {
        private final PushSubscriptionCreationId clientId;
        private final PushSubscriptionCreationResponse response;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public PushSubscriptionCreationId clientId() {
            return this.clientId;
        }

        public PushSubscriptionCreationResponse response() {
            return this.response;
        }

        public CreationSuccess copy(PushSubscriptionCreationId clientId, PushSubscriptionCreationResponse response) {
            return new CreationSuccess(clientId, response);
        }

        public PushSubscriptionCreationId copy$default$1() {
            return this.clientId();
        }

        public PushSubscriptionCreationResponse copy$default$2() {
            return this.response();
        }

        public String productPrefix() {
            return "CreationSuccess";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.clientId();
                }
                case 1: {
                    return this.response();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CreationSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "clientId";
                }
                case 1: {
                    return "response";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CreationSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            CreationSuccess creationSuccess = (CreationSuccess)x$1;
            PushSubscriptionCreationId pushSubscriptionCreationId = this.clientId();
            PushSubscriptionCreationId pushSubscriptionCreationId2 = creationSuccess.clientId();
            if (pushSubscriptionCreationId == null) {
                if (pushSubscriptionCreationId2 != null) {
                    return false;
                }
            } else if (!((Object)pushSubscriptionCreationId).equals(pushSubscriptionCreationId2)) return false;
            PushSubscriptionCreationResponse pushSubscriptionCreationResponse = this.response();
            PushSubscriptionCreationResponse pushSubscriptionCreationResponse2 = creationSuccess.response();
            if (pushSubscriptionCreationResponse == null) {
                if (pushSubscriptionCreationResponse2 != null) {
                    return false;
                }
            } else if (!((Object)pushSubscriptionCreationResponse).equals(pushSubscriptionCreationResponse2)) return false;
            if (!creationSuccess.canEqual(this)) return false;
            return true;
        }

        public CreationSuccess(PushSubscriptionCreationId clientId, PushSubscriptionCreationResponse response) {
            this.clientId = clientId;
            this.response = response;
            Product.$init$((Product)this);
        }
    }
}

