/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import jakarta.inject.Inject;
import org.apache.james.backends.cassandra.migration.CassandraMigrationService;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.dto.CassandraVersionRequest;
import org.apache.james.webadmin.dto.CassandraVersionResponse;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.ResponseTransformer;
import spark.Service;

public class CassandraMigrationRoutes
implements Routes {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraMigrationRoutes.class);
    public static final String VERSION_BASE = "/cassandra/version";
    private static final String VERSION_BASE_LATEST = "/cassandra/version/latest";
    private static final String VERSION_UPGRADE_BASE = "/cassandra/version/upgrade";
    private static final String VERSION_UPGRADE_TO_LATEST_BASE = "/cassandra/version/upgrade/latest";
    public static final String MIGRATION_REQUEST_CAN_NOT_BE_DONE = "The migration requested can not be performed";
    private final CassandraMigrationService cassandraMigrationService;
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;

    @Inject
    public CassandraMigrationRoutes(CassandraMigrationService cassandraMigrationService, TaskManager taskManager, JsonTransformer jsonTransformer) {
        this.cassandraMigrationService = cassandraMigrationService;
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return VERSION_BASE;
    }

    public void define(Service service) {
        service.get(VERSION_BASE, (request, response) -> this.getCassandraCurrentVersion(), (ResponseTransformer)this.jsonTransformer);
        service.get(VERSION_BASE_LATEST, (request, response) -> this.getCassandraLatestVersion(), (ResponseTransformer)this.jsonTransformer);
        TaskFromRequest upgradeToVersionTaskFromRequest = this::upgradeToVersion;
        service.post(VERSION_UPGRADE_BASE, upgradeToVersionTaskFromRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
        TaskFromRequest upgradeToLatestTaskFromRequest = request -> this.upgradeToLatest();
        service.post(VERSION_UPGRADE_TO_LATEST_BASE, upgradeToLatestTaskFromRequest.asRoute(this.taskManager), (ResponseTransformer)this.jsonTransformer);
    }

    public Task upgradeToLatest() {
        try {
            return this.cassandraMigrationService.upgradeToLastVersion();
        }
        catch (IllegalStateException e) {
            LOGGER.info(MIGRATION_REQUEST_CAN_NOT_BE_DONE, (Throwable)e);
            throw ErrorResponder.builder().statusCode(409).type(ErrorResponder.ErrorType.WRONG_STATE).message(MIGRATION_REQUEST_CAN_NOT_BE_DONE).cause((Exception)e).haltError();
        }
    }

    public Task upgradeToVersion(Request request) {
        LOGGER.debug("Cassandra upgrade launched");
        CassandraVersionRequest cassandraVersionRequest = CassandraVersionRequest.parse(request.body());
        return this.cassandraMigrationService.upgradeToVersion(cassandraVersionRequest.getValue());
    }

    public CassandraVersionResponse getCassandraLatestVersion() {
        return CassandraVersionResponse.from(this.cassandraMigrationService.getLatestVersion());
    }

    public CassandraVersionResponse getCassandraCurrentVersion() {
        return CassandraVersionResponse.from(this.cassandraMigrationService.getCurrentVersion());
    }
}

