/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.netty.handler.ssl.SslContext;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.postgresql.util.Assert;
import java.net.SocketAddress;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import reactor.util.annotation.Nullable;

public final class SSLConfig {
    @Nullable
    private final HostnameVerifier hostnameVerifier;
    private final SSLMode sslMode;
    @Nullable
    private final Supplier<SslContext> sslProvider;
    private final Function<SSLEngine, SSLEngine> sslEngineCustomizer;
    private final Function<SocketAddress, SSLParameters> sslParametersFactory;

    public SSLConfig(SSLMode sslMode, @Nullable Supplier<SslContext> sslProvider, @Nullable HostnameVerifier hostnameVerifier) {
        this(sslMode, sslProvider, Function.identity(), it -> new SSLParameters(), hostnameVerifier);
    }

    public SSLConfig(SSLMode sslMode, @Nullable Supplier<SslContext> sslProvider, Function<SSLEngine, SSLEngine> sslEngineCustomizer, Function<SocketAddress, SSLParameters> sslParametersFactory, @Nullable HostnameVerifier hostnameVerifier) {
        if (sslMode != SSLMode.DISABLE) {
            Assert.requireNonNull(sslProvider, "SslContext provider is required for ssl mode " + (Object)((Object)sslMode));
        }
        if (sslMode.verifyPeerName()) {
            Assert.requireNonNull(hostnameVerifier, "Hostname verifier is required for ssl mode verify-full");
        }
        this.sslMode = sslMode;
        this.sslProvider = sslProvider;
        this.sslEngineCustomizer = sslEngineCustomizer;
        this.sslParametersFactory = sslParametersFactory;
        this.hostnameVerifier = hostnameVerifier;
    }

    public static SSLConfig disabled() {
        return new SSLConfig(SSLMode.DISABLE, null, (hostname, session) -> true);
    }

    HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public SSLMode getSslMode() {
        return this.sslMode;
    }

    public Supplier<SslContext> getSslProvider() {
        if (this.sslProvider == null) {
            throw new IllegalStateException("SSL Mode disabled. SslContext provider not available");
        }
        return this.sslProvider;
    }

    public Function<SSLEngine, SSLEngine> getSslEngineCustomizer() {
        return this.sslEngineCustomizer;
    }

    public Function<SocketAddress, SSLParameters> getSslParametersFactory() {
        return this.sslParametersFactory;
    }

    public SSLConfig mutateMode(SSLMode newMode) {
        return new SSLConfig(newMode, this.sslProvider, this.sslEngineCustomizer, this.sslParametersFactory, this.hostnameVerifier);
    }

    public static boolean isValidSniHostname(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (SSLConfig.isLabelSeparator(c) || !SSLConfig.isNonLDHAsciiCodePoint(c)) continue;
            return false;
        }
        return !input.endsWith(".");
    }

    private static boolean isNonLDHAsciiCodePoint(char ch) {
        return '\u0000' <= ch && ch <= ',' || '.' <= ch && ch <= '/' || ':' <= ch && ch <= '@' || '[' <= ch && ch <= '`' || '{' <= ch && ch <= '\u007f';
    }

    private static boolean isLabelSeparator(char c) {
        return c == '.' || c == '\u3002' || c == '\uff0e' || c == '\uff61';
    }
}

