/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.change;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.util.DurationParser;

public class CassandraChangesConfiguration {
    public static final Duration DEFAULT_TTL = Duration.ofDays(60L);
    public static final CassandraChangesConfiguration DEFAULT = CassandraChangesConfiguration.builder().build();
    private final Duration emailChangeTtl;
    private final Duration mailboxChangeTtl;

    public static Builder builder() {
        return new Builder();
    }

    public static CassandraChangesConfiguration from(Configuration configuration) {
        Optional<Duration> emailChangeTtl = Optional.ofNullable(configuration.getString("email.change.ttl", null)).map(value -> DurationParser.parse((String)value, (ChronoUnit)ChronoUnit.SECONDS));
        Optional<Duration> mailboxChangeTtl = Optional.ofNullable(configuration.getString("mailbox.change.ttl", null)).map(value -> DurationParser.parse((String)value, (ChronoUnit)ChronoUnit.SECONDS));
        return new Builder().emailChangeTtl(emailChangeTtl).mailboxChangeTtl(mailboxChangeTtl).build();
    }

    private CassandraChangesConfiguration(Duration emailChangeTtl, Duration mailboxChangeTtl) {
        Preconditions.checkArgument((emailChangeTtl.getSeconds() >= 0L ? 1 : 0) != 0, (Object)"'TTL' needs to be positive");
        Preconditions.checkArgument((emailChangeTtl.getSeconds() < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"'TTL' must not greater than %s sec", (int)Integer.MAX_VALUE);
        Preconditions.checkArgument((mailboxChangeTtl.getSeconds() >= 0L ? 1 : 0) != 0, (Object)"'TTL' needs to be positive");
        Preconditions.checkArgument((mailboxChangeTtl.getSeconds() < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"'TTL' must not greater than %s sec", (int)Integer.MAX_VALUE);
        this.emailChangeTtl = emailChangeTtl;
        this.mailboxChangeTtl = mailboxChangeTtl;
    }

    public Duration getEmailChangeTtl() {
        return this.emailChangeTtl;
    }

    public Duration getMailboxChangeTtl() {
        return this.mailboxChangeTtl;
    }

    public final boolean equals(Object o) {
        if (o instanceof CassandraChangesConfiguration) {
            CassandraChangesConfiguration that = (CassandraChangesConfiguration)o;
            return Objects.equals(this.emailChangeTtl, that.emailChangeTtl) && Objects.equals(this.mailboxChangeTtl, that.mailboxChangeTtl);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.emailChangeTtl, this.mailboxChangeTtl);
    }

    public static class Builder {
        private Optional<Duration> emailChangeTtl = Optional.empty();
        private Optional<Duration> mailboxChangeTtl = Optional.empty();

        public Builder emailChangeTtl(Duration emailChangeTtl) {
            this.emailChangeTtl = Optional.of(emailChangeTtl);
            return this;
        }

        public Builder emailChangeTtl(Optional<Duration> emailChangeTtl) {
            emailChangeTtl.ifPresent(this::emailChangeTtl);
            return this;
        }

        public Builder mailboxChangeTtl(Duration mailboxChangeTtl) {
            this.mailboxChangeTtl = Optional.of(mailboxChangeTtl);
            return this;
        }

        public Builder mailboxChangeTtl(Optional<Duration> mailboxChangeTtl) {
            mailboxChangeTtl.ifPresent(this::mailboxChangeTtl);
            return this;
        }

        public CassandraChangesConfiguration build() {
            return new CassandraChangesConfiguration(this.emailChangeTtl.orElse(DEFAULT_TTL), this.mailboxChangeTtl.orElse(DEFAULT_TTL));
        }
    }
}

