/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.json;

import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpSerializer;

public abstract class JsonpMapperBase
implements JsonpMapper {
    @Nullable
    private Map<String, Object> attributes;

    protected JsonpMapperBase() {
    }

    protected JsonpMapperBase(JsonpMapperBase o) {
        this.attributes = o.attributes;
    }

    @Override
    public <T> T attribute(String name) {
        return (T)(this.attributes == null ? null : this.attributes.get(name));
    }

    protected JsonpMapperBase addAttribute(String name, Object value) {
        if (this.attributes == null) {
            if (value != null) {
                this.attributes = Collections.singletonMap(name, value);
            }
            return this;
        }
        Object existingValue = this.attributes.get(name);
        if (Objects.equals(existingValue, value)) {
            return this;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.attributes.size() + (!this.attributes.containsKey(name) ? 1 : 0));
        attributes.putAll(this.attributes);
        attributes.put(name, value);
        this.attributes = attributes;
        return this;
    }

    protected abstract <T> JsonpDeserializer<T> getDefaultDeserializer(Class<T> var1);

    @Override
    public <T> T deserialize(JsonParser parser, Class<T> clazz) {
        JsonpDeserializer<T> deserializer = JsonpMapperBase.findDeserializer(clazz);
        if (deserializer != null) {
            return deserializer.deserialize(parser, this);
        }
        return this.getDefaultDeserializer(clazz).deserialize(parser, this);
    }

    @Nullable
    public static <T> JsonpDeserializer<T> findDeserializer(Class<T> clazz) {
        JsonpDeserializable annotation = clazz.getAnnotation(JsonpDeserializable.class);
        if (annotation != null) {
            try {
                Field field = clazz.getDeclaredField(annotation.field());
                return (JsonpDeserializer)field.get(null);
            }
            catch (Exception e) {
                throw new RuntimeException("No deserializer found in '" + clazz.getName() + "." + annotation.field() + "'");
            }
        }
        return null;
    }

    @Nullable
    public static <T> JsonpSerializer<T> findSerializer(T value) {
        Class<?> valueClass = value.getClass();
        if (JsonpSerializable.class.isAssignableFrom(valueClass)) {
            return JsonpSerializableSerializer.INSTANCE;
        }
        if (JsonValue.class.isAssignableFrom(valueClass)) {
            return JsonpValueSerializer.INSTANCE;
        }
        return null;
    }

    protected static class JsonpValueSerializer
    implements JsonpSerializer<JsonValue> {
        protected static final JsonpSerializer<?> INSTANCE = new JsonpValueSerializer();

        protected JsonpValueSerializer() {
        }

        @Override
        public void serialize(JsonValue value, JsonGenerator generator, JsonpMapper mapper) {
            generator.write(value);
        }
    }

    protected static class JsonpSerializableSerializer<T extends JsonpSerializable>
    implements JsonpSerializer<T> {
        protected static final JsonpSerializer<?> INSTANCE = new JsonpSerializableSerializer();

        protected JsonpSerializableSerializer() {
        }

        @Override
        public void serialize(T value, JsonGenerator generator, JsonpMapper mapper) {
            value.serialize(generator, mapper);
        }
    }
}

