/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.google.common.collect.ImmutableList;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.queue.rabbitmq.view.cassandra.BrowseStartDAO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class BrowseStartHealthCheck
implements HealthCheck {
    private static final ComponentName COMPONENT_NAME = new ComponentName("RabbitMQMailQueue BrowseStart");
    private static final Duration GRACE_PERIOD = Duration.ofDays(7L);
    private final BrowseStartDAO browseStartDAO;
    private final Clock clock;

    @Inject
    public BrowseStartHealthCheck(BrowseStartDAO browseStartDAO, Clock clock) {
        this.browseStartDAO = browseStartDAO;
        this.clock = clock;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Publisher<Result> check() {
        return this.browseStartDAO.listAll().filter(pair -> ((Instant)pair.getValue()).isBefore(this.clock.instant().minus(GRACE_PERIOD))).map(Pair::getKey).collect(ImmutableList.toImmutableList()).filter(list -> !list.isEmpty()).map(tooOldBrowseStart -> Result.degraded((ComponentName)COMPONENT_NAME, (String)String.format("The following mail queues %s have out of date browse starts (older than 7 days) which can cause performance issues. We recommend auditing the mail queue content, and resuming the delivery of oldest items, which would allow browse start updates to take place correctly again.", tooOldBrowseStart.toString()))).switchIfEmpty(Mono.just((Object)Result.healthy((ComponentName)COMPONENT_NAME))).onErrorResume(e -> Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Error while checking browse start", (Throwable)e)));
    }
}

