/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.RegistrationKey;
import org.apache.james.mailbox.model.CurrentQuotas;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaOperation;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.CurrentQuotaManager;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class QuotaUsernameChangeTaskStep
implements UsernameChangeTaskStep {
    private static final ImmutableSet<RegistrationKey> NO_REGISTRATION_KEYS = ImmutableSet.of();
    private final QuotaManager quotaManager;
    private final MaxQuotaManager maxQuotaManager;
    private final CurrentQuotaManager currentQuotaManager;
    private final UserQuotaRootResolver userQuotaRootResolver;
    private final EventBus eventBus;

    @Inject
    public QuotaUsernameChangeTaskStep(QuotaManager quotaManager, CurrentQuotaManager currentQuotaManager, UserQuotaRootResolver userQuotaRootResolver, MaxQuotaManager maxQuotaManager, EventBus eventBus) {
        this.quotaManager = quotaManager;
        this.currentQuotaManager = currentQuotaManager;
        this.userQuotaRootResolver = userQuotaRootResolver;
        this.maxQuotaManager = maxQuotaManager;
        this.eventBus = eventBus;
    }

    public UsernameChangeTaskStep.StepName name() {
        return new UsernameChangeTaskStep.StepName("QuotaUsernameChangeTaskStep");
    }

    public int priority() {
        return 3;
    }

    public Publisher<Void> changeUsername(Username oldUsername, Username newUsername) {
        return Mono.from((Publisher)this.quotaManager.getQuotasReactive(this.userQuotaRootResolver.forUser(oldUsername))).flatMap(quotas -> Mono.fromCallable(() -> this.userQuotaRootResolver.forUser(newUsername)).flatMap(newUserQuotaRoot -> this.setQuotaForNewUser((QuotaRoot)newUserQuotaRoot, (QuotaManager.Quotas)quotas).then(this.dispatchNewEventQuota((QuotaRoot)newUserQuotaRoot, newUsername))));
    }

    private Mono<Void> setQuotaForNewUser(QuotaRoot quotaRoot, QuotaManager.Quotas quotas) {
        return this.setMaxQuota(quotaRoot, quotas).then(this.setCurrentQuota(quotaRoot, quotas));
    }

    private Mono<Void> setMaxQuota(QuotaRoot quotaRoot, QuotaManager.Quotas quotas) {
        return Mono.zip((Mono)this.setMaxMessagesQuota(quotaRoot, quotas).thenReturn((Object)quotaRoot), (Mono)this.setMaxStorageQuota(quotaRoot, quotas).thenReturn((Object)quotaRoot)).then();
    }

    private Mono<Void> setMaxStorageQuota(QuotaRoot quotaRoot, QuotaManager.Quotas quotas) {
        return Mono.justOrEmpty(Optional.ofNullable((QuotaSizeLimit)quotas.getStorageQuota().getLimitByScope().get((Object)Quota.Scope.User))).flatMap(quotaSizeLimit -> Mono.from((Publisher)this.maxQuotaManager.setMaxStorageReactive(quotaRoot, quotaSizeLimit)));
    }

    private Mono<Void> setMaxMessagesQuota(QuotaRoot quotaRoot, QuotaManager.Quotas quotas) {
        return Mono.justOrEmpty(Optional.ofNullable((QuotaCountLimit)quotas.getMessageQuota().getLimitByScope().get((Object)Quota.Scope.User))).flatMap(quotaCountLimit -> Mono.from((Publisher)this.maxQuotaManager.setMaxMessageReactive(quotaRoot, quotaCountLimit)));
    }

    private Mono<Void> setCurrentQuota(QuotaRoot quotaRoot, QuotaManager.Quotas quotas) {
        return Mono.from((Publisher)this.currentQuotaManager.setCurrentQuotas(QuotaOperation.from((QuotaRoot)quotaRoot, (CurrentQuotas)new CurrentQuotas((QuotaCountUsage)quotas.getMessageQuota().getUsed(), (QuotaSizeUsage)quotas.getStorageQuota().getUsed()))));
    }

    private Mono<Void> dispatchNewEventQuota(QuotaRoot quotaRoot, Username username) {
        return Mono.from((Publisher)this.quotaManager.getQuotasReactive(quotaRoot)).flatMap(quotas -> this.eventBus.dispatch((Event)((EventFactory.QuotaUsageUpdatedFinalStage)((EventFactory.RequireInstant)((EventFactory.RequireQuotaSize)((EventFactory.RequireQuotaCount)((EventFactory.RequireQuotaRoot)((EventFactory.RequireUser)EventFactory.quotaUpdated().randomEventId()).user(username)).quotaRoot(quotaRoot)).quotaCount(quotas.getMessageQuota())).quotaSize(quotas.getStorageQuota())).instant(Instant.now())).build(), NO_REGISTRATION_KEYS));
    }
}

