/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.dsn;

import java.util.Optional;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.MailParametersHook;
import org.apache.mailet.DsnParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSNMailParameterHook
implements MailParametersHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(DSNMailParameterHook.class);
    public static final ProtocolSession.AttachmentKey<DsnParameters.Ret> DSN_RET = ProtocolSession.AttachmentKey.of((String)"DSN_RET", DsnParameters.Ret.class);
    public static final ProtocolSession.AttachmentKey<DsnParameters.EnvId> DSN_ENVID = ProtocolSession.AttachmentKey.of((String)"DSN_ENVID", DsnParameters.EnvId.class);

    public HookResult doMailParameter(SMTPSession session, String paramName, String paramValue) {
        if (paramName.equals("RET")) {
            DsnParameters.Ret.parse((String)paramValue).or(() -> {
                LOGGER.debug("Invalid DSN RET value: {}", (Object)paramValue);
                return Optional.empty();
            }).ifPresent(ret -> session.setAttachment(DSN_RET, ret, ProtocolSession.State.Transaction));
        }
        if (paramName.equals("ENVID")) {
            DsnParameters.EnvId envId = DsnParameters.EnvId.of((String)paramValue);
            session.setAttachment(DSN_ENVID, (Object)envId, ProtocolSession.State.Transaction);
        }
        return HookResult.DECLINED;
    }

    public String[] getMailParamNames() {
        return new String[]{"RET", "ENVID"};
    }
}

