/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.projections.EmailQueryView;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.util.streams.Limit;
import org.apache.james.webadmin.Routes;
import org.reactivestreams.Publisher;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import spark.Service;

public class CleanupEmailQueryViewRoute
implements Routes {
    private final UsersRepository users;
    private final MailboxManager mailboxManager;
    private final MessageIdManager messageIdManager;
    private final EmailQueryView emailQueryView;

    @Inject
    public CleanupEmailQueryViewRoute(UsersRepository users, MailboxManager mailboxManager, MessageIdManager messageIdManager, EmailQueryView emailQueryView) {
        this.mailboxManager = mailboxManager;
        this.messageIdManager = messageIdManager;
        this.emailQueryView = emailQueryView;
        this.users = users;
    }

    public String getBasePath() {
        return "/bte/emailQueryView/cleanup";
    }

    public void define(Service service) {
        service.post(this.getBasePath(), (req, res) -> {
            AtomicLong atomicLong = new AtomicLong();
            Flux.from((Publisher)this.users.listReactive()).doOnNext(next -> LoggerFactory.getLogger(this.getClass()).warn("Cleanup emailQueryView for {} user nb {}", (Object)next.asString(), (Object)atomicLong.incrementAndGet())).flatMap(user -> {
                MailboxSession session = this.mailboxManager.createSystemSession(user);
                return Flux.from((Publisher)this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)session).build(), session)).flatMap(mailbox -> Flux.concat((Publisher[])new Publisher[]{this.emailQueryView.listMailboxContentSortedByReceivedAt(mailbox.getId(), Limit.limit((int)10000000)), this.emailQueryView.listMailboxContentSortedBySentAt(mailbox.getId(), Limit.limit((int)10000000))}).distinct().flatMap(messageId -> Mono.from((Publisher)this.messageIdManager.getMessagesReactive((Collection)ImmutableSet.of((Object)messageId), FetchGroup.MINIMAL, session)).hasElement().flatMap(accessible -> {
                    if (!accessible.booleanValue()) {
                        LoggerFactory.getLogger(this.getClass()).warn("Deleting {} for {}", (Object)messageId.serialize(), (Object)user.asString());
                        return this.emailQueryView.delete(mailbox.getId(), messageId);
                    }
                    return Mono.empty();
                }), 4), 4);
            }, 4).then().subscribeOn(Schedulers.parallel()).subscribe();
            return "";
        });
        service.post(this.getBasePath() + "/:user", (req, res) -> {
            AtomicLong atomicLong = new AtomicLong();
            Username username = Username.of((String)req.params("user"));
            MailboxSession session = this.mailboxManager.createSystemSession(username);
            Flux.from((Publisher)this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)session).build(), session)).flatMap(mailbox -> Flux.concat((Publisher[])new Publisher[]{this.emailQueryView.listMailboxContentSortedByReceivedAt(mailbox.getId(), Limit.limit((int)10000000)), this.emailQueryView.listMailboxContentSortedBySentAt(mailbox.getId(), Limit.limit((int)10000000))}).distinct().flatMap(messageId -> Mono.from((Publisher)this.messageIdManager.getMessagesReactive((Collection)ImmutableSet.of((Object)messageId), FetchGroup.MINIMAL, session)).hasElement().flatMap(accessible -> {
                if (!accessible.booleanValue()) {
                    atomicLong.incrementAndGet();
                    LoggerFactory.getLogger(this.getClass()).warn("Deleting {} for {}", (Object)messageId.serialize(), (Object)username.asString());
                    return this.emailQueryView.delete(mailbox.getId(), messageId);
                }
                return Mono.empty();
            }), 4), 4).then().block();
            return username.asString() + " " + atomicLong.get();
        });
    }
}

