/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.window.function.aggregate;

import org.apache.iotdb.db.queryengine.execution.operator.process.window.function.WindowFunction;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.function.aggregate.WindowAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.process.window.partition.Partition;
import org.apache.tsfile.block.column.ColumnBuilder;

public class AggregationWindowFunction
implements WindowFunction {
    private final WindowAggregator aggregator;
    private int currentStart;
    private int currentEnd;

    public AggregationWindowFunction(WindowAggregator aggregator) {
        this.aggregator = aggregator;
        this.reset();
    }

    @Override
    public void reset() {
        this.aggregator.reset();
        this.currentStart = -1;
        this.currentEnd = -1;
    }

    @Override
    public void transform(Partition partition, ColumnBuilder builder, int index, int frameStart, int frameEnd, int peerGroupStart, int peerGroupEnd) {
        if (frameStart < 0) {
            this.reset();
        } else if (frameStart == this.currentStart && frameEnd >= this.currentEnd) {
            if (frameEnd != this.currentEnd) {
                Partition region = partition.getRegion(this.currentEnd + 1, frameEnd);
                this.aggregator.addInput(region);
                this.currentEnd = frameEnd;
            }
        } else {
            this.buildNewFrame(partition, frameStart, frameEnd);
        }
        this.aggregator.evaluate(builder);
    }

    private void buildNewFrame(Partition partition, int frameStart, int frameEnd) {
        int suffix;
        int prefix;
        int frameLength;
        if (this.aggregator.removable() && (frameLength = frameEnd - frameStart + 1) > (prefix = Math.abs(this.currentStart - frameStart)) + (suffix = Math.abs(this.currentEnd - frameEnd))) {
            Partition region;
            if (this.currentStart < frameStart) {
                region = partition.getRegion(this.currentStart, frameStart - 1);
                this.aggregator.removeInput(region);
            } else if (this.currentStart > frameStart) {
                region = partition.getRegion(frameStart, this.currentStart - 1);
                this.aggregator.addInput(region);
            }
            if (frameEnd < this.currentEnd) {
                region = partition.getRegion(frameEnd + 1, this.currentEnd);
                this.aggregator.removeInput(region);
            } else if (frameEnd > this.currentEnd) {
                region = partition.getRegion(this.currentEnd + 1, frameEnd);
                this.aggregator.addInput(region);
            }
            this.currentStart = frameStart;
            this.currentEnd = frameEnd;
            return;
        }
        this.aggregator.reset();
        Partition region = partition.getRegion(frameStart, frameEnd);
        this.aggregator.addInput(region);
        this.currentStart = frameStart;
        this.currentEnd = frameEnd;
    }

    @Override
    public boolean needPeerGroup() {
        return false;
    }
}

