/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.mqtt;

import io.moquette.broker.Server;
import io.moquette.broker.config.IConfig;
import io.moquette.broker.config.MemoryConfig;
import io.moquette.broker.security.IAuthenticator;
import io.moquette.interception.InterceptHandler;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.commons.pipe.agent.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskSourceRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.metric.PipeEventCounter;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionEventCounter;
import org.apache.iotdb.db.pipe.source.mqtt.MQTTPublishHandler;
import org.apache.iotdb.db.protocol.mqtt.BrokerAuthenticator;
import org.apache.iotdb.db.protocol.mqtt.PayloadFormatManager;
import org.apache.iotdb.db.protocol.mqtt.PayloadFormatter;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TreeModel
@TableModel
public class MQTTSource
implements PipeExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MQTTSource.class);
    protected String pipeName;
    protected long creationTime;
    protected PipeTaskMeta pipeTaskMeta;
    protected final UnboundedBlockingPendingQueue<EnrichedEvent> pendingQueue = new UnboundedBlockingPendingQueue((PipeEventCounter)new PipeDataRegionEventCounter());
    protected PayloadFormatter payloadFormat;
    protected IConfig brokerConfig;
    protected List<InterceptHandler> handlers;
    protected IAuthenticator authenticator;
    private final Server server = new Server();
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean hasBeenStarted = new AtomicBoolean(false);

    public void validate(PipeParameterValidator validator) throws Exception {
        if (!validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.single-mode", "source.single-mode"), true)) {
            throw new PipeParameterNotValidException("single mode should be true in MQTT extractor");
        }
        this.validateMoquetteConfig(validator.getParameters());
    }

    public void validateMoquetteConfig(PipeParameters parameters) {
        String sqlDialect = parameters.getStringOrDefault("__system.sql-dialect", "tree");
        String formatType = parameters.getStringOrDefault("mqtt.payload-formatter", "tree".equals(sqlDialect) ? "json" : "line");
        try {
            this.payloadFormat = PayloadFormatManager.getPayloadFormat(formatType);
        }
        catch (IllegalArgumentException e) {
            throw new PipeParameterNotValidException("Invalid payload format type: " + formatType);
        }
        String ip = parameters.getStringOrDefault("mqtt.host", "127.0.0.1");
        int port = Integer.parseInt(parameters.getStringOrDefault("mqtt.port", "1883"));
        try (ServerSocket socket = new ServerSocket();){
            socket.bind(new InetSocketAddress(ip, port));
        }
        catch (IOException e) {
            throw new PipeParameterNotValidException("Cannot bind MQTT broker to " + ip + ":" + port + ". The port might already be in use, or the IP address is invalid.");
        }
        String dataPath = parameters.getStringOrDefault("mqtt.data-path", "data/");
        File file = Paths.get(dataPath, new String[0]).resolve("moquette_store.h2").toAbsolutePath().toFile();
        if (file.exists()) {
            try (RandomAccessFile raf = new RandomAccessFile(file, "rw");
                 FileChannel channel = raf.getChannel();
                 FileLock lock = channel.tryLock();){
                if (lock == null) {
                    throw new PipeParameterNotValidException(" The data file is used by another MQTT Source or MQTT Service. Please use another data path");
                }
            }
            catch (Exception e) {
                throw new PipeParameterNotValidException(" The data file is used by another MQTT Source or MQTT Service. Please use another data path");
            }
        }
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        PipeTaskSourceRuntimeEnvironment environment = (PipeTaskSourceRuntimeEnvironment)configuration.getRuntimeEnvironment();
        this.pipeName = environment.getPipeName();
        this.creationTime = environment.getCreationTime();
        this.pipeTaskMeta = environment.getPipeTaskMeta();
        this.brokerConfig = this.createBrokerConfig(parameters);
        this.handlers = new ArrayList<InterceptHandler>(1);
        this.handlers.add((InterceptHandler)new MQTTPublishHandler(this.payloadFormat, environment, this.pendingQueue));
        this.authenticator = new BrokerAuthenticator();
    }

    private IConfig createBrokerConfig(PipeParameters pipeParameters) {
        Properties properties = new Properties();
        properties.setProperty("host", pipeParameters.getStringOrDefault("mqtt.host", "127.0.0.1"));
        properties.setProperty("port", pipeParameters.getStringOrDefault("mqtt.port", "1883"));
        properties.setProperty("intercept.thread_pool.size", pipeParameters.getStringOrDefault("mqtt.pool-size", String.valueOf(1)));
        properties.setProperty("data_path", pipeParameters.getStringOrDefault("mqtt.data-path", "data/"));
        properties.setProperty("immediate_buffer_flush", pipeParameters.getStringOrDefault("mqtt.immediate-flush", String.valueOf(true)));
        properties.setProperty("allow_anonymous", pipeParameters.getStringOrDefault("mqtt.allow-anonymous", String.valueOf(false)));
        properties.setProperty("allow_zero_byte_client_id", pipeParameters.getStringOrDefault("mqtt.allow-zero-byte-client-id", String.valueOf(true)));
        properties.setProperty("netty.mqtt.message_size", pipeParameters.getStringOrDefault("mqtt.max-message-size", String.valueOf(0x100000L)));
        return new MemoryConfig(properties);
    }

    public void start() throws Exception {
        if (this.hasBeenStarted.get()) {
            return;
        }
        this.hasBeenStarted.set(true);
        try {
            this.server.startServer(this.brokerConfig, this.handlers, null, this.authenticator, null);
        }
        catch (Exception e) {
            throw new PipeException("Failed to start MQTT Extractor " + this.pipeName + ". Possible reasons: the data file might be used by another MQTT Source or MQTT Service, the port might already be in use, or there could be other issues. Please check the logs for more details.", (Throwable)e);
        }
        LOGGER.info("Start MQTT Extractor successfully, listening on ip {}, port {}", (Object)this.brokerConfig.getProperty("host"), (Object)this.brokerConfig.getProperty("port"));
    }

    public Event supply() throws Exception {
        return this.isClosed.get() ? null : this.pendingQueue.directPoll();
    }

    public void close() throws Exception {
        if (!this.isClosed.get() && this.hasBeenStarted.get()) {
            this.server.stopServer();
            this.isClosed.set(true);
        }
    }
}

