/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemAlignedChunkReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.AlignedPageMetadata;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.BatchDataFactory;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.factory.FilterFactory;
import org.apache.tsfile.read.reader.IPageReader;
import org.apache.tsfile.read.reader.series.PaginationController;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class MemAlignedPageReader
implements IPageReader {
    private TsBlock tsBlock;
    private final AlignedPageMetadata pageMetadata;
    private final int pageIndex;
    private final Supplier<TsBlock> tsBlockSupplier;
    private final List<TSDataType> tsDataTypes;
    private Filter recordFilter;
    private PaginationController paginationController = PaginationController.UNLIMITED_PAGINATION_CONTROLLER;
    private TsBlockBuilder builder;

    public MemAlignedPageReader(Supplier<TsBlock> tsBlockSupplier, int pageIndex, List<TSDataType> tsDataTypes, Statistics<? extends Serializable> timeStatistics, Statistics<? extends Serializable>[] valueStatistics, Filter recordFilter) {
        this.tsBlockSupplier = tsBlockSupplier;
        this.pageIndex = pageIndex;
        this.recordFilter = recordFilter;
        this.tsDataTypes = tsDataTypes;
        this.pageMetadata = new AlignedPageMetadata(timeStatistics, valueStatistics);
    }

    public BatchData getAllSatisfiedPageData() throws IOException {
        return super.getAllSatisfiedPageData();
    }

    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        this.getTsBlock();
        BatchData batchData = BatchDataFactory.createBatchData((TSDataType)TSDataType.VECTOR, (boolean)ascending, (boolean)false);
        boolean[] satisfyInfo = this.buildSatisfyInfoArray();
        for (int rowIndex = 0; rowIndex < this.tsBlock.getPositionCount(); ++rowIndex) {
            if (!satisfyInfo[rowIndex]) continue;
            long time = this.tsBlock.getTimeByIndex(rowIndex);
            TsPrimitiveType[] values = new TsPrimitiveType[this.tsBlock.getValueColumnCount()];
            for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
                if (this.tsBlock.getColumn(column) == null || this.tsBlock.getColumn(column).isNull(rowIndex)) continue;
                values[column] = this.tsBlock.getColumn(column).getTsPrimitiveType(rowIndex);
            }
            batchData.putVector(time, values);
        }
        return batchData.flip();
    }

    public TsBlock getAllSatisfiedData() {
        this.getTsBlock();
        this.builder.reset();
        boolean[] satisfyInfo = this.buildSatisfyInfoArray();
        int readEndIndex = this.buildTimeColumn(satisfyInfo);
        this.buildValueColumns(satisfyInfo, readEndIndex);
        return this.builder.build();
    }

    private boolean[] buildSatisfyInfoArray() {
        if (this.recordFilter == null || this.recordFilter.allSatisfy((IMetadata)this)) {
            boolean[] satisfyInfo = new boolean[this.tsBlock.getPositionCount()];
            Arrays.fill(satisfyInfo, true);
            return satisfyInfo;
        }
        return this.recordFilter.satisfyTsBlock(this.tsBlock);
    }

    private int buildTimeColumn(boolean[] satisfyInfo) {
        int readEndIndex = this.tsBlock.getPositionCount();
        for (int row = 0; row < readEndIndex; ++row) {
            if (this.needSkipCurrentRow(satisfyInfo, row)) continue;
            if (this.paginationController.hasCurLimit()) {
                this.builder.getTimeColumnBuilder().writeLong(this.tsBlock.getTimeByIndex(row));
                this.builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            readEndIndex = row;
        }
        return readEndIndex;
    }

    private boolean needSkipCurrentRow(boolean[] satisfyInfo, int rowIndex) {
        if (!satisfyInfo[rowIndex]) {
            return true;
        }
        if (this.paginationController.hasCurOffset()) {
            this.paginationController.consumeOffset();
            satisfyInfo[rowIndex] = false;
            return true;
        }
        return false;
    }

    private void buildValueColumns(boolean[] satisfyInfo, int readEndIndex) {
        for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
            Column valueColumn = this.tsBlock.getColumn(column);
            ColumnBuilder valueBuilder = this.builder.getColumnBuilder(column);
            for (int row = 0; row < readEndIndex; ++row) {
                if (!satisfyInfo[row]) continue;
                if (!valueColumn.isNull(row)) {
                    valueBuilder.write(valueColumn, row);
                    continue;
                }
                valueBuilder.appendNull();
            }
        }
    }

    public Statistics<? extends Serializable> getStatistics() {
        return this.pageMetadata.getStatistics();
    }

    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.pageMetadata.getTimeStatistics();
    }

    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        return this.pageMetadata.getMeasurementStatistics(measurementIndex);
    }

    public boolean hasNullValue(int measurementIndex) {
        return this.pageMetadata.hasNullValue(measurementIndex);
    }

    public void addRecordFilter(Filter filter) {
        this.recordFilter = FilterFactory.and((Filter)this.recordFilter, (Filter)filter);
    }

    public void setLimitOffset(PaginationController paginationController) {
        this.paginationController = paginationController;
    }

    public boolean isModified() {
        return false;
    }

    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
        this.builder = new TsBlockBuilder(dataTypes);
    }

    private void getTsBlock() {
        if (this.tsBlock == null) {
            this.initializeTsBlockIndex();
            this.tsBlock = this.tsBlockSupplier.get();
            if (this.pageMetadata.getStatistics() == null) {
                this.initPageStatistics();
            }
        }
    }

    private void initializeTsBlockIndex() {
        if (this.tsBlockSupplier instanceof MemAlignedChunkReader.TsBlockSupplier) {
            ((MemAlignedChunkReader.TsBlockSupplier)this.tsBlockSupplier).setTsBlockIndex(this.pageIndex);
        }
    }

    private void initPageStatistics() {
        Statistics pageTimeStatistics = Statistics.getStatsByType((TSDataType)TSDataType.VECTOR);
        Statistics[] pageValueStatistics = new Statistics[this.tsDataTypes.size()];
        for (int column = 0; column < this.tsDataTypes.size(); ++column) {
            Statistics valueStatistics;
            pageValueStatistics[column] = valueStatistics = Statistics.getStatsByType((TSDataType)this.tsDataTypes.get(column));
        }
        this.updatePageStatisticsFromTsBlock((Statistics<? extends Serializable>)pageTimeStatistics, pageValueStatistics);
        this.pageMetadata.setStatistics((Statistics<? extends Serializable>)pageTimeStatistics, pageValueStatistics);
    }

    private void updatePageStatisticsFromTsBlock(Statistics<? extends Serializable> timeStatistics, Statistics<? extends Serializable>[] valueStatistics) {
        if (!this.tsBlock.isEmpty()) {
            for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                timeStatistics.update(this.tsBlock.getTimeByIndex(i));
            }
            block9: for (int column = 0; column < this.tsDataTypes.size(); ++column) {
                switch (this.tsDataTypes.get(column)) {
                    case BOOLEAN: {
                        int i;
                        for (i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                            valueStatistics[column].update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(column).getBoolean(i));
                        }
                        continue block9;
                    }
                    case INT32: 
                    case DATE: {
                        int i;
                        for (i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                            valueStatistics[column].update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(column).getInt(i));
                        }
                        continue block9;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        int i;
                        for (i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                            valueStatistics[column].update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(column).getLong(i));
                        }
                        continue block9;
                    }
                    case FLOAT: {
                        int i;
                        for (i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                            valueStatistics[column].update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(column).getFloat(i));
                        }
                        continue block9;
                    }
                    case DOUBLE: {
                        int i;
                        for (i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                            valueStatistics[column].update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(column).getDouble(i));
                        }
                        continue block9;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        int i;
                        for (i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                            valueStatistics[column].update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(column).getBinary(i));
                        }
                        continue block9;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.tsDataTypes.get(column)));
                    }
                }
            }
        }
    }
}

