/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrAlternation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrAnchor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrConcatenation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrEmpty;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrExclusion;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrLabel;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrPermutation;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrQuantified;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AnchorPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.EmptyPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExcludedPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OneOrMoreQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternAlternation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternConcatenation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternPermutation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PatternVariable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuantifiedPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RangeQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ZeroOrMoreQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ZeroOrOneQuantifier;

public class RowPatternToIrRewriter
extends AstVisitor<IrRowPattern, Void> {
    private final Analysis analysis;

    public RowPatternToIrRewriter(Analysis analysis) {
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
    }

    public static IrRowPattern rewrite(RowPattern node, Analysis analysis) {
        return (IrRowPattern)new RowPatternToIrRewriter(analysis).process(node);
    }

    @Override
    protected IrRowPattern visitPatternAlternation(PatternAlternation node, Void context) {
        List patterns = (List)node.getPatterns().stream().map(this::process).collect(ImmutableList.toImmutableList());
        return new IrAlternation(patterns);
    }

    @Override
    protected IrRowPattern visitPatternConcatenation(PatternConcatenation node, Void context) {
        List patterns = (List)node.getPatterns().stream().map(this::process).collect(ImmutableList.toImmutableList());
        return new IrConcatenation(patterns);
    }

    @Override
    protected IrRowPattern visitQuantifiedPattern(QuantifiedPattern node, Void context) {
        IrRowPattern pattern = (IrRowPattern)this.process(node.getPattern());
        IrQuantifier quantifier = this.rewritePatternQuantifier(node.getPatternQuantifier());
        return new IrQuantified(pattern, quantifier);
    }

    private IrQuantifier rewritePatternQuantifier(PatternQuantifier quantifier) {
        if (quantifier instanceof ZeroOrMoreQuantifier) {
            return IrQuantifier.zeroOrMore(quantifier.isGreedy());
        }
        if (quantifier instanceof OneOrMoreQuantifier) {
            return IrQuantifier.oneOrMore(quantifier.isGreedy());
        }
        if (quantifier instanceof ZeroOrOneQuantifier) {
            return IrQuantifier.zeroOrOne(quantifier.isGreedy());
        }
        if (quantifier instanceof RangeQuantifier) {
            Analysis.Range range = this.analysis.getRange((RangeQuantifier)quantifier);
            return IrQuantifier.range(range.getAtLeast(), range.getAtMost(), quantifier.isGreedy());
        }
        throw new IllegalStateException("unsupported pattern quantifier type: " + quantifier.getClass().getSimpleName());
    }

    @Override
    protected IrRowPattern visitAnchorPattern(AnchorPattern node, Void context) {
        IrAnchor.Type type;
        switch (node.getType()) {
            case PARTITION_START: {
                type = IrAnchor.Type.PARTITION_START;
                break;
            }
            case PARTITION_END: {
                type = IrAnchor.Type.PARTITION_END;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + (Object)((Object)node.getType()));
            }
        }
        return new IrAnchor(type);
    }

    @Override
    protected IrRowPattern visitEmptyPattern(EmptyPattern node, Void context) {
        return new IrEmpty();
    }

    @Override
    protected IrRowPattern visitExcludedPattern(ExcludedPattern node, Void context) {
        IrRowPattern pattern = (IrRowPattern)this.process(node.getPattern());
        return new IrExclusion(pattern);
    }

    @Override
    protected IrRowPattern visitPatternPermutation(PatternPermutation node, Void context) {
        List patterns = (List)node.getPatterns().stream().map(this::process).collect(ImmutableList.toImmutableList());
        return new IrPermutation(patterns);
    }

    @Override
    protected IrRowPattern visitPatternVariable(PatternVariable node, Void context) {
        return new IrLabel(node.getName().getCanonicalValue());
    }
}

