/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.schema;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.pipe.event.SerializableEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionSnapshotEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;

public enum PipeSchemaSerializableEventType {
    SCHEMA_WRITE_PLAN(1),
    SCHEMA_SNAPSHOT(2),
    SCHEMA_SNAPSHOT_V2(3);

    private static final Map<Byte, PipeSchemaSerializableEventType> TYPE_MAP;
    private final byte type;

    private PipeSchemaSerializableEventType(byte type) {
        this.type = type;
    }

    public byte getType() {
        return this.type;
    }

    public static PipeSchemaSerializableEventType deserialize(byte type) {
        return TYPE_MAP.get(type);
    }

    public static SerializableEvent deserialize(ByteBuffer buffer) throws IOException {
        byte eventType = buffer.get();
        return PipeSchemaSerializableEventType.deserialize(buffer, eventType);
    }

    public static SerializableEvent deserialize(ByteBuffer buffer, byte eventType) throws IOException {
        Object event;
        switch (eventType) {
            case 1: {
                event = new PipeSchemaRegionWritePlanEvent();
                break;
            }
            case 2: {
                event = new PipeSchemaRegionSnapshotEvent(1);
                break;
            }
            case 3: {
                event = new PipeSchemaRegionSnapshotEvent(2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid event type: " + eventType);
            }
        }
        event.deserializeFromByteBuffer(buffer);
        return event;
    }

    static {
        TYPE_MAP = new HashMap<Byte, PipeSchemaSerializableEventType>();
        for (PipeSchemaSerializableEventType type : PipeSchemaSerializableEventType.values()) {
            TYPE_MAP.put(type.getType(), type);
        }
    }
}

