/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.memory;

import org.apache.iotdb.commons.memory.MemoryBlockType;
import org.apache.iotdb.commons.memory.MemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IMemoryBlock
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IMemoryBlock.class);
    protected MemoryManager memoryManager;
    protected String name;
    protected MemoryBlockType memoryBlockType;
    protected volatile boolean isReleased = false;
    protected long totalMemorySizeInBytes;

    public abstract long forceAllocateWithoutLimitation(long var1);

    public abstract boolean allocate(long var1);

    public abstract boolean allocateIfSufficient(long var1, double var3);

    public abstract boolean allocateUntilAvailable(long var1, long var3) throws InterruptedException;

    public abstract long release(long var1);

    public abstract void setUsedMemoryInBytes(long var1);

    public abstract long getUsedMemoryInBytes();

    public abstract long getFreeMemoryInBytes();

    public String getName() {
        return this.name;
    }

    public void setTotalMemorySizeInBytes(long totalMemorySizeInBytes) {
        this.totalMemorySizeInBytes = totalMemorySizeInBytes;
    }

    public long getTotalMemorySizeInBytes() {
        return this.totalMemorySizeInBytes;
    }

    public boolean isReleased() {
        return this.isReleased;
    }

    public void markAsReleased() {
        this.isReleased = true;
    }

    public MemoryBlockType getMemoryBlockType() {
        return this.memoryBlockType;
    }

    public void print(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        sb.append(this);
        LOGGER.info(sb.toString());
    }
}

