/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.util.concurrent.atomic.AtomicLong;

public class LongSequence {
    private final AtomicLong atomic;
    private final long low;
    private final long high;

    public LongSequence(long low, long high) {
        this.low = low;
        this.high = high;
        this.atomic = new AtomicLong(low);
    }

    public long getAndIncrement() {
        long next;
        long current;
        while (!this.atomic.compareAndSet(current, next = (current = this.atomic.get()) >= this.high ? this.low : current + 1L)) {
        }
        return current;
    }

    public long get() {
        return this.atomic.get();
    }
}

