/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.template;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.rpc.TSStatusCode;

public class DeactivateTemplateStatement
extends Statement
implements IConfigStatement {
    private String templateName;
    private List<PartialPath> pathPatternList;

    public DeactivateTemplateStatement() {
        this.statementType = StatementType.DEACTIVATE_TEMPLATE;
    }

    public DeactivateTemplateStatement(String templateName, List<PartialPath> pathPatternList) {
        this.templateName = templateName;
        this.pathPatternList = pathPatternList;
        this.statementType = StatementType.DEACTIVATE_TEMPLATE;
    }

    @Override
    public List<PartialPath> getPaths() {
        Template template;
        ClusterTemplateManager clusterTemplateManager = ClusterTemplateManager.getInstance();
        try {
            template = clusterTemplateManager.getTemplate(this.templateName);
            if (template == null) {
                return Collections.emptyList();
            }
        }
        catch (IoTDBException e) {
            throw new RuntimeException(e);
        }
        return this.pathPatternList.stream().flatMap(path -> template.getSchemaMap().keySet().stream().map(arg_0 -> ((PartialPath)path).concatNode(arg_0))).collect(Collectors.toList());
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        List<PartialPath> checkedPaths = this.getPaths();
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkPatternPermission(userName, checkedPaths, PrivilegeType.WRITE_SCHEMA.ordinal()), checkedPaths, PrivilegeType.WRITE_SCHEMA);
    }

    public String getTemplateName() {
        return this.templateName == null ? "*" : this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public List<PartialPath> getPathPatternList() {
        return this.pathPatternList;
    }

    public void setPathPatternList(List<PartialPath> pathPatternList) {
        this.pathPatternList = pathPatternList;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitDeactivateTemplate(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }
}

