/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.service.ServiceDeploymentActions;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class ChangeGlobalStateMessage
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    private IgniteUuid id = IgniteUuid.randomUuid();
    private UUID reqId;
    private UUID initiatingNodeId;
    private ClusterState state;
    private List<StoredCacheData> storedCfgs;
    @Nullable
    private BaselineTopology baselineTopology;
    private boolean forceChangeBaselineTopology;
    private long timestamp;
    @GridToStringExclude
    private transient ExchangeActions exchangeActions;
    @GridToStringExclude
    @Nullable
    private transient ServiceDeploymentActions serviceDeploymentActions;
    private boolean forceDeactivation;

    public ChangeGlobalStateMessage(UUID reqId, UUID initiatingNodeId, @Nullable List<StoredCacheData> storedCfgs, ClusterState state, boolean forceDeactivation, BaselineTopology baselineTopology, boolean forceChangeBaselineTopology, long timestamp) {
        assert (reqId != null);
        assert (initiatingNodeId != null);
        this.reqId = reqId;
        this.initiatingNodeId = initiatingNodeId;
        this.storedCfgs = storedCfgs;
        this.state = state;
        this.forceDeactivation = forceDeactivation;
        this.baselineTopology = baselineTopology;
        this.forceChangeBaselineTopology = forceChangeBaselineTopology;
        this.timestamp = timestamp;
    }

    @Nullable
    public List<StoredCacheData> storedCacheConfigurations() {
        return this.storedCfgs;
    }

    @Nullable
    public ExchangeActions exchangeActions() {
        return this.exchangeActions;
    }

    void exchangeActions(ExchangeActions exchangeActions) {
        assert (exchangeActions != null && !exchangeActions.empty()) : exchangeActions;
        this.exchangeActions = exchangeActions;
    }

    @Nullable
    public ServiceDeploymentActions servicesDeploymentActions() {
        return this.serviceDeploymentActions;
    }

    public void servicesDeploymentActions(ServiceDeploymentActions serviceDeploymentActions) {
        this.serviceDeploymentActions = serviceDeploymentActions;
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        return null;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        return mgr.createDiscoCacheOnCacheChange(topVer, discoCache);
    }

    public UUID initiatorNodeId() {
        return this.initiatingNodeId;
    }

    @Deprecated
    public boolean activate() {
        return this.state.active();
    }

    public ClusterState state() {
        return this.state;
    }

    public boolean forceChangeBaselineTopology() {
        return this.forceChangeBaselineTopology;
    }

    @Nullable
    public BaselineTopology baselineTopology() {
        return this.baselineTopology;
    }

    public boolean forceDeactivation() {
        return this.forceDeactivation;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public UUID requestId() {
        return this.reqId;
    }

    public String toString() {
        return S.toString(ChangeGlobalStateMessage.class, this);
    }
}

