/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.persistence.calls;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.migrationtools.cli.persistence.commands.PersistenceBaseCmd;
import org.apache.ignite.migrationtools.cli.persistence.params.PersistenceParams;
import org.apache.ignite.migrationtools.persistence.Ignite2PersistentCacheTools;
import org.apache.ignite.migrationtools.persistence.MigrationKernalContext;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallInput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite3.internal.cli.logger.CliLoggers;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.jetbrains.annotations.Nullable;

public class ListCachesCall
implements Call<Input, List<Output>> {
    private static final IgniteLogger LOGGER = CliLoggers.forClass(ListCachesCall.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultCallOutput<List<Output>> execute(Input i) {
        List<Object> persistentCtx = Collections.emptyList();
        try {
            @Nullable IgniteConfiguration cfg = PersistenceBaseCmd.createValidIgniteCfg(i.persistenceParams());
            if (cfg == null) {
                DefaultCallOutput defaultCallOutput = DefaultCallOutput.failure((Throwable)new IgniteCliException("Unable to read ignite configuration"));
                return defaultCallOutput;
            }
            persistentCtx = PersistenceBaseCmd.createAndStartMigrationContext(i.persistenceParams(), cfg);
            if (persistentCtx.isEmpty()) {
                DefaultCallOutput defaultCallOutput = DefaultCallOutput.failure((Throwable)new IgniteCliException(String.format("Could not find node (consistentId:%s) folder in '%s'", i.persistenceParams().nodeConsistentId(), i.persistenceParams().workDir().toString())));
                return defaultCallOutput;
            }
            Set cacheIds = Ignite2PersistentCacheTools.persistentCaches(persistentCtx);
            LOGGER.info("Found {} caches", new Object[]{cacheIds.size()});
            List ret = cacheIds.stream().map(e -> new Output((String)e.getRight(), (Integer)e.getLeft())).collect(Collectors.toList());
            DefaultCallOutput defaultCallOutput = DefaultCallOutput.success(ret);
            return defaultCallOutput;
        }
        catch (IgniteCheckedException e2) {
            DefaultCallOutput defaultCallOutput = DefaultCallOutput.failure((Throwable)new IgniteCliException("Error while calling list-caches", (Throwable)e2));
            return defaultCallOutput;
        }
        finally {
            for (MigrationKernalContext migrationKernalContext : persistentCtx) {
                try {
                    migrationKernalContext.stop();
                }
                catch (IgniteCheckedException e3) {
                    LOGGER.error("Error stopping node context", (Throwable)e3);
                }
            }
        }
    }

    public static class Input
    implements CallInput {
        private PersistenceParams persistenceParams;

        public Input(PersistenceParams persistenceParams) {
            this.persistenceParams = persistenceParams;
        }

        public PersistenceParams persistenceParams() {
            return this.persistenceParams;
        }
    }

    public static class Output {
        private final String cacheName;
        private final int cacheId;

        public Output(String cacheName, int cacheId) {
            this.cacheName = cacheName;
            this.cacheId = cacheId;
        }

        public String cacheName() {
            return this.cacheName;
        }

        public int cacheId() {
            return this.cacheId;
        }
    }
}

