/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.config.converters;

import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.migrationtools.config.converters.ConfigurationConverter;
import org.apache.ignite.migrationtools.config.registry.ConfigurationRegistryInterface;
import org.apache.ignite3.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite3.internal.storage.configurations.StorageExtensionConfiguration;
import org.apache.ignite3.internal.storage.configurations.StorageProfileChange;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.PersistentPageMemoryProfileChange;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.VolatilePageMemoryProfileChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRegionConfigurationConverter
implements ConfigurationConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataRegionConfigurationConverter.class);

    private static void convertDataRegion(ConfigurationRegistryInterface registry, DataRegionConfiguration regionCfg, boolean isDefault) throws ExecutionException, InterruptedException {
        String regionName;
        String string = regionName = !isDefault ? regionCfg.getName() : "default";
        if (!regionCfg.isPersistenceEnabled()) {
            DataRegionConfigurationConverter.convertMemoryRegion(registry, regionCfg, regionName);
        } else {
            DataRegionConfigurationConverter.convertPersistentRegion(registry, regionCfg, regionName);
        }
    }

    private static void convertPersistentRegion(ConfigurationRegistryInterface registry, DataRegionConfiguration regionCfg, String regionName) throws ExecutionException, InterruptedException {
        StorageConfiguration storageConfig = ((StorageExtensionConfiguration)registry.getConfiguration(StorageExtensionConfiguration.KEY)).storage();
        Consumer<StorageProfileChange> changer = t -> ((PersistentPageMemoryProfileChange)t.convert(PersistentPageMemoryProfileChange.class)).changeSizeBytes(regionCfg.getMaxSize()).changeReplacementMode(regionCfg.getPageReplacementMode().name());
        storageConfig.profiles().change(c -> c.createOrUpdate(regionName, changer)).get();
    }

    private static void convertMemoryRegion(ConfigurationRegistryInterface registry, DataRegionConfiguration regionCfg, String regionName) throws ExecutionException, InterruptedException {
        StorageConfiguration storageConfig = ((StorageExtensionConfiguration)registry.getConfiguration(StorageExtensionConfiguration.KEY)).storage();
        Consumer<StorageProfileChange> changer = t -> ((VolatilePageMemoryProfileChange)t.convert(VolatilePageMemoryProfileChange.class)).changeInitSizeBytes(regionCfg.getInitialSize()).changeMaxSizeBytes(regionCfg.getMaxSize());
        storageConfig.profiles().change(c -> c.createOrUpdate(regionName, changer)).get();
    }

    @Override
    public void convert(IgniteConfiguration src, ConfigurationRegistryInterface registry) throws ExecutionException, InterruptedException {
        DataStorageConfiguration dataStorageCfg = src.getDataStorageConfiguration();
        if (dataStorageCfg == null) {
            LOGGER.warn("Could not find data storage configuration");
            return;
        }
        if (dataStorageCfg.getPageSize() != 0) {
            LOGGER.warn("Unable to force pageSize to :{}. Unsupported in Ignite 3", (Object)dataStorageCfg.getPageSize());
        }
        DataRegionConfiguration defaultRegionCfg = dataStorageCfg.getDefaultDataRegionConfiguration();
        DataRegionConfigurationConverter.convertDataRegion(registry, defaultRegionCfg, true);
        DataRegionConfiguration[] otherRegionCfgs = dataStorageCfg.getDataRegionConfigurations();
        if (otherRegionCfgs != null) {
            for (DataRegionConfiguration regionCfg : otherRegionCfgs) {
                DataRegionConfigurationConverter.convertDataRegion(registry, regionCfg, false);
            }
        }
    }
}

