/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.streamer.StreamerPartitionAwarenessProvider;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteUtils;

abstract class AbstractClientStreamerPartitionAwarenessProvider<T>
implements StreamerPartitionAwarenessProvider<T, Integer> {
    private final SchemaRegistry schemaReg;
    private final int partitions;

    AbstractClientStreamerPartitionAwarenessProvider(SchemaRegistry schemaReg, int partitions) {
        assert (schemaReg != null);
        this.schemaReg = schemaReg;
        this.partitions = partitions;
    }

    @Override
    public Integer partition(T item) {
        int colocationHash = this.colocationHash(this.schemaReg.lastKnownSchema(), item);
        return IgniteUtils.safeAbs(colocationHash) % this.partitions;
    }

    abstract int colocationHash(SchemaDescriptor var1, T var2);

    @Override
    public CompletableFuture<Void> refreshAsync() {
        return CompletableFutures.nullCompletedFuture();
    }
}

