/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.exception.handler.replacement;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.UnsatisfiedRouteHandler;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.constants.HttpCode;
import org.apache.ignite3.internal.rest.problem.HttpProblemResponse;

@Singleton
@Replaces(value=UnsatisfiedRouteHandler.class)
@Requires(classes={UnsatisfiedRouteException.class, ExceptionHandler.class})
public class UnsatisfiedRouteHandlerReplacement
implements ExceptionHandler<UnsatisfiedRouteException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, UnsatisfiedRouteException exception) {
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.BAD_REQUEST).detail(exception.getMessage()));
    }
}

