/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class RaftGroupConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final long UNKNOWN_INDEX = -1L;
    public static final long UNKNOWN_TERM = -1L;
    private final long index;
    private final long term;
    @IgniteToStringInclude
    private final List<String> peers;
    @IgniteToStringInclude
    private final List<String> learners;
    @IgniteToStringInclude
    @Nullable
    private final List<String> oldPeers;
    @IgniteToStringInclude
    @Nullable
    private final List<String> oldLearners;

    public RaftGroupConfiguration(long index, long term, Collection<String> peers, Collection<String> learners, @Nullable Collection<String> oldPeers, @Nullable Collection<String> oldLearners) {
        this.index = index;
        this.term = term;
        this.peers = List.copyOf(peers);
        this.learners = List.copyOf(learners);
        this.oldPeers = oldPeers == null ? null : List.copyOf(oldPeers);
        this.oldLearners = oldLearners == null ? null : List.copyOf(oldLearners);
    }

    public long index() {
        return this.index;
    }

    public long term() {
        return this.term;
    }

    public List<String> peers() {
        return this.peers;
    }

    public List<String> learners() {
        return this.learners;
    }

    @Nullable
    public List<String> oldPeers() {
        return this.oldPeers;
    }

    @Nullable
    public List<String> oldLearners() {
        return this.oldLearners;
    }

    public boolean isStable() {
        return this.oldPeers == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RaftGroupConfiguration that = (RaftGroupConfiguration)o;
        return this.index == that.index && this.term == that.term && Objects.equals(this.peers, that.peers) && Objects.equals(this.learners, that.learners) && Objects.equals(this.oldPeers, that.oldPeers) && Objects.equals(this.oldLearners, that.oldLearners);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.term, this.peers, this.learners, this.oldPeers, this.oldLearners);
    }

    public String toString() {
        return S.toString(RaftGroupConfiguration.class, this);
    }
}

