/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.tree.io;

import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.pagememory.util.PageUtils;

public abstract class BplusLeafIo<L>
extends BplusIo<L> {
    protected BplusLeafIo(int type, int ver, int itemSize) {
        super(type, ver, true, true, itemSize);
    }

    @Override
    public int getMaxCount(long pageAddr, int pageSize) {
        return (pageSize - 56) / this.getItemSize();
    }

    @Override
    public final void copyItems(long srcPageAddr, long dstPageAddr, int srcIdx, int dstIdx, int cnt, boolean cpLeft) {
        assert (srcIdx != dstIdx || srcPageAddr != dstPageAddr);
        this.assertPageType(dstPageAddr);
        PageUtils.copyMemory(srcPageAddr, (long)this.offset(srcIdx), dstPageAddr, (long)this.offset(dstIdx), (long)cnt * (long)this.getItemSize());
    }

    @Override
    public final int offset(int idx) {
        assert (idx >= 0) : idx;
        return 56 + idx * this.getItemSize();
    }
}

