/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite3.internal.metastorage.command.PutCommand;
import org.apache.ignite3.internal.metastorage.command.PutCommandBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class PutCommandDeserializer
implements MessageDeserializer<PutCommand> {
    private final PutCommandBuilder msg;

    PutCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.putCommand();
    }

    @Override
    public Class<PutCommand> klass() {
        return PutCommand.class;
    }

    @Override
    public PutCommand getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initiatorTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 1: {
                Comparable<HybridTimestamp> tmp = reader.readByteBuffer("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.key((ByteBuffer)tmp);
                reader.incrementState();
            }
            case 2: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.safeTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 3: {
                Comparable<HybridTimestamp> tmp = reader.readByteBuffer("value");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.value((ByteBuffer)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(PutCommand.class);
    }
}

