/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.client.proto.ColumnTypeConverter;
import org.apache.ignite3.internal.sql.ColumnMetadataImpl;
import org.apache.ignite3.internal.sql.ResultSetMetadataImpl;
import org.apache.ignite3.sql.ColumnMetadata;
import org.apache.ignite3.sql.ColumnType;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

final class ClientResultSetMetadata {
    ClientResultSetMetadata() {
    }

    @Nullable
    static ResultSetMetadata read(ClientMessageUnpacker unpacker) {
        int size = unpacker.unpackInt();
        if (size == 0) {
            return null;
        }
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(size);
        for (int i = 0; i < size; ++i) {
            columns.add(ClientResultSetMetadata.readColumn(unpacker, columns));
        }
        return new ResultSetMetadataImpl(columns);
    }

    private static ColumnMetadata readColumn(ClientMessageUnpacker unpacker, ArrayList<ColumnMetadata> prevColumns) {
        ColumnMetadata.ColumnOrigin origin;
        int propCnt = unpacker.unpackInt();
        assert (propCnt >= 6);
        String name = unpacker.unpackString();
        boolean nullable = unpacker.unpackBoolean();
        ColumnType type = ColumnTypeConverter.fromIdOrThrow(unpacker.unpackInt());
        int scale = unpacker.unpackInt();
        int precision = unpacker.unpackInt();
        if (unpacker.unpackBoolean()) {
            assert (propCnt >= 9);
            origin = ClientResultSetMetadata.readOrigin(unpacker, name, prevColumns);
        } else {
            origin = null;
        }
        return new ColumnMetadataImpl(name, type, precision, scale, nullable, origin);
    }

    private static ColumnMetadata.ColumnOrigin readOrigin(ClientMessageUnpacker unpacker, String cursorColumnName, List<ColumnMetadata> prevColumns) {
        String columnName = unpacker.tryUnpackNil() ? cursorColumnName : unpacker.unpackString();
        int schemaNameIdx = unpacker.tryUnpackInt(-1);
        String schemaName = schemaNameIdx == -1 ? unpacker.unpackString() : prevColumns.get(schemaNameIdx).origin().schemaName();
        int tableNameIdx = unpacker.tryUnpackInt(-1);
        String tableName = tableNameIdx == -1 ? unpacker.unpackString() : prevColumns.get(tableNameIdx).origin().tableName();
        return new ColumnMetadataImpl.ColumnOriginImpl(schemaName, tableName, columnName);
    }
}

