/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.util.Preconditions;

@Internal
public final class MatchFamilyTypeStrategy
implements TypeStrategy {
    private final int argumentPos;
    private final LogicalTypeFamily matchingTypeFamily;

    public MatchFamilyTypeStrategy(int argumentPos, LogicalTypeFamily matchingTypeFamily) {
        this.argumentPos = argumentPos;
        this.matchingTypeFamily = (LogicalTypeFamily)((Object)Preconditions.checkNotNull((Object)((Object)matchingTypeFamily)));
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        DataType argumentDataType = callContext.getArgumentDataTypes().get(this.argumentPos);
        if (argumentDataType.getLogicalType().is(this.matchingTypeFamily)) {
            return Optional.of(argumentDataType);
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchFamilyTypeStrategy that = (MatchFamilyTypeStrategy)o;
        return this.argumentPos == that.argumentPos && this.matchingTypeFamily == that.matchingTypeFamily;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.argumentPos, this.matchingTypeFamily});
    }
}

