/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.inference.strategies.StrategyUtils;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
public final class ItemAtTypeStrategy
implements TypeStrategy {
    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        DataType arrayOrMapType = callContext.getArgumentDataTypes().get(0);
        Optional<DataType> legacyArrayElement = StrategyUtils.extractLegacyArrayElement(arrayOrMapType);
        if (legacyArrayElement.isPresent()) {
            return legacyArrayElement;
        }
        if (arrayOrMapType.getLogicalType().is(LogicalTypeRoot.ARRAY)) {
            return Optional.of((DataType)((CollectionDataType)arrayOrMapType).getElementDataType().nullable());
        }
        if (arrayOrMapType instanceof KeyValueDataType) {
            return Optional.of((DataType)((KeyValueDataType)arrayOrMapType).getValueDataType().nullable());
        }
        return Optional.empty();
    }
}

