/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.extraction;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.procedures.Procedure;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.BaseMappingExtractor;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.extraction.FunctionResultTemplate;
import org.apache.flink.table.types.extraction.FunctionTemplate;
import org.apache.flink.table.types.extraction.TemplateUtils;

@Internal
final class ProcedureMappingExtractor
extends BaseMappingExtractor {
    private final Class<? extends Procedure> procedure;

    ProcedureMappingExtractor(DataTypeFactory typeFactory, Class<? extends Procedure> procedure, String methodName, BaseMappingExtractor.SignatureExtraction signatureExtraction, BaseMappingExtractor.ResultExtraction resultExtraction, BaseMappingExtractor.MethodVerification verification) {
        super(typeFactory, methodName, signatureExtraction, resultExtraction, verification);
        this.procedure = procedure;
    }

    static BaseMappingExtractor.ResultExtraction createOutputFromArrayReturnTypeInMethod() {
        return (extractor, method) -> {
            DataType dataType = DataTypeExtractor.extractFromMethodReturnType(extractor.typeFactory, extractor.getFunctionClass(), method, method.getReturnType().getComponentType());
            return FunctionResultTemplate.ofOutput(dataType);
        };
    }

    static BaseMappingExtractor.MethodVerification createParameterWithOptionalContextAndArrayReturnTypeVerification() {
        return (method, state, arguments, result) -> {
            boolean isValid;
            ProcedureMappingExtractor.checkNoState(state);
            ProcedureMappingExtractor.checkScalarArgumentsOnly(arguments);
            Class<?>[] parameters = ProcedureMappingExtractor.assembleParameters(null, arguments);
            Class[] parametersWithContext = (Class[])Stream.concat(Stream.of((Class)null), Arrays.stream(parameters)).toArray(Class[]::new);
            assert (result != null);
            Class<?> resultClass = result.toClass();
            Class<?> returnType = method.getReturnType();
            boolean bl = isValid = ExtractionUtils.isInvokable(ExtractionUtils.Autoboxing.STRICT, method, parametersWithContext) && returnType.isArray() && ExtractionUtils.isAssignable(resultClass, returnType.getComponentType(), ExtractionUtils.Autoboxing.JVM);
            if (!isValid) {
                throw ProcedureMappingExtractor.createMethodNotFoundError(method.getName(), parametersWithContext, Array.newInstance(resultClass, 0).getClass(), "(<context> [, <argument>]*)");
            }
        };
    }

    @Override
    protected Set<FunctionTemplate> extractGlobalFunctionTemplates() {
        return TemplateUtils.extractProcedureGlobalFunctionTemplates(this.typeFactory, this.procedure);
    }

    @Override
    protected Set<FunctionTemplate> extractLocalFunctionTemplates(Method method) {
        return TemplateUtils.extractProcedureLocalFunctionTemplates(this.typeFactory, method);
    }

    @Override
    protected List<Method> collectMethods(String methodName) {
        return ExtractionUtils.collectMethods(this.procedure, methodName);
    }

    @Override
    protected Class<?> getFunctionClass() {
        return this.procedure;
    }

    @Override
    protected String getHintType() {
        return "Procedure";
    }
}

