/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.materializedtable;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.materializedtable.AlterMaterializedTableOperation;

@Internal
public class AlterMaterializedTableAsQueryOperation
extends AlterMaterializedTableOperation {
    private final List<TableChange.MaterializedTableChange> tableChanges;
    private final CatalogMaterializedTable newMaterializedTable;

    public AlterMaterializedTableAsQueryOperation(ObjectIdentifier tableIdentifier, List<TableChange.MaterializedTableChange> tableChanges, CatalogMaterializedTable newMaterializedTable) {
        super(tableIdentifier);
        this.tableChanges = tableChanges;
        this.newMaterializedTable = newMaterializedTable;
    }

    public List<TableChange.MaterializedTableChange> getTableChanges() {
        return this.tableChanges;
    }

    public CatalogMaterializedTable getNewMaterializedTable() {
        return this.newMaterializedTable;
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        throw new UnsupportedOperationException("AlterMaterializedTableAsQueryOperation doesn't support ExecutableOperation yet.");
    }

    @Override
    public String asSummaryString() {
        return String.format("ALTER MATERIALIZED TABLE %s AS %s", this.tableIdentifier.asSummaryString(), this.newMaterializedTable.getDefinitionQuery());
    }
}

